"use client";
import {
  usePopoverStoreProps
} from "./RUY5BUJG.js";
import {
  useCompositeStoreOptions,
  useCompositeStoreProps
} from "./B7UTNDHN.js";
import {
  useComboboxProviderContext
} from "./OLVWQA7U.js";
import {
  useStore,
  useStoreProps
} from "./RTNCFSKZ.js";
import {
  useUpdateEffect
} from "./5GGHRIN3.js";
import {
  __spreadProps,
  __spreadValues
} from "./3YLGPPWQ.js";

// src/select/select-store.ts
import * as Core from "@ariakit/core/select/select-store";
function useSelectStoreOptions(props) {
  const combobox = useComboboxProviderContext();
  props = __spreadProps(__spreadValues({}, props), {
    combobox: props.combobox !== void 0 ? props.combobox : combobox
  });
  return useCompositeStoreOptions(props);
}
function useSelectStoreProps(store, update, props) {
  useUpdateEffect(update, [props.combobox]);
  useStoreProps(store, props, "value", "setValue");
  useStoreProps(store, props, "setValueOnMove");
  return Object.assign(
    usePopoverStoreProps(
      useCompositeStoreProps(store, update, props),
      update,
      props
    ),
    { combobox: props.combobox }
  );
}
function useSelectStore(props = {}) {
  props = useSelectStoreOptions(props);
  const [store, update] = useStore(Core.createSelectStore, props);
  return useSelectStoreProps(store, update, props);
}

export {
  useSelectStoreOptions,
  useSelectStoreProps,
  useSelectStore
};
