"use client";
import {
  getCollectionRendererItemId,
  useCollectionRenderer
} from "./FVD56SIN.js";
import {
  useCompositeContext
} from "./APTFW6PT.js";
import {
  useStoreState
} from "./RTNCFSKZ.js";
import {
  createElement,
  forwardRef
} from "./VOQWLFSQ.js";
import {
  useId
} from "./5GGHRIN3.js";
import {
  __objRest,
  __spreadProps,
  __spreadValues
} from "./3YLGPPWQ.js";

// src/composite/composite-renderer.tsx
import { useMemo } from "react";
var TagName = "div";
function getItemObject(item) {
  if (!item || typeof item !== "object") {
    return { value: item };
  }
  return item;
}
function countItems(items) {
  if (!items) return [0];
  if (typeof items === "number") {
    return Array.from({ length: items }, (_, index) => index + 1);
  }
  return items.reduce((count, item, index) => {
    var _a, _b;
    const object = getItemObject(item);
    if (!object.items) {
    }
    if (!object.items) {
      count[index] = index + 1;
      return count;
    }
    const prevCount = (_a = count[index - 1]) != null ? _a : 0;
    const itemsCount = (_b = countItems(object.items)[object.items.length - 1]) != null ? _b : 0;
    count[index] = prevCount + itemsCount;
    return count;
  }, []);
}
function findFirst(items, offset = 1) {
  for (let index = offset > 0 ? 0 : items.length - 1; index >= 0 && index < items.length; index += offset) {
    const item = items[index];
    const object = getItemObject(item);
    if (object.items && findFirst(object.items, offset) !== -1) return index;
    if (!object.disabled) return index;
  }
  return -1;
}
function findLast(items) {
  return findFirst(items, -1);
}
function findById(items, id, baseId) {
  return items.findIndex((item, index) => {
    var _a;
    const itemId = getCollectionRendererItemId(item, index, baseId);
    if (itemId === id) return true;
    const object = getItemObject(item);
    if ((_a = object.items) == null ? void 0 : _a.length) return findById(object.items, id, itemId) !== -1;
    const ids = id.split("/");
    if (ids.length === 1) return false;
    return ids.some((id2) => itemId === id2);
  });
}
function useCompositeRenderer(_a) {
  var _b = _a, {
    store,
    orientation: orientationProp,
    persistentIndices: persistentIndicesProp,
    children: renderItem,
    "aria-setsize": ariaSetSize,
    "aria-posinset": ariaPosInSet = 1
  } = _b, props = __objRest(_b, [
    "store",
    "orientation",
    "persistentIndices",
    "children",
    "aria-setsize",
    "aria-posinset"
  ]);
  const context = useCompositeContext();
  store = store || context;
  const orientation = useStoreState(
    store,
    (state) => (orientationProp != null ? orientationProp : (state == null ? void 0 : state.orientation) === "both") ? "vertical" : state == null ? void 0 : state.orientation
  );
  const items = useStoreState(store, (state) => {
    var _a2;
    if (!state) return props.items;
    if ("mounted" in state && !state.mounted) return 0;
    return (_a2 = props.items) != null ? _a2 : state.items;
  });
  const id = useId(props.id);
  const itemsCount = useMemo(() => countItems(items), [items]);
  const setSize = useMemo(
    () => {
      var _a2;
      return (_a2 = ariaSetSize != null ? ariaSetSize : itemsCount[itemsCount.length - 1]) != null ? _a2 : 0;
    },
    [ariaSetSize, itemsCount]
  );
  const firstIndex = useMemo(() => {
    if (!items) return -1;
    if (typeof items === "number") return 0;
    if (!items.length) return -1;
    return findFirst(items);
  }, [items]);
  const lastIndex = useMemo(() => {
    if (!items) return -1;
    if (typeof items === "number") return items - 1;
    if (!items.length) return -1;
    return findLast(items);
  }, [items]);
  const activeId = useStoreState(store, "activeId");
  const activeIndex = useMemo(() => {
    if (!id) return -1;
    if (!items) return -1;
    if (activeId == null) return -1;
    if (typeof items === "number") return -1;
    if (!items.length) return -1;
    return findById(items, activeId, id);
  }, [id, items, activeId]);
  const persistentIndices = useMemo(() => {
    const indices = [firstIndex, activeIndex, lastIndex].filter(
      (index) => index >= 0
    );
    if (persistentIndicesProp) {
      return [...persistentIndicesProp, ...indices];
    }
    return indices;
  }, [firstIndex, activeIndex, lastIndex, persistentIndicesProp]);
  return useCollectionRenderer(__spreadProps(__spreadValues({
    id,
    store,
    orientation,
    persistentIndices
  }, props), {
    children: (item) => {
      var _a2;
      const nextItem = __spreadProps(__spreadValues({}, item), {
        "aria-setsize": setSize,
        "aria-posinset": ariaPosInSet + ((_a2 = itemsCount[item.index - 1]) != null ? _a2 : 0)
      });
      return renderItem == null ? void 0 : renderItem(nextItem);
    }
  }));
}
var CompositeRenderer = forwardRef(function CompositeRenderer2(props) {
  const htmlProps = useCompositeRenderer(props);
  return createElement(TagName, htmlProps);
});

export {
  useCompositeRenderer,
  CompositeRenderer
};
