"use client";

// src/dialog/utils/use-previous-mouse-down-ref.ts
import { addGlobalEventListener } from "@ariakit/core/utils/events";
import { useEffect, useRef } from "react";
function usePreviousMouseDownRef(enabled) {
  const previousMouseDownRef = useRef();
  useEffect(() => {
    if (!enabled) {
      previousMouseDownRef.current = null;
      return;
    }
    const onMouseDown = (event) => {
      previousMouseDownRef.current = event.target;
    };
    return addGlobalEventListener("mousedown", onMouseDown, true);
  }, [enabled]);
  return previousMouseDownRef;
}

export {
  usePreviousMouseDownRef
};
