"use client";
import {
  useTagContext
} from "./VJQU3YUE.js";
import {
  usePopoverStoreProps
} from "./RUY5BUJG.js";
import {
  useCompositeStoreOptions,
  useCompositeStoreProps
} from "./B7UTNDHN.js";
import {
  useStore,
  useStoreProps
} from "./RTNCFSKZ.js";
import {
  useUpdateEffect
} from "./5GGHRIN3.js";
import {
  __spreadProps,
  __spreadValues
} from "./3YLGPPWQ.js";

// src/combobox/combobox-store.ts
import * as Core from "@ariakit/core/combobox/combobox-store";
function useComboboxStoreOptions(props) {
  const tag = useTagContext();
  props = __spreadProps(__spreadValues({}, props), {
    tag: props.tag !== void 0 ? props.tag : tag
  });
  return useCompositeStoreOptions(props);
}
function useComboboxStoreProps(store, update, props) {
  useUpdateEffect(update, [props.tag]);
  useStoreProps(store, props, "value", "setValue");
  useStoreProps(store, props, "selectedValue", "setSelectedValue");
  useStoreProps(store, props, "resetValueOnHide");
  useStoreProps(store, props, "resetValueOnSelect");
  return Object.assign(
    useCompositeStoreProps(
      usePopoverStoreProps(store, update, props),
      update,
      props
    ),
    { tag: props.tag }
  );
}
function useComboboxStore(props = {}) {
  props = useComboboxStoreOptions(props);
  const [store, update] = useStore(Core.createComboboxStore, props);
  return useComboboxStoreProps(store, update, props);
}

export {
  useComboboxStoreOptions,
  useComboboxStoreProps,
  useComboboxStore
};
