"use client";
import {
  markAncestor
} from "./3NDVDEB4.js";
import {
  useDisclosureContent
} from "./K4R5DNTX.js";
import {
  useDisclosureStore
} from "./T22PY7TE.js";
import {
  Role
} from "./QJ4LGO2N.js";
import {
  useStoreState
} from "./RTNCFSKZ.js";
import {
  useSafeLayoutEffect
} from "./5GGHRIN3.js";
import {
  __spreadProps,
  __spreadValues
} from "./3YLGPPWQ.js";

// src/dialog/dialog-backdrop.tsx
import { isValidElement, useEffect, useRef } from "react";
import { jsx } from "react/jsx-runtime";
function DialogBackdrop({
  store,
  backdrop,
  alwaysVisible,
  hidden
}) {
  const ref = useRef(null);
  const disclosure = useDisclosureStore({ disclosure: store });
  const contentElement = useStoreState(store, "contentElement");
  useEffect(() => {
    const backdrop2 = ref.current;
    const dialog = contentElement;
    if (!backdrop2) return;
    if (!dialog) return;
    backdrop2.style.zIndex = getComputedStyle(dialog).zIndex;
  }, [contentElement]);
  useSafeLayoutEffect(() => {
    const id = contentElement == null ? void 0 : contentElement.id;
    if (!id) return;
    const backdrop2 = ref.current;
    if (!backdrop2) return;
    return markAncestor(backdrop2, id);
  }, [contentElement]);
  const props = useDisclosureContent({
    ref,
    store: disclosure,
    role: "presentation",
    "data-backdrop": (contentElement == null ? void 0 : contentElement.id) || "",
    alwaysVisible,
    hidden: hidden != null ? hidden : void 0,
    style: {
      position: "fixed",
      top: 0,
      right: 0,
      bottom: 0,
      left: 0
    }
  });
  if (!backdrop) return null;
  if (isValidElement(backdrop)) {
    return /* @__PURE__ */ jsx(Role, __spreadProps(__spreadValues({}, props), { render: backdrop }));
  }
  const Component = typeof backdrop !== "boolean" ? backdrop : "div";
  return /* @__PURE__ */ jsx(Role, __spreadProps(__spreadValues({}, props), { render: /* @__PURE__ */ jsx(Component, {}) }));
}

export {
  DialogBackdrop
};
