"use client";
import {
  useMenuContext
} from "./4QTMCR75.js";
import {
  useMenubarContext
} from "./JUCYQ5OS.js";
import {
  useHovercardStoreProps
} from "./GVVKDT6A.js";
import {
  useCompositeStoreProps
} from "./B7UTNDHN.js";
import {
  useComboboxProviderContext
} from "./OLVWQA7U.js";
import {
  useStore,
  useStoreProps
} from "./RTNCFSKZ.js";
import {
  useUpdateEffect
} from "./5GGHRIN3.js";
import {
  __spreadProps,
  __spreadValues
} from "./3YLGPPWQ.js";

// src/menu/menu-store.ts
import * as Core from "@ariakit/core/menu/menu-store";
function useMenuStoreProps(store, update, props) {
  useUpdateEffect(update, [props.combobox, props.parent, props.menubar]);
  useStoreProps(store, props, "values", "setValues");
  return Object.assign(
    useHovercardStoreProps(
      useCompositeStoreProps(store, update, props),
      update,
      props
    ),
    {
      combobox: props.combobox,
      parent: props.parent,
      menubar: props.menubar
    }
  );
}
function useMenuStore(props = {}) {
  const parent = useMenuContext();
  const menubar = useMenubarContext();
  const combobox = useComboboxProviderContext();
  props = __spreadProps(__spreadValues({}, props), {
    parent: props.parent !== void 0 ? props.parent : parent,
    menubar: props.menubar !== void 0 ? props.menubar : menubar,
    combobox: props.combobox !== void 0 ? props.combobox : combobox
  });
  const [store, update] = useStore(Core.createMenuStore, props);
  return useMenuStoreProps(store, update, props);
}

export {
  useMenuStoreProps,
  useMenuStore
};
