"use client";
import {
  useCollectionStoreProps
} from "./AMMIPFT4.js";
import {
  useStore,
  useStoreProps
} from "./RTNCFSKZ.js";
import {
  useId
} from "./5GGHRIN3.js";
import {
  __spreadValues
} from "./3YLGPPWQ.js";

// src/composite/composite-store.ts
import * as Core from "@ariakit/core/composite/composite-store";
function useCompositeStoreOptions(props) {
  const id = useId(props.id);
  return __spreadValues({ id }, props);
}
function useCompositeStoreProps(store, update, props) {
  store = useCollectionStoreProps(store, update, props);
  useStoreProps(store, props, "activeId", "setActiveId");
  useStoreProps(store, props, "includesBaseElement");
  useStoreProps(store, props, "virtualFocus");
  useStoreProps(store, props, "orientation");
  useStoreProps(store, props, "rtl");
  useStoreProps(store, props, "focusLoop");
  useStoreProps(store, props, "focusWrap");
  useStoreProps(store, props, "focusShift");
  return store;
}
function useCompositeStore(props = {}) {
  props = useCompositeStoreOptions(props);
  const [store, update] = useStore(Core.createCompositeStore, props);
  return useCompositeStoreProps(store, update, props);
}

export {
  useCompositeStoreOptions,
  useCompositeStoreProps,
  useCompositeStore
};
