"use client";
import {
  usePopoverContext
} from "./Y67KZUMI.js";
import {
  createElement,
  createHook,
  forwardRef
} from "./VOQWLFSQ.js";
import {
  __objRest,
  __spreadProps,
  __spreadValues
} from "./3YLGPPWQ.js";

// src/popover/popover-disclosure-arrow.tsx
import { invariant, removeUndefinedValues } from "@ariakit/core/utils/misc";
import { useMemo } from "react";
import { jsx } from "react/jsx-runtime";
var TagName = "span";
var pointsMap = {
  top: "4,10 8,6 12,10",
  right: "6,4 10,8 6,12",
  bottom: "4,6 8,10 12,6",
  left: "10,4 6,8 10,12"
};
var usePopoverDisclosureArrow = createHook(function usePopoverDisclosureArrow2(_a) {
  var _b = _a, { store, placement } = _b, props = __objRest(_b, ["store", "placement"]);
  const context = usePopoverContext();
  store = store || context;
  invariant(
    store,
    process.env.NODE_ENV !== "production" && "PopoverDisclosureArrow must be wrapped in a PopoverDisclosure component."
  );
  const position = store.useState((state) => placement || state.placement);
  const dir = position.split("-")[0];
  const points = pointsMap[dir];
  const children = useMemo(
    () => /* @__PURE__ */ jsx(
      "svg",
      {
        display: "block",
        fill: "none",
        stroke: "currentColor",
        strokeLinecap: "round",
        strokeLinejoin: "round",
        strokeWidth: 1.5,
        viewBox: "0 0 16 16",
        height: "1em",
        width: "1em",
        children: /* @__PURE__ */ jsx("polyline", { points })
      }
    ),
    [points]
  );
  props = __spreadProps(__spreadValues({
    children,
    "aria-hidden": true
  }, props), {
    style: __spreadValues({
      width: "1em",
      height: "1em",
      pointerEvents: "none"
    }, props.style)
  });
  return removeUndefinedValues(props);
});
var PopoverDisclosureArrow = forwardRef(
  function PopoverDisclosureArrow2(props) {
    const htmlProps = usePopoverDisclosureArrow(props);
    return createElement(TagName, htmlProps);
  }
);

export {
  usePopoverDisclosureArrow,
  PopoverDisclosureArrow
};
