"use client";
import {
  MenubarContextProvider,
  MenubarScopedContextProvider,
  useMenubarContext,
  useMenubarProviderContext,
  useMenubarScopedContext
} from "./JUCYQ5OS.js";
import {
  HovercardContextProvider,
  HovercardScopedContextProvider
} from "./7Z7JH52O.js";
import {
  CompositeContextProvider,
  CompositeScopedContextProvider
} from "./APTFW6PT.js";
import {
  createStoreContext
} from "./VOQWLFSQ.js";

// src/menu/menu-context.tsx
import { createContext } from "react";
var menu = createStoreContext(
  [CompositeContextProvider, HovercardContextProvider],
  [CompositeScopedContextProvider, HovercardScopedContextProvider]
);
var useMenuContext = menu.useContext;
var useMenuScopedContext = menu.useScopedContext;
var useMenuProviderContext = menu.useProviderContext;
var MenuContextProvider = menu.ContextProvider;
var MenuScopedContextProvider = menu.ScopedContextProvider;
var useMenuBarContext = useMenubarContext;
var useMenuBarScopedContext = useMenubarScopedContext;
var useMenuBarProviderContext = useMenubarProviderContext;
var MenuBarContextProvider = MenubarContextProvider;
var MenuBarScopedContextProvider = MenubarScopedContextProvider;
var MenuItemCheckedContext = createContext(
  void 0
);

export {
  useMenuContext,
  useMenuScopedContext,
  useMenuProviderContext,
  MenuContextProvider,
  MenuScopedContextProvider,
  useMenuBarContext,
  useMenuBarScopedContext,
  useMenuBarProviderContext,
  MenuBarContextProvider,
  MenuBarScopedContextProvider,
  MenuItemCheckedContext
};
