"use client";
import {
  usePopoverAnchor
} from "./HMCFFQCB.js";
import {
  useDialogDisclosure
} from "./ZTXFEM5L.js";
import {
  PopoverScopedContextProvider,
  usePopoverProviderContext
} from "./Y67KZUMI.js";
import {
  createElement,
  createHook,
  forwardRef
} from "./VOQWLFSQ.js";
import {
  useEvent,
  useWrapElement
} from "./5GGHRIN3.js";
import {
  __objRest,
  __spreadProps,
  __spreadValues
} from "./3YLGPPWQ.js";

// src/popover/popover-disclosure.tsx
import { invariant } from "@ariakit/core/utils/misc";
import { jsx } from "react/jsx-runtime";
var TagName = "button";
var usePopoverDisclosure = createHook(function usePopoverDisclosure2(_a) {
  var _b = _a, { store } = _b, props = __objRest(_b, ["store"]);
  const context = usePopoverProviderContext();
  store = store || context;
  invariant(
    store,
    process.env.NODE_ENV !== "production" && "PopoverDisclosure must receive a `store` prop or be wrapped in a PopoverProvider component."
  );
  const onClickProp = props.onClick;
  const onClick = useEvent((event) => {
    store == null ? void 0 : store.setAnchorElement(event.currentTarget);
    onClickProp == null ? void 0 : onClickProp(event);
  });
  props = useWrapElement(
    props,
    (element) => /* @__PURE__ */ jsx(PopoverScopedContextProvider, { value: store, children: element }),
    [store]
  );
  props = __spreadProps(__spreadValues({}, props), {
    onClick
  });
  props = usePopoverAnchor(__spreadValues({ store }, props));
  props = useDialogDisclosure(__spreadValues({ store }, props));
  return props;
});
var PopoverDisclosure = forwardRef(function PopoverDisclosure2(props) {
  const htmlProps = usePopoverDisclosure(props);
  return createElement(TagName, htmlProps);
});

export {
  usePopoverDisclosure,
  PopoverDisclosure
};
