import type { AnyObject, EmptyObject } from "@ariakit/core/utils/types";
import * as React from "react";
import type { Store } from "./store.ts";
import type { Hook, HTMLProps, Options, Props } from "./types.ts";
/**
 * The same as `React.forwardRef` but passes the `ref` as a prop and returns a
 * component with the same generic type.
 */
export declare function forwardRef<T extends React.FC<any>>(render: T): T;
/**
 * The same as `React.memo` but returns a component with the same generic type.
 */
export declare function memo<T extends React.FC<any>>(Component: T, propsAreEqual?: (prevProps: Readonly<React.ComponentPropsWithoutRef<T>>, nextProps: Readonly<React.ComponentPropsWithoutRef<T>>) => boolean): T;
/**
 * Creates a React element that supports the `render` and `wrapElement` props.
 */
export declare function createElement(Type: React.ElementType, props: Props<React.ElementType, Options>): React.ReactElement<any, string | React.JSXElementConstructor<any>>;
/**
 * Creates a component hook that accepts props and returns props so they can be
 * passed to a React element.
 */
export declare function createHook<T extends React.ElementType, P extends AnyObject = EmptyObject>(useProps: (props: Props<T, P>) => HTMLProps<T, P>): Hook<T, P>;
type StoreProvider<T extends Store> = React.ComponentType<{
    value: T | undefined;
    children?: React.ReactNode;
}>;
/**
 * Creates an Ariakit store context with hooks and provider components.
 */
export declare function createStoreContext<T extends Store>(providers?: StoreProvider<T>[], scopedProviders?: StoreProvider<T>[]): {
    context: React.Context<T | undefined>;
    scopedContext: React.Context<T | undefined>;
    useContext: () => T | undefined;
    useScopedContext: (onlyScoped?: boolean) => T | undefined;
    useProviderContext: () => T | undefined;
    ContextProvider: (props: React.ComponentPropsWithoutRef<React.Provider<T | undefined>>) => import("react/jsx-runtime").JSX.Element;
    ScopedContextProvider: (props: React.ComponentPropsWithoutRef<React.Provider<T | undefined>>) => import("react/jsx-runtime").JSX.Element;
};
export {};
