import type { TooltipStore } from "./tooltip-store.ts";
/**
 * Returns the tooltip store from the nearest tooltip container.
 * @example
 * function Tooltip() {
 *   const store = useTooltipContext();
 *
 *   if (!store) {
 *     throw new Error("Tooltip must be wrapped in TooltipProvider");
 *   }
 *
 *   // Use the store...
 * }
 */
export declare const useTooltipContext: () => TooltipStore | undefined;
export declare const useTooltipScopedContext: (onlyScoped?: boolean) => TooltipStore | undefined;
export declare const useTooltipProviderContext: () => TooltipStore | undefined;
export declare const TooltipContextProvider: (props: import("react").ProviderProps<TooltipStore | undefined>) => import("react/jsx-runtime").JSX.Element;
export declare const TooltipScopedContextProvider: (props: import("react").ProviderProps<TooltipStore | undefined>) => import("react/jsx-runtime").JSX.Element;
