import * as Core from "@ariakit/core/tab/tab-store";
import type { ComboboxStore } from "../combobox/combobox-store.ts";
import type { CompositeStore, CompositeStoreFunctions, CompositeStoreOptions, CompositeStoreState } from "../composite/composite-store.ts";
import type { Store } from "../utils/store.tsx";
export declare function useTabStoreProps<T extends Core.TabStore>(store: T, update: () => void, props: TabStoreProps): T & {
    panels: import("@ariakit/core/collection/collection-store").CollectionStore<Core.TabStorePanel> & {
        useState: import("../utils/store.tsx").UseState<import("@ariakit/core/collection/collection-store").CollectionStoreState<Core.TabStorePanel>>;
    };
} & {
    composite: CompositeStore<import("../composite/composite-store.ts").CompositeStoreItem> | null | undefined;
    combobox: ComboboxStore<import("@ariakit/core/combobox/combobox-store").ComboboxStoreSelectedValue> | null | undefined;
};
/**
 * Creates a tab store to control the state of
 * [Tab](https://ariakit.org/components/tab) components.
 * @see https://ariakit.org/components/tab
 * @example
 * ```jsx
 * const tab = useTabStore();
 *
 * <TabList store={tab}>
 *   <Tab>Tab 1</Tab>
 *   <Tab>Tab 2</Tab>
 * </TabList>
 * <TabPanel store={tab}>Panel 1</TabPanel>
 * <TabPanel store={tab}>Panel 2</TabPanel>
 * ```
 */
export declare function useTabStore(props?: TabStoreProps): TabStore;
export interface TabStoreItem extends Core.TabStoreItem {
}
export interface TabStoreState extends Core.TabStoreState, CompositeStoreState<TabStoreItem> {
}
export interface TabStoreFunctions extends Pick<TabStoreOptions, "composite" | "combobox">, Omit<Core.TabStoreFunctions, "panels" | "composite" | "combobox">, CompositeStoreFunctions<TabStoreItem> {
    panels: Store<Core.TabStoreFunctions["panels"]>;
}
export interface TabStoreOptions extends Omit<Core.TabStoreOptions, "composite" | "combobox">, CompositeStoreOptions<TabStoreItem> {
    /**
     * Function that will be called when the
     * [`selectedId`](https://ariakit.org/reference/tab-provider#selectedid) state
     * changes.
     *
     * Live examples:
     * - [Combobox with Tabs](https://ariakit.org/examples/combobox-tabs)
     * - [Select with Combobox and
     *   Tabs](https://ariakit.org/examples/select-combobox-tab)
     * - [Command Menu with
     *   Tabs](https://ariakit.org/examples/dialog-combobox-tab-command-menu)
     */
    setSelectedId?: (selectedId: TabStoreState["selectedId"]) => void;
    /**
     * A reference to another [composite
     * store](https://ariakit.org/reference/use-composite-store). This is
     * automatically set when rendering tabs as part of another composite widget,
     * such as [Combobox](https://ariakit.org/components/combobox) or
     * [Select](https://ariakit.org/components/select).
     *
     * Live examples:
     * - [Combobox with Tabs](https://ariakit.org/examples/combobox-tabs)
     */
    composite?: CompositeStore | null;
    /**
     * A reference to a [combobox
     * store](https://ariakit.org/reference/use-combobox-store). This is
     * automatically set when rendering tabs inside a
     * [Combobox](https://ariakit.org/components/combobox).
     *
     * Live examples:
     * - [Combobox with Tabs](https://ariakit.org/examples/combobox-tabs)
     */
    combobox?: ComboboxStore | null;
}
export interface TabStoreProps extends TabStoreOptions, Omit<Core.TabStoreProps, "composite" | "combobox"> {
}
export interface TabStore extends TabStoreFunctions, Omit<Store<Core.TabStore>, "panels" | "composite" | "combobox"> {
}
