import type { TabStore } from "./tab-store.ts";
/**
 * Returns the tab store from the nearest tab container.
 * @example
 * function Tab() {
 *   const store = useTabContext();
 *
 *   if (!store) {
 *     throw new Error("Tab must be wrapped in TabProvider");
 *   }
 *
 *   // Use the store...
 * }
 */
export declare const useTabContext: () => TabStore | undefined;
export declare const useTabScopedContext: (onlyScoped?: boolean) => TabStore | undefined;
export declare const useTabProviderContext: () => TabStore | undefined;
export declare const TabContextProvider: (props: import("react").ProviderProps<TabStore | undefined>) => import("react/jsx-runtime").JSX.Element;
export declare const TabScopedContextProvider: (props: import("react").ProviderProps<TabStore | undefined>) => import("react/jsx-runtime").JSX.Element;
