import type { CompositeRendererBaseItemProps, CompositeRendererItem, CompositeRendererItemObject, CompositeRendererItemProps, CompositeRendererOptions } from "../composite/composite-renderer.tsx";
import { getCompositeRendererItem, getCompositeRendererItemId } from "../composite/composite-renderer.tsx";
import type { Props } from "../utils/types.ts";
import type { SelectStore, SelectStoreValue } from "./select-store.ts";
declare const TagName = "div";
type TagName = typeof TagName;
interface ItemObject extends CompositeRendererItemObject {
    value?: string;
}
type Item = ItemObject | CompositeRendererItem;
type BaseItemProps = CompositeRendererBaseItemProps;
type ItemProps<T extends Item, P extends BaseItemProps = BaseItemProps> = CompositeRendererItemProps<T, P>;
export declare const SelectRenderer: <T extends Item = any>(props: SelectRendererProps<T>) => import("react").ReactElement<any, string | import("react").JSXElementConstructor<any>>;
export { getCompositeRendererItem as getSelectRendererItem, getCompositeRendererItemId as getSelectRendererItemId, };
export type SelectRendererItemObject = ItemObject;
export type SelectRendererItem = Item;
export type SelectRendererBaseItemProps = BaseItemProps;
export type SelectRendererItemProps<T extends Item, P extends BaseItemProps = BaseItemProps> = ItemProps<T, P>;
export interface SelectRendererOptions<T extends Item = any> extends Omit<CompositeRendererOptions<T>, "store"> {
    /**
     * Object returned by the
     * [`useSelectStore`](https://ariakit.org/reference/use-select-store) hook. If
     * not provided, the closest [Select](https://ariakit.org/components/select)
     * component's context will be used.
     *
     * The store [`items`](https://ariakit.org/reference/use-select-store#items)
     * state will be used to render the items if the
     * [`items`](https://ariakit.org/reference/select-items#items) prop is not
     * provided.
     */
    store?: SelectStore;
    /**
     * The current value of the select. This will ensure the item with the given
     * value is rendered even if it's not in the viewport, so it can be
     * automatically focused when the select popover is opened. If not provided,
     * the value will be read from the store.
     */
    value?: SelectStoreValue;
}
export interface SelectRendererProps<T extends Item = any> extends Props<TagName, SelectRendererOptions<T>> {
}
