import type { BooleanOrCallback } from "@ariakit/core/utils/types";
import type { ElementType, KeyboardEvent } from "react";
import type { CompositeOptions } from "../composite/composite.tsx";
import type { CompositeTypeaheadOptions } from "../composite/composite-typeahead.tsx";
import type { DisclosureContentOptions } from "../disclosure/disclosure-content.tsx";
import type { Props } from "../utils/types.ts";
import type { SelectStore } from "./select-store.ts";
declare const TagName = "div";
type TagName = typeof TagName;
/**
 * Returns props to create a `SelectList` component.
 * @see https://ariakit.org/components/select
 * @example
 * ```jsx
 * const store = useSelectStore();
 * const props = useSelectList({ store });
 * <Role {...props}>
 *   <SelectItem value="Apple" />
 *   <SelectItem value="Orange" />
 * </Role>
 * ```
 */
export declare const useSelectList: import("../utils/types.ts").Hook<"div", SelectListOptions<"div">>;
/**
 * Renders a wrapper for
 * [`SelectItem`](https://ariakit.org/reference/select-item) elements. This
 * component may be rendered within a
 * [`SelectPopover`](https://ariakit.org/reference/select-popover) component if
 * there are other non-item elements inside the popover.
 *
 * The `aria-labelledby` prop is set to the
 * [`Select`](https://ariakit.org/reference/select) element's `id` by default.
 * @see https://ariakit.org/components/select
 * @example
 * ```jsx {5-8}
 * <SelectProvider>
 *   <Select />
 *   <SelectPopover>
 *     <SelectDismiss />
 *     <SelectList>
 *       <SelectItem value="Apple" />
 *       <SelectItem value="Orange" />
 *     </SelectList>
 *   </SelectPopover>
 * </SelectProvider>
 * ```
 */
export declare const SelectList: (props: SelectListProps) => import("react").ReactElement<any, string | import("react").JSXElementConstructor<any>>;
export interface SelectListOptions<T extends ElementType = TagName> extends CompositeOptions<T>, CompositeTypeaheadOptions<T>, Pick<DisclosureContentOptions, "alwaysVisible"> {
    /**
     * Object returned by the
     * [`useSelectStore`](https://ariakit.org/reference/use-select-store) hook. If
     * not provided, the closest
     * [`SelectProvider`](https://ariakit.org/reference/select-provider)
     * component's context will be used.
     */
    store?: SelectStore;
    /**
     * Whether the select value should be reset to the value before the list got
     * shown when Escape is pressed. This has effect only when
     * [`setValueOnMove`](https://ariakit.org/reference/select-provider#setvalueonmove)
     * is `true`.
     * @default true
     */
    resetOnEscape?: BooleanOrCallback<KeyboardEvent<HTMLElement>>;
    /**
     * Whether the [`SelectList`](https://ariakit.org/reference/select-list) or
     * [`SelectPopover`](https://ariakit.org/reference/select-popover) components
     * should be hidden when the user presses Enter or Space while the list
     * element is focused and no item is active.
     * @default true
     */
    hideOnEnter?: BooleanOrCallback<KeyboardEvent<HTMLElement>>;
}
export type SelectListProps<T extends ElementType = TagName> = Props<T, SelectListOptions<T>>;
export {};
