import type { ElementType } from "react";
import { type CompositeItemOptions } from "../composite/composite-item-offscreen.tsx";
import type { Props } from "../utils/types.ts";
import * as Base from "./select-item.tsx";
declare const TagName = "div";
type TagName = typeof TagName;
export declare function useSelectItemOffscreen<T extends ElementType, P extends SelectItemProps<T>>({ store, value, ...props }: P): {
    id: string | undefined;
    active: boolean;
    ref: import("react").RefCallback<HTMLDivElement>;
    "data-offscreen": true | undefined;
} | {
    children: any;
    role: string | undefined;
    "aria-disabled": true | undefined;
    "data-offscreen-id": string | undefined;
    id: string | undefined;
    active: boolean;
    ref: import("react").RefCallback<HTMLDivElement>;
    "data-offscreen": true | undefined;
};
export declare const SelectItem: ({ offscreenBehavior, offscreenRoot, ...props }: SelectItemProps) => import("react/jsx-runtime").JSX.Element;
export interface SelectItemOptions<T extends ElementType = TagName> extends Base.SelectItemOptions<T>, Omit<CompositeItemOptions<T>, "store"> {
}
export type SelectItemProps<T extends ElementType = TagName> = Props<T, SelectItemOptions<T>>;
export {};
