import type { ElementType } from "react";
import type { Options, Props } from "../utils/types.ts";
import type { PopoverStore } from "./popover-store.ts";
declare const TagName = "div";
type TagName = typeof TagName;
/**
 * Returns props to create a `PopoverArrow` component.
 * @see https://ariakit.org/components/popover
 * @example
 * ```jsx
 * const store = usePopoverStore();
 * const props = usePopoverArrow({ store });
 * <Popover store={store}>
 *   <Role {...props} />
 *   Popover
 * </Popover>
 * ```
 */
export declare const usePopoverArrow: import("../utils/types.ts").Hook<"div", PopoverArrowOptions<"div">>;
/**
 * Renders an arrow inside a [`Popover`](https://ariakit.org/reference/popover)
 * component pointing to the anchor element.
 * @see https://ariakit.org/components/popover
 * @example
 * ```jsx {4}
 * <PopoverProvider>
 *   <PopoverAnchor />
 *   <Popover>
 *     <PopoverArrow />
 *     Popover
 *   </Popover>
 * </PopoverProvider>
 * ```
 */
export declare const PopoverArrow: (props: PopoverArrowProps) => import("react").ReactElement<any, string | import("react").JSXElementConstructor<any>>;
export interface PopoverArrowOptions<_T extends ElementType = TagName> extends Options {
    /**
     * Object returned by the
     * [`usePopoverStore`](https://ariakit.org/reference/use-popover-store) hook.
     * If not provided, the closest
     * [`Popover`](https://ariakit.org/reference/popover) or
     * [`PopoverProvider`](https://ariakit.org/reference/popover-provider)
     * components' context will be used.
     */
    store?: PopoverStore;
    /**
     * The size of the arrow.
     *
     * Live examples:
     * - [Selection Popover](https://ariakit.org/examples/popover-selection)
     * @default 30
     */
    size?: number;
    /**
     * The arrow's border width. If not specified, Ariakit will infer it from the
     * popover `contentElement`'s style.
     */
    borderWidth?: number;
}
export type PopoverArrowProps<T extends ElementType = TagName> = Props<T, PopoverArrowOptions<T>>;
export {};
