import type { ElementType } from "react";
import type { CompositeOptions } from "../composite/composite.tsx";
import type { CompositeTypeaheadOptions } from "../composite/composite-typeahead.tsx";
import type { DisclosureContentOptions } from "../disclosure/disclosure-content.tsx";
import type { Props } from "../utils/types.ts";
import type { MenuStore } from "./menu-store.ts";
declare const TagName = "div";
type TagName = typeof TagName;
/**
 * Returns props to create a `MenuList` component.
 * @see https://ariakit.org/components/menu
 * @example
 * ```jsx
 * const store = useMenuStore();
 * const props = useMenuList({ store });
 * <MenuButton store={store}>Edit</MenuButton>
 * <Role {...props}>
 *   <MenuItem>Undo</MenuItem>
 *   <MenuItem>Redo</MenuItem>
 * </Role>
 * ```
 */
export declare const useMenuList: import("../utils/types.ts").Hook<"div", MenuListOptions<"div">>;
/**
 * Renders a menu list element. This is the primitive component used by the
 * [`Menu`](https://ariakit.org/reference/menu) component.
 *
 * Unlike [`Menu`](https://ariakit.org/reference/menu), this component doesn't
 * render a popover and therefore doesn't automatically focus on items when
 * opened.
 * @see https://ariakit.org/components/menu
 * @example
 * ```jsx {3-6}
 * <MenuProvider>
 *   <MenuButton>Edit</MenuButton>
 *   <MenuList>
 *     <MenuItem>Undo</MenuItem>
 *     <MenuItem>Redo</MenuItem>
 *   </MenuList>
 * </MenuProvider>
 * ```
 */
export declare const MenuList: (props: MenuListProps) => import("react").ReactElement<any, string | import("react").JSXElementConstructor<any>>;
export interface MenuListOptions<T extends ElementType = TagName> extends CompositeOptions<T>, CompositeTypeaheadOptions<T>, Pick<DisclosureContentOptions, "alwaysVisible"> {
    /**
     * Object returned by the
     * [`useMenuStore`](https://ariakit.org/reference/use-menu-store) hook. If not
     * provided, the closest
     * [`MenuProvider`](https://ariakit.org/reference/menu-provider) component's
     * context will be used.
     */
    store?: MenuStore;
}
export type MenuListProps<T extends ElementType = TagName> = Props<T, MenuListOptions<T>>;
export {};
