import type { BooleanOrCallback } from "@ariakit/core/utils/types";
import type { ElementType } from "react";
import type { PopoverOptions } from "../popover/popover.tsx";
import type { Props } from "../utils/types.ts";
import type { HovercardStore } from "./hovercard-store.ts";
declare const TagName = "div";
type TagName = typeof TagName;
/**
 * Returns props to create a `Hovercard` component.
 * @see https://ariakit.org/components/hovercard
 * @example
 * ```jsx
 * const store = useHovercardStore();
 * const props = useHovercard({ store });
 * <HovercardAnchor store={store}>@username</HovercardAnchor>
 * <Role {...props}>Details</Role>
 * ```
 */
export declare const useHovercard: import("../utils/types.ts").Hook<"div", HovercardOptions<"div">>;
/**
 * Renders a hovercard element, which is a popover that's usually made visible
 * by hovering the mouse cursor over a
 * [`HovercardAnchor`](https://ariakit.org/reference/hovercard-anchor).
 * @see https://ariakit.org/components/hovercard
 * @example
 * ```jsx {3}
 * <HovercardProvider>
 *   <HovercardAnchor>@username</HovercardAnchor>
 *   <Hovercard>Details</Hovercard>
 * </HovercardProvider>
 * ```
 */
export declare const Hovercard: (props: HovercardProps<"div">) => import("react/jsx-runtime").JSX.Element | null;
export interface HovercardOptions<T extends ElementType = TagName> extends PopoverOptions<T> {
    /**
     * Object returned by the
     * [`useHovercardStore`](https://ariakit.org/reference/use-hovercard-store)
     * hook. If not provided, the closest
     * [`HovercardProvider`](https://ariakit.org/reference/hovercard-provider)
     * component's context will be used.
     */
    store?: HovercardStore;
    /**
     * Determines whether the popover should hide when the mouse leaves the
     * popover or the anchor element and there's no _hover intent_, meaning, the
     * mouse isn't moving toward the popover.
     *
     * This can be either a boolean or a callback receiving the mouse move event
     * that initiated the behavior. The callback should return a boolean.
     *
     * **Note**: This behavior won't be triggered when the popover or any of its
     * descendants are in focus.
     * @default true
     */
    hideOnHoverOutside?: BooleanOrCallback<MouseEvent>;
    /**
     * Determines if the pointer events outside of the popover and its anchor
     * element should be disabled during _hover intent_, that is, when the mouse
     * is moving toward the popover.
     *
     * This is required as these external events may trigger focus on other
     * elements and close the popover while the user is attempting to hover over
     * it.
     *
     * This can be either a boolean or a callback receiving the mouse event
     * happening during hover intent. The callback should return a boolean.
     * @default true
     */
    disablePointerEventsOnApproach?: BooleanOrCallback<MouseEvent>;
    /**
     * @default false
     */
    modal?: PopoverOptions<T>["modal"];
}
export type HovercardProps<T extends ElementType = TagName> = Props<T, HovercardOptions<T>>;
export {};
