import type { ElementType } from "react";
import type { GroupOptions } from "../group/group.tsx";
import type { Props } from "../utils/types.ts";
import type { CompositeStore } from "./composite-store.ts";
declare const TagName = "div";
type TagName = typeof TagName;
/**
 * Returns props to create a `CompositeGroup` component.
 * @see https://ariakit.org/components/composite
 * @example
 * ```jsx
 * const store = useCompositeStore();
 * const props = useCompositeGroup({ store });
 * <Composite store={store}>
 *   <Role {...props}>
 *     <CompositeGroupLabel>Label</CompositeGroupLabel>
 *     <CompositeItem>Item 1</CompositeItem>
 *     <CompositeItem>Item 2</CompositeItem>
 *   </Role>
 * </Composite>
 * ```
 */
export declare const useCompositeGroup: import("../utils/types.ts").Hook<"div", CompositeGroupOptions<"div">>;
/**
 * Renders a group element for composite items. The
 * [`CompositeGroupLabel`](https://ariakit.org/reference/composite-group-label)
 * component can be used inside this component so the `aria-labelledby` prop is
 * properly set on the group element.
 * @see https://ariakit.org/components/composite
 * @example
 * ```jsx {3-7}
 * <CompositeProvider>
 *   <Composite>
 *     <CompositeGroup>
 *       <CompositeGroupLabel>Label</CompositeGroupLabel>
 *       <CompositeItem>Item 1</CompositeItem>
 *       <CompositeItem>Item 2</CompositeItem>
 *     </CompositeGroup>
 *   </Composite>
 * </CompositeProvider>
 * ```
 */
export declare const CompositeGroup: (props: CompositeGroupProps) => import("react").ReactElement<any, string | import("react").JSXElementConstructor<any>>;
export interface CompositeGroupOptions<T extends ElementType = TagName> extends GroupOptions<T> {
    /**
     * Object returned by the
     * [`useCompositeStore`](https://ariakit.org/reference/use-composite-store)
     * hook. If not provided, the closest
     * [`Composite`](https://ariakit.org/reference/composite) or
     * [`CompositeProvider`](https://ariakit.org/reference/composite-provider)
     * components' context will be used.
     */
    store?: CompositeStore;
}
export type CompositeGroupProps<T extends ElementType = TagName> = Props<T, CompositeGroupOptions<T>>;
export {};
