import { type ElementType } from "react";
import { type CompositeItemOptions } from "../composite/composite-item-offscreen.tsx";
import type { Props } from "../utils/types.ts";
import * as Base from "./combobox-item.tsx";
declare const TagName = "div";
type TagName = typeof TagName;
export declare function useComboboxItemOffscreen<T extends ElementType, P extends ComboboxItemProps<T>>({ store, value, ...props }: P): {
    id: string | undefined;
    active: boolean;
    ref: import("react").RefCallback<HTMLDivElement>;
    "data-offscreen": true | undefined;
} | {
    role: string;
    id: string | undefined;
    active: boolean;
    ref: import("react").RefCallback<HTMLDivElement>;
    "data-offscreen": true | undefined;
};
export declare const ComboboxItem: ({ offscreenBehavior, offscreenRoot, ...props }: ComboboxItemProps) => import("react/jsx-runtime").JSX.Element;
export interface ComboboxItemOptions<T extends ElementType = TagName> extends Base.ComboboxItemOptions<T>, Omit<CompositeItemOptions<T>, "store"> {
}
export type ComboboxItemProps<T extends ElementType = TagName> = Props<T, ComboboxItemOptions<T>>;
export {};
