import type { ElementType, RefObject } from "react";
import { type RefCallback } from "react";
import type { Props } from "../utils/types.ts";
import * as Base from "./collection-item.tsx";
declare const TagName = "div";
type TagName = typeof TagName;
export declare function useCollectionItemOffscreen<T extends ElementType, P extends CollectionItemProps<T>>({ offscreenBehavior, offscreenRoot, ...props }: P): {
    id: string | undefined;
    active: boolean;
    ref: RefCallback<HTMLDivElement>;
    "data-offscreen": true | undefined;
};
export declare const CollectionItem: ({ offscreenBehavior, offscreenRoot, ...props }: CollectionItemProps) => import("react/jsx-runtime").JSX.Element;
export interface CollectionItemOptions<T extends ElementType = TagName> extends Base.CollectionItemOptions<T> {
    offscreenBehavior?: "active" | "passive" | "lazy";
    offscreenRoot?: HTMLElement | RefObject<HTMLElement> | ((element: HTMLElement) => HTMLElement | null) | null;
}
export type CollectionItemProps<T extends ElementType = TagName> = Props<T, CollectionItemOptions<T>>;
export {};
