"use strict";Object.defineProperty(exports, "__esModule", {value: true});

var _VC5V2CPOcjs = require('./VC5V2CPO.cjs');



var _4SKDRUBRcjs = require('./4SKDRUBR.cjs');

// src/dialog/utils/use-prevent-body-scroll.ts
var _dom = require('@ariakit/core/utils/dom');
var _misc = require('@ariakit/core/utils/misc');
var _platform = require('@ariakit/core/utils/platform');
var _react = require('react');
function getPaddingProperty(documentElement) {
  const documentLeft = documentElement.getBoundingClientRect().left;
  const scrollbarX = Math.round(documentLeft) + documentElement.scrollLeft;
  return scrollbarX ? "paddingLeft" : "paddingRight";
}
function usePreventBodyScroll(contentElement, contentId, enabled) {
  const isRootDialog = _VC5V2CPOcjs.useRootDialog.call(void 0, {
    attribute: "data-dialog-prevent-body-scroll",
    contentElement,
    contentId,
    enabled
  });
  _react.useEffect.call(void 0, () => {
    if (!isRootDialog()) return;
    if (!contentElement) return;
    const doc = _dom.getDocument.call(void 0, contentElement);
    const win = _dom.getWindow.call(void 0, contentElement);
    const { documentElement, body } = doc;
    const cssScrollbarWidth = documentElement.style.getPropertyValue("--scrollbar-width");
    const scrollbarWidth = cssScrollbarWidth ? Number.parseInt(cssScrollbarWidth) : win.innerWidth - documentElement.clientWidth;
    const setScrollbarWidthProperty = () => _4SKDRUBRcjs.setCSSProperty.call(void 0, 
      documentElement,
      "--scrollbar-width",
      `${scrollbarWidth}px`
    );
    const paddingProperty = getPaddingProperty(documentElement);
    const setStyle = () => _4SKDRUBRcjs.assignStyle.call(void 0, body, {
      overflow: "hidden",
      [paddingProperty]: `${scrollbarWidth}px`
    });
    const setIOSStyle = () => {
      var _a, _b;
      const { scrollX, scrollY, visualViewport } = win;
      const offsetLeft = (_a = visualViewport == null ? void 0 : visualViewport.offsetLeft) != null ? _a : 0;
      const offsetTop = (_b = visualViewport == null ? void 0 : visualViewport.offsetTop) != null ? _b : 0;
      const restoreStyle = _4SKDRUBRcjs.assignStyle.call(void 0, body, {
        position: "fixed",
        overflow: "hidden",
        top: `${-(scrollY - Math.floor(offsetTop))}px`,
        left: `${-(scrollX - Math.floor(offsetLeft))}px`,
        right: "0",
        [paddingProperty]: `${scrollbarWidth}px`
      });
      return () => {
        restoreStyle();
        if (process.env.NODE_ENV !== "test") {
          win.scrollTo({ left: scrollX, top: scrollY, behavior: "instant" });
        }
      };
    };
    const isIOS = _platform.isApple.call(void 0, ) && !_platform.isMac.call(void 0, );
    return _misc.chain.call(void 0, 
      setScrollbarWidthProperty(),
      isIOS ? setIOSStyle() : setStyle()
    );
  }, [isRootDialog, contentElement]);
}



exports.usePreventBodyScroll = usePreventBodyScroll;
