"use strict";Object.defineProperty(exports, "__esModule", {value: true});

var _FCZ3IGUBcjs = require('./FCZ3IGUB.cjs');


var _IH6KF7WRcjs = require('./IH6KF7WR.cjs');


var _WULEED4Qcjs = require('./WULEED4Q.cjs');




var _OZM4QA2Vcjs = require('./OZM4QA2V.cjs');




var _7EQBAZ46cjs = require('./7EQBAZ46.cjs');

// src/collection/collection-item-offscreen.tsx
var _misc = require('@ariakit/core/utils/misc');
var _react = require('react');
var _jsxruntime = require('react/jsx-runtime');
var TagName = "div";
function requestIdleCallback(callback) {
  if (typeof window.requestIdleCallback === "function") {
    return window.requestIdleCallback(callback);
  }
  callback();
  return 0;
}
function cancelIdleCallback(id) {
  if (typeof window.cancelIdleCallback === "function") {
    window.cancelIdleCallback(id);
  }
}
function useCollectionItemOffscreen(_a) {
  var _b = _a, { offscreenBehavior = "active", offscreenRoot } = _b, props = _7EQBAZ46cjs.__objRest.call(void 0, _b, ["offscreenBehavior", "offscreenRoot"]);
  const id = _OZM4QA2Vcjs.useId.call(void 0, props.id);
  const [updated, forceUpdate] = _OZM4QA2Vcjs.useForceUpdate.call(void 0, );
  const forcedUpdatesCountRef = _react.useRef.call(void 0, 0);
  const [_active, setActive] = _react.useState.call(void 0, offscreenBehavior === "active");
  const active = _active || offscreenBehavior === "active";
  const observerRef = _react.useRef.call(void 0, null);
  const idleCallbackIdRef = _react.useRef.call(void 0, 0);
  const ref = _react.useCallback.call(void 0, 
    (element) => {
      var _a2;
      if (!element || offscreenBehavior === "active") {
        cancelIdleCallback(idleCallbackIdRef.current);
        (_a2 = observerRef.current) == null ? void 0 : _a2.disconnect();
        return;
      }
      _misc.invariant.call(void 0, 
        offscreenRoot !== void 0,
        process.env.NODE_ENV !== "production" && "The offscreenRoot prop must provided."
      );
      const getOffscreenRoot = () => {
        if (!offscreenRoot) return null;
        if (typeof offscreenRoot === "function") {
          return offscreenRoot(element);
        }
        if ("current" in offscreenRoot) {
          return offscreenRoot.current;
        }
        return offscreenRoot;
      };
      const root = getOffscreenRoot();
      if (!root) {
        forcedUpdatesCountRef.current++;
        if (forcedUpdatesCountRef.current > 3) {
          throw new Error(
            "The offscreenRoot is not available. Please make sure the root element is mounted."
          );
        }
        forceUpdate();
        return;
      }
      if (!observerRef.current || observerRef.current.root !== root) {
        observerRef.current = new IntersectionObserver(
          ([entry]) => {
            cancelIdleCallback(idleCallbackIdRef.current);
            const isIntersecting = !!(entry == null ? void 0 : entry.isIntersecting);
            idleCallbackIdRef.current = requestIdleCallback(() => {
              if (!isIntersecting && offscreenBehavior === "lazy") return;
              setActive(isIntersecting);
            });
          },
          { root, rootMargin: "40%" }
        );
      }
      observerRef.current.observe(element);
    },
    [updated, offscreenBehavior, offscreenRoot]
  );
  return {
    id,
    active,
    ref,
    "data-offscreen": !active || void 0
  };
}
var CollectionItem2 = _WULEED4Qcjs.forwardRef.call(void 0, function CollectionItem3(_a) {
  var _b = _a, {
    offscreenBehavior,
    offscreenRoot
  } = _b, props = _7EQBAZ46cjs.__objRest.call(void 0, _b, [
    "offscreenBehavior",
    "offscreenRoot"
  ]);
  const _a2 = useCollectionItemOffscreen(_7EQBAZ46cjs.__spreadValues.call(void 0, {
    offscreenBehavior,
    offscreenRoot
  }, props)), { active, ref } = _a2, rest = _7EQBAZ46cjs.__objRest.call(void 0, _a2, ["active", "ref"]);
  const allProps = _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {}, rest), props), { ref: _OZM4QA2Vcjs.useMergeRefs.call(void 0, ref, props.ref) });
  if (active) {
    return /* @__PURE__ */ _jsxruntime.jsx.call(void 0, _IH6KF7WRcjs.CollectionItem, _7EQBAZ46cjs.__spreadValues.call(void 0, {}, allProps));
  }
  const _b2 = allProps, {
    store,
    shouldRegisterItem,
    getItem,
    element: element
  } = _b2, htmlProps = _7EQBAZ46cjs.__objRest.call(void 0, _b2, [
    "store",
    "shouldRegisterItem",
    "getItem",
    // @ts-expect-error This prop may come from a collection renderer.
    "element"
  ]);
  const Component = _FCZ3IGUBcjs.Role[TagName];
  return /* @__PURE__ */ _jsxruntime.jsx.call(void 0, Component, _7EQBAZ46cjs.__spreadValues.call(void 0, {}, htmlProps));
});




exports.useCollectionItemOffscreen = useCollectionItemOffscreen; exports.CollectionItem = CollectionItem2;
