"use strict";Object.defineProperty(exports, "__esModule", {value: true});

var _N37IROBRcjs = require('./N37IROBR.cjs');


var _YTEJF6TYcjs = require('./YTEJF6TY.cjs');





var _PH2DFCJScjs = require('./PH2DFCJS.cjs');


var _25BPIGZHcjs = require('./25BPIGZH.cjs');





var _WULEED4Qcjs = require('./WULEED4Q.cjs');




var _OZM4QA2Vcjs = require('./OZM4QA2V.cjs');




var _7EQBAZ46cjs = require('./7EQBAZ46.cjs');

// src/combobox/combobox-item.tsx
var _dom = require('@ariakit/core/utils/dom');
var _events = require('@ariakit/core/utils/events');
var _focus = require('@ariakit/core/utils/focus');
var _misc = require('@ariakit/core/utils/misc');
var _react = require('react');
var _jsxruntime = require('react/jsx-runtime');
var TagName = "div";
function isSelected(storeValue, itemValue) {
  if (itemValue == null) return;
  if (storeValue == null) return false;
  if (Array.isArray(storeValue)) {
    return storeValue.includes(itemValue);
  }
  return storeValue === itemValue;
}
function getItemRole(popupRole) {
  var _a;
  const itemRoleByPopupRole = {
    menu: "menuitem",
    listbox: "option",
    tree: "treeitem"
  };
  const key = popupRole;
  return (_a = itemRoleByPopupRole[key]) != null ? _a : "option";
}
var useComboboxItem = _WULEED4Qcjs.createHook.call(void 0, 
  function useComboboxItem2(_a) {
    var _b = _a, {
      store,
      value,
      hideOnClick,
      setValueOnClick,
      selectValueOnClick = true,
      resetValueOnSelect,
      focusOnHover = false,
      moveOnKeyPress = true,
      getItem: getItemProp
    } = _b, props = _7EQBAZ46cjs.__objRest.call(void 0, _b, [
      "store",
      "value",
      "hideOnClick",
      "setValueOnClick",
      "selectValueOnClick",
      "resetValueOnSelect",
      "focusOnHover",
      "moveOnKeyPress",
      "getItem"
    ]);
    var _a2;
    const context = _PH2DFCJScjs.useComboboxScopedContext.call(void 0, );
    store = store || context;
    _misc.invariant.call(void 0, 
      store,
      process.env.NODE_ENV !== "production" && "ComboboxItem must be wrapped in a ComboboxList or ComboboxPopover component."
    );
    const { resetValueOnSelectState, multiSelectable, selected } = _25BPIGZHcjs.useStoreStateObject.call(void 0, store, {
      resetValueOnSelectState: "resetValueOnSelect",
      multiSelectable(state) {
        return Array.isArray(state.selectedValue);
      },
      selected(state) {
        return isSelected(state.selectedValue, value);
      }
    });
    const getItem = _react.useCallback.call(void 0, 
      (item) => {
        const nextItem = _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {}, item), { value });
        if (getItemProp) {
          return getItemProp(nextItem);
        }
        return nextItem;
      },
      [value, getItemProp]
    );
    setValueOnClick = setValueOnClick != null ? setValueOnClick : !multiSelectable;
    hideOnClick = hideOnClick != null ? hideOnClick : value != null && !multiSelectable;
    const onClickProp = props.onClick;
    const setValueOnClickProp = _OZM4QA2Vcjs.useBooleanEvent.call(void 0, setValueOnClick);
    const selectValueOnClickProp = _OZM4QA2Vcjs.useBooleanEvent.call(void 0, selectValueOnClick);
    const resetValueOnSelectProp = _OZM4QA2Vcjs.useBooleanEvent.call(void 0, 
      (_a2 = resetValueOnSelect != null ? resetValueOnSelect : resetValueOnSelectState) != null ? _a2 : multiSelectable
    );
    const hideOnClickProp = _OZM4QA2Vcjs.useBooleanEvent.call(void 0, hideOnClick);
    const onClick = _OZM4QA2Vcjs.useEvent.call(void 0, (event) => {
      onClickProp == null ? void 0 : onClickProp(event);
      if (event.defaultPrevented) return;
      if (_events.isDownloading.call(void 0, event)) return;
      if (_events.isOpeningInNewTab.call(void 0, event)) return;
      if (value != null) {
        if (selectValueOnClickProp(event)) {
          if (resetValueOnSelectProp(event)) {
            store == null ? void 0 : store.resetValue();
          }
          store == null ? void 0 : store.setSelectedValue((prevValue) => {
            if (!Array.isArray(prevValue)) return value;
            if (prevValue.includes(value)) {
              return prevValue.filter((v) => v !== value);
            }
            return [...prevValue, value];
          });
        }
        if (setValueOnClickProp(event)) {
          store == null ? void 0 : store.setValue(value);
        }
      }
      if (hideOnClickProp(event)) {
        store == null ? void 0 : store.hide();
      }
    });
    const onKeyDownProp = props.onKeyDown;
    const onKeyDown = _OZM4QA2Vcjs.useEvent.call(void 0, (event) => {
      onKeyDownProp == null ? void 0 : onKeyDownProp(event);
      if (event.defaultPrevented) return;
      const baseElement = store == null ? void 0 : store.getState().baseElement;
      if (!baseElement) return;
      if (_focus.hasFocus.call(void 0, baseElement)) return;
      const printable = event.key.length === 1;
      if (printable || event.key === "Backspace" || event.key === "Delete") {
        queueMicrotask(() => baseElement.focus());
        if (_dom.isTextField.call(void 0, baseElement)) {
          store == null ? void 0 : store.setValue(baseElement.value);
        }
      }
    });
    if (multiSelectable && selected != null) {
      props = _7EQBAZ46cjs.__spreadValues.call(void 0, {
        "aria-selected": selected
      }, props);
    }
    props = _OZM4QA2Vcjs.useWrapElement.call(void 0, 
      props,
      (element) => /* @__PURE__ */ _jsxruntime.jsx.call(void 0, _PH2DFCJScjs.ComboboxItemValueContext.Provider, { value, children: /* @__PURE__ */ _jsxruntime.jsx.call(void 0, _PH2DFCJScjs.ComboboxItemCheckedContext.Provider, { value: selected != null ? selected : false, children: element }) }),
      [value, selected]
    );
    const popupRole = _react.useContext.call(void 0, _PH2DFCJScjs.ComboboxListRoleContext);
    props = _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {
      role: getItemRole(popupRole),
      children: value
    }, props), {
      onClick,
      onKeyDown
    });
    const moveOnKeyPressProp = _OZM4QA2Vcjs.useBooleanEvent.call(void 0, moveOnKeyPress);
    props = _YTEJF6TYcjs.useCompositeItem.call(void 0, _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {
      store
    }, props), {
      getItem,
      // Dispatch a custom event on the combobox input when moving to an item
      // with the keyboard so the Combobox component can enable inline
      // autocompletion.
      moveOnKeyPress: (event) => {
        if (!moveOnKeyPressProp(event)) return false;
        const moveEvent = new Event("combobox-item-move");
        const baseElement = store == null ? void 0 : store.getState().baseElement;
        baseElement == null ? void 0 : baseElement.dispatchEvent(moveEvent);
        return true;
      }
    }));
    props = _N37IROBRcjs.useCompositeHover.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, { store, focusOnHover }, props));
    return props;
  }
);
var ComboboxItem = _WULEED4Qcjs.memo.call(void 0, 
  _WULEED4Qcjs.forwardRef.call(void 0, function ComboboxItem2(props) {
    const htmlProps = useComboboxItem(props);
    return _WULEED4Qcjs.createElement.call(void 0, TagName, htmlProps);
  })
);




exports.useComboboxItem = useComboboxItem; exports.ComboboxItem = ComboboxItem;
