"use strict";Object.defineProperty(exports, "__esModule", {value: true});

var _OZM4QA2Vcjs = require('./OZM4QA2V.cjs');

// src/dialog/utils/use-root-dialog.ts
var _dom = require('@ariakit/core/utils/dom');
var _react = require('react');
var _reactdom = require('react-dom');
function useRootDialog({
  attribute,
  contentId,
  contentElement,
  enabled
}) {
  const [updated, retry] = _OZM4QA2Vcjs.useForceUpdate.call(void 0, );
  const isRootDialog = _react.useCallback.call(void 0, () => {
    if (!enabled) return false;
    if (!contentElement) return false;
    const { body } = _dom.getDocument.call(void 0, contentElement);
    const id = body.getAttribute(attribute);
    return !id || id === contentId;
  }, [updated, enabled, contentElement, attribute, contentId]);
  _react.useEffect.call(void 0, () => {
    if (!enabled) return;
    if (!contentId) return;
    if (!contentElement) return;
    const { body } = _dom.getDocument.call(void 0, contentElement);
    if (isRootDialog()) {
      body.setAttribute(attribute, contentId);
      return () => body.removeAttribute(attribute);
    }
    const observer = new MutationObserver(() => _reactdom.flushSync.call(void 0, retry));
    observer.observe(body, { attributeFilter: [attribute] });
    return () => observer.disconnect();
  }, [updated, enabled, contentId, contentElement, isRootDialog, attribute]);
  return isRootDialog;
}



exports.useRootDialog = useRootDialog;
