"use strict";Object.defineProperty(exports, "__esModule", {value: true});

var _MIBORXQWcjs = require('./MIBORXQW.cjs');


var _D6FV6EYScjs = require('./D6FV6EYS.cjs');




var _WULEED4Qcjs = require('./WULEED4Q.cjs');


var _OZM4QA2Vcjs = require('./OZM4QA2V.cjs');




var _7EQBAZ46cjs = require('./7EQBAZ46.cjs');

// src/composite/composite-typeahead.tsx




var _dom = require('@ariakit/core/utils/dom');
var _events = require('@ariakit/core/utils/events');




var _misc = require('@ariakit/core/utils/misc');
var _react = require('react');
var TagName = "div";
var chars = "";
function clearChars() {
  chars = "";
}
function isValidTypeaheadEvent(event) {
  const target = event.target;
  if (target && _dom.isTextField.call(void 0, target)) return false;
  if (event.key === " " && chars.length) return true;
  return event.key.length === 1 && !event.ctrlKey && !event.altKey && !event.metaKey && /^[\p{Letter}\p{Number}]$/u.test(event.key);
}
function isSelfTargetOrItem(event, items) {
  if (_events.isSelfTarget.call(void 0, event)) return true;
  const target = event.target;
  if (!target) return false;
  const isItem = items.some((item) => item.element === target);
  return isItem;
}
function getEnabledItems(items) {
  return items.filter((item) => !item.disabled);
}
function itemTextStartsWith(item, text) {
  var _a;
  const itemText = ((_a = item.element) == null ? void 0 : _a.textContent) || item.children || // The composite item object itself doesn't include a value property, but
  // other components like Select do. Since CompositeTypeahead is a generic
  // component that can be used with those as well, we also consider the value
  // property as a fallback for the typeahead text content.
  "value" in item && item.value;
  if (!itemText) return false;
  return _misc.normalizeString.call(void 0, itemText).trim().toLowerCase().startsWith(text.toLowerCase());
}
function getSameInitialItems(items, char, activeId) {
  if (!activeId) return items;
  const activeItem = items.find((item) => item.id === activeId);
  if (!activeItem) return items;
  if (!itemTextStartsWith(activeItem, char)) return items;
  if (chars !== char && itemTextStartsWith(activeItem, chars)) return items;
  chars = char;
  return _MIBORXQWcjs.flipItems.call(void 0, 
    items.filter((item) => itemTextStartsWith(item, chars)),
    activeId
  ).filter((item) => item.id !== activeId);
}
var useCompositeTypeahead = _WULEED4Qcjs.createHook.call(void 0, function useCompositeTypeahead2(_a) {
  var _b = _a, { store, typeahead = true } = _b, props = _7EQBAZ46cjs.__objRest.call(void 0, _b, ["store", "typeahead"]);
  const context = _D6FV6EYScjs.useCompositeContext.call(void 0, );
  store = store || context;
  _misc.invariant.call(void 0, 
    store,
    process.env.NODE_ENV !== "production" && "CompositeTypeahead must be a Composite component"
  );
  const onKeyDownCaptureProp = props.onKeyDownCapture;
  const cleanupTimeoutRef = _react.useRef.call(void 0, 0);
  const onKeyDownCapture = _OZM4QA2Vcjs.useEvent.call(void 0, (event) => {
    onKeyDownCaptureProp == null ? void 0 : onKeyDownCaptureProp(event);
    if (event.defaultPrevented) return;
    if (!typeahead) return;
    if (!store) return;
    if (!isValidTypeaheadEvent(event)) {
      return clearChars();
    }
    const { renderedItems, items, activeId, id } = store.getState();
    let enabledItems = getEnabledItems(
      items.length > renderedItems.length ? items : renderedItems
    );
    const document = _dom.getDocument.call(void 0, event.currentTarget);
    const selector = `[data-offscreen-id="${id}"]`;
    const offscreenItems = document.querySelectorAll(selector);
    for (const element of offscreenItems) {
      const disabled = element.ariaDisabled === "true" || "disabled" in element && !!element.disabled;
      enabledItems.push({ id: element.id, element, disabled });
    }
    if (offscreenItems.length) {
      enabledItems = _dom.sortBasedOnDOMPosition.call(void 0, enabledItems, (i) => i.element);
    }
    if (!isSelfTargetOrItem(event, enabledItems)) return clearChars();
    event.preventDefault();
    window.clearTimeout(cleanupTimeoutRef.current);
    cleanupTimeoutRef.current = window.setTimeout(() => {
      chars = "";
    }, 500);
    const char = event.key.toLowerCase();
    chars += char;
    enabledItems = getSameInitialItems(enabledItems, char, activeId);
    const item = enabledItems.find((item2) => itemTextStartsWith(item2, chars));
    if (item) {
      store.move(item.id);
    } else {
      clearChars();
    }
  });
  props = _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {}, props), {
    onKeyDownCapture
  });
  return _misc.removeUndefinedValues.call(void 0, props);
});
var CompositeTypeahead = _WULEED4Qcjs.forwardRef.call(void 0, function CompositeTypeahead2(props) {
  const htmlProps = useCompositeTypeahead(props);
  return _WULEED4Qcjs.createElement.call(void 0, TagName, htmlProps);
});




exports.useCompositeTypeahead = useCompositeTypeahead; exports.CompositeTypeahead = CompositeTypeahead;
