"use strict";Object.defineProperty(exports, "__esModule", {value: true}); function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { newObj[key] = obj[key]; } } } newObj.default = obj; return newObj; } }

var _FDRJDQ5Ycjs = require('./FDRJDQ5Y.cjs');



var _7EQBAZ46cjs = require('./7EQBAZ46.cjs');

// src/utils/hooks.ts
var _dom = require('@ariakit/core/utils/dom');
var _events = require('@ariakit/core/utils/events');
var _react = require('react'); var React = _interopRequireWildcard(_react);









var _React = _7EQBAZ46cjs.__spreadValues.call(void 0, {}, React);
var useReactId = _React.useId;
var useReactDeferredValue = _React.useDeferredValue;
var useReactInsertionEffect = _React.useInsertionEffect;
var useSafeLayoutEffect = _dom.canUseDOM ? _react.useLayoutEffect : _react.useEffect;
function useInitialValue(value) {
  const [initialValue] = _react.useState.call(void 0, value);
  return initialValue;
}
function useLazyValue(init) {
  const ref = _react.useRef.call(void 0, );
  if (ref.current === void 0) {
    ref.current = init();
  }
  return ref.current;
}
function useLiveRef(value) {
  const ref = _react.useRef.call(void 0, value);
  useSafeLayoutEffect(() => {
    ref.current = value;
  });
  return ref;
}
function usePreviousValue(value) {
  const [previousValue, setPreviousValue] = _react.useState.call(void 0, value);
  if (value !== previousValue) {
    setPreviousValue(value);
  }
  return previousValue;
}
function useEvent(callback) {
  const ref = _react.useRef.call(void 0, () => {
    throw new Error("Cannot call an event handler while rendering.");
  });
  if (useReactInsertionEffect) {
    useReactInsertionEffect(() => {
      ref.current = callback;
    });
  } else {
    ref.current = callback;
  }
  return _react.useCallback.call(void 0, (...args) => {
    var _a;
    return (_a = ref.current) == null ? void 0 : _a.call(ref, ...args);
  }, []);
}
function useTransactionState(callback) {
  const [state, setState] = _react.useState.call(void 0, null);
  useSafeLayoutEffect(() => {
    if (state == null) return;
    if (!callback) return;
    let prevState = null;
    callback((prev) => {
      prevState = prev;
      return state;
    });
    return () => {
      callback(prevState);
    };
  }, [state, callback]);
  return [state, setState];
}
function useMergeRefs(...refs) {
  return _react.useMemo.call(void 0, () => {
    if (!refs.some(Boolean)) return;
    return (value) => {
      for (const ref of refs) {
        _FDRJDQ5Ycjs.setRef.call(void 0, ref, value);
      }
    };
  }, refs);
}
function useId(defaultId) {
  if (useReactId) {
    const reactId = useReactId();
    if (defaultId) return defaultId;
    return reactId;
  }
  const [id, setId] = _react.useState.call(void 0, defaultId);
  useSafeLayoutEffect(() => {
    if (defaultId || id) return;
    const random = Math.random().toString(36).slice(2, 8);
    setId(`id-${random}`);
  }, [defaultId, id]);
  return defaultId || id;
}
function useDeferredValue(value) {
  if (useReactDeferredValue) {
    return useReactDeferredValue(value);
  }
  const [deferredValue, setDeferredValue] = _react.useState.call(void 0, value);
  _react.useEffect.call(void 0, () => {
    const raf = requestAnimationFrame(() => setDeferredValue(value));
    return () => cancelAnimationFrame(raf);
  }, [value]);
  return deferredValue;
}
function useTagName(refOrElement, type) {
  const stringOrUndefined = (type2) => {
    if (typeof type2 !== "string") return;
    return type2;
  };
  const [tagName, setTagName] = _react.useState.call(void 0, () => stringOrUndefined(type));
  useSafeLayoutEffect(() => {
    const element = refOrElement && "current" in refOrElement ? refOrElement.current : refOrElement;
    setTagName((element == null ? void 0 : element.tagName.toLowerCase()) || stringOrUndefined(type));
  }, [refOrElement, type]);
  return tagName;
}
function useAttribute(refOrElement, attributeName, defaultValue) {
  const initialValue = useInitialValue(defaultValue);
  const [attribute, setAttribute] = _react.useState.call(void 0, initialValue);
  _react.useEffect.call(void 0, () => {
    const element = refOrElement && "current" in refOrElement ? refOrElement.current : refOrElement;
    if (!element) return;
    const callback = () => {
      const value = element.getAttribute(attributeName);
      setAttribute(value == null ? initialValue : value);
    };
    const observer = new MutationObserver(callback);
    observer.observe(element, { attributeFilter: [attributeName] });
    callback();
    return () => observer.disconnect();
  }, [refOrElement, attributeName, initialValue]);
  return attribute;
}
function useUpdateEffect(effect, deps) {
  const mounted = _react.useRef.call(void 0, false);
  _react.useEffect.call(void 0, () => {
    if (mounted.current) {
      return effect();
    }
    mounted.current = true;
  }, deps);
  _react.useEffect.call(void 0, 
    () => () => {
      mounted.current = false;
    },
    []
  );
}
function useUpdateLayoutEffect(effect, deps) {
  const mounted = _react.useRef.call(void 0, false);
  useSafeLayoutEffect(() => {
    if (mounted.current) {
      return effect();
    }
    mounted.current = true;
  }, deps);
  useSafeLayoutEffect(
    () => () => {
      mounted.current = false;
    },
    []
  );
}
function useForceUpdate() {
  return _react.useReducer.call(void 0, () => [], []);
}
function useBooleanEvent(booleanOrCallback) {
  return useEvent(
    typeof booleanOrCallback === "function" ? booleanOrCallback : () => booleanOrCallback
  );
}
function useWrapElement(props, callback, deps = []) {
  const wrapElement = _react.useCallback.call(void 0, 
    (element) => {
      if (props.wrapElement) {
        element = props.wrapElement(element);
      }
      return callback(element);
    },
    [...deps, props.wrapElement]
  );
  return _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {}, props), { wrapElement });
}
function usePortalRef(portalProp = false, portalRefProp) {
  const [portalNode, setPortalNode] = _react.useState.call(void 0, null);
  const portalRef = useMergeRefs(setPortalNode, portalRefProp);
  const domReady = !portalProp || portalNode;
  return { portalRef, portalNode, domReady };
}
function useMetadataProps(props, key, value) {
  const parent = props.onLoadedMetadataCapture;
  const onLoadedMetadataCapture = _react.useMemo.call(void 0, () => {
    return Object.assign(() => {
    }, _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {}, parent), { [key]: value }));
  }, [parent, key, value]);
  return [parent == null ? void 0 : parent[key], { onLoadedMetadataCapture }];
}
var hasInstalledGlobalEventListeners = false;
function useIsMouseMoving() {
  _react.useEffect.call(void 0, () => {
    if (hasInstalledGlobalEventListeners) return;
    _events.addGlobalEventListener.call(void 0, "mousemove", setMouseMoving, true);
    _events.addGlobalEventListener.call(void 0, "mousedown", resetMouseMoving, true);
    _events.addGlobalEventListener.call(void 0, "mouseup", resetMouseMoving, true);
    _events.addGlobalEventListener.call(void 0, "keydown", resetMouseMoving, true);
    _events.addGlobalEventListener.call(void 0, "scroll", resetMouseMoving, true);
    hasInstalledGlobalEventListeners = true;
  }, []);
  const isMouseMoving = useEvent(() => mouseMoving);
  return isMouseMoving;
}
var mouseMoving = false;
var previousScreenX = 0;
var previousScreenY = 0;
function hasMouseMovement(event) {
  const movementX = event.movementX || event.screenX - previousScreenX;
  const movementY = event.movementY || event.screenY - previousScreenY;
  previousScreenX = event.screenX;
  previousScreenY = event.screenY;
  return movementX || movementY || process.env.NODE_ENV === "test";
}
function setMouseMoving(event) {
  if (!hasMouseMovement(event)) return;
  mouseMoving = true;
}
function resetMouseMoving() {
  mouseMoving = false;
}






















exports.useSafeLayoutEffect = useSafeLayoutEffect; exports.useInitialValue = useInitialValue; exports.useLazyValue = useLazyValue; exports.useLiveRef = useLiveRef; exports.usePreviousValue = usePreviousValue; exports.useEvent = useEvent; exports.useTransactionState = useTransactionState; exports.useMergeRefs = useMergeRefs; exports.useId = useId; exports.useDeferredValue = useDeferredValue; exports.useTagName = useTagName; exports.useAttribute = useAttribute; exports.useUpdateEffect = useUpdateEffect; exports.useUpdateLayoutEffect = useUpdateLayoutEffect; exports.useForceUpdate = useForceUpdate; exports.useBooleanEvent = useBooleanEvent; exports.useWrapElement = useWrapElement; exports.usePortalRef = usePortalRef; exports.useMetadataProps = useMetadataProps; exports.useIsMouseMoving = useIsMouseMoving;
