"use strict";Object.defineProperty(exports, "__esModule", {value: true});

var _PLY2V46Gcjs = require('./PLY2V46G.cjs');


var _ZVJRPAXYcjs = require('./ZVJRPAXY.cjs');


var _25BPIGZHcjs = require('./25BPIGZH.cjs');





var _WULEED4Qcjs = require('./WULEED4Q.cjs');




var _OZM4QA2Vcjs = require('./OZM4QA2V.cjs');




var _7EQBAZ46cjs = require('./7EQBAZ46.cjs');

// src/popover/popover-arrow.tsx
var _dom = require('@ariakit/core/utils/dom');
var _misc = require('@ariakit/core/utils/misc');
var _react = require('react');
var _jsxruntime = require('react/jsx-runtime');
var TagName = "div";
var defaultSize = 30;
var halfDefaultSize = defaultSize / 2;
var rotateMap = {
  top: `rotate(180 ${halfDefaultSize} ${halfDefaultSize})`,
  right: `rotate(-90 ${halfDefaultSize} ${halfDefaultSize})`,
  bottom: `rotate(0 ${halfDefaultSize} ${halfDefaultSize})`,
  left: `rotate(90 ${halfDefaultSize} ${halfDefaultSize})`
};
function useComputedStyle(store) {
  const [style, setStyle] = _react.useState.call(void 0, );
  const contentElement = _25BPIGZHcjs.useStoreState.call(void 0, store, "contentElement");
  _OZM4QA2Vcjs.useSafeLayoutEffect.call(void 0, () => {
    if (!contentElement) return;
    const win = _dom.getWindow.call(void 0, contentElement);
    const computedStyle = win.getComputedStyle(contentElement);
    setStyle(computedStyle);
  }, [contentElement]);
  return style;
}
function getRingWidth(style) {
  var _a;
  if (!style) return;
  const boxShadow = style.getPropertyValue("box-shadow");
  const ringWidth = (_a = boxShadow.match(/0px 0px 0px ([^0]+px)/)) == null ? void 0 : _a[1];
  return ringWidth;
}
function getBorderColor(dir, style) {
  if (!style) return;
  const borderColor = style.getPropertyValue(`border-${dir}-color`);
  if (borderColor) return borderColor;
  const boxShadow = style.getPropertyValue("box-shadow");
  const match = boxShadow.match(/0px 0px 0px [^,]+/);
  if (!match) return;
  const segment = match[0];
  const ringColor = segment.replace(/^0px 0px 0px\s+[^\s,]+/, "").trim();
  return ringColor || void 0;
}
var usePopoverArrow = _WULEED4Qcjs.createHook.call(void 0, 
  function usePopoverArrow2(_a) {
    var _b = _a, {
      store,
      size = defaultSize,
      borderWidth: borderWidthProp
    } = _b, props = _7EQBAZ46cjs.__objRest.call(void 0, _b, [
      "store",
      "size",
      "borderWidth"
    ]);
    const context = _ZVJRPAXYcjs.usePopoverContext.call(void 0, );
    store = store || context;
    _misc.invariant.call(void 0, 
      store,
      process.env.NODE_ENV !== "production" && "PopoverArrow must be wrapped in a Popover component."
    );
    const dir = _25BPIGZHcjs.useStoreState.call(void 0, 
      store,
      (state) => state.currentPlacement.split("-")[0]
    );
    const maskId = _OZM4QA2Vcjs.useId.call(void 0, );
    const style = useComputedStyle(store);
    const stroke = getBorderColor(dir, style) || "none";
    const fill = (style == null ? void 0 : style.getPropertyValue("background-color")) || "none";
    const [borderWidth, isRing] = _react.useMemo.call(void 0, () => {
      if (borderWidthProp != null) return [borderWidthProp, false];
      if (!style) return [0, false];
      const ringWidth = getRingWidth(style);
      if (ringWidth) return [Number.parseInt(ringWidth), true];
      const borderWidth2 = style.getPropertyValue(`border-${dir}-width`);
      if (borderWidth2) return [Number.parseInt(borderWidth2), false];
      return [0, false];
    }, [borderWidthProp, style, dir]);
    const strokeWidth = borderWidth * 2 * (defaultSize / size);
    const transform = rotateMap[dir];
    const children = _react.useMemo.call(void 0, 
      () => /* @__PURE__ */ _jsxruntime.jsx.call(void 0, "svg", { display: "block", viewBox: "0 0 30 30", children: /* @__PURE__ */ _jsxruntime.jsxs.call(void 0, "g", { transform, children: [
        !isRing && // When using the CSS border property, set the fill color to match
        // the background behind the stroke so transparent strokes match
        // the appearance of borders on HTML elements.
        /* @__PURE__ */ _jsxruntime.jsx.call(void 0, 
          "path",
          {
            fill: "none",
            stroke: `var(--ak-layer, ${fill})`,
            d: _PLY2V46Gcjs.POPOVER_ARROW_PATH,
            mask: `url(#${maskId})`
          }
        ),
        /* @__PURE__ */ _jsxruntime.jsx.call(void 0, "path", { fill: "none", d: _PLY2V46Gcjs.POPOVER_ARROW_PATH, mask: `url(#${maskId})` }),
        /* @__PURE__ */ _jsxruntime.jsx.call(void 0, "path", { stroke: "none", d: _PLY2V46Gcjs.POPOVER_ARROW_PATH }),
        /* @__PURE__ */ _jsxruntime.jsx.call(void 0, "mask", { id: maskId, maskUnits: "userSpaceOnUse", children: /* @__PURE__ */ _jsxruntime.jsx.call(void 0, 
          "rect",
          {
            x: "-15",
            y: "0",
            width: "60",
            height: "30",
            fill: "white",
            stroke: "black"
          }
        ) })
      ] }) }),
      [transform, isRing, fill, maskId]
    );
    props = _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {
      children,
      "aria-hidden": true
    }, props), {
      ref: _OZM4QA2Vcjs.useMergeRefs.call(void 0, store.setArrowElement, props.ref),
      style: _7EQBAZ46cjs.__spreadValues.call(void 0, {
        position: "absolute",
        fontSize: size,
        width: "1em",
        height: "1em",
        pointerEvents: "none",
        fill: `var(--ak-layer, ${fill})`,
        stroke: `var(--ak-layer-border, ${stroke})`,
        strokeWidth
      }, props.style)
    });
    return _misc.removeUndefinedValues.call(void 0, props);
  }
);
var PopoverArrow = _WULEED4Qcjs.memo.call(void 0, 
  _WULEED4Qcjs.forwardRef.call(void 0, function PopoverArrow2(props) {
    const htmlProps = usePopoverArrow(props);
    return _WULEED4Qcjs.createElement.call(void 0, TagName, htmlProps);
  })
);




exports.usePopoverArrow = usePopoverArrow; exports.PopoverArrow = PopoverArrow;
