"use strict";Object.defineProperty(exports, "__esModule", {value: true});

var _YVOQ2BCBcjs = require('./YVOQ2BCB.cjs');


var _4SKDRUBRcjs = require('./4SKDRUBR.cjs');


var _AQ2LO7WVcjs = require('./AQ2LO7WV.cjs');

// src/dialog/utils/disable-accessibility-tree-outside.ts
function hideElementFromAccessibilityTree(element) {
  return _4SKDRUBRcjs.setAttribute.call(void 0, element, "aria-hidden", "true");
}
function disableAccessibilityTreeOutside(id, elements) {
  const cleanups = [];
  const ids = elements.map((el) => el == null ? void 0 : el.id);
  _YVOQ2BCBcjs.walkTreeOutside.call(void 0, id, elements, (element) => {
    if (_AQ2LO7WVcjs.isBackdrop.call(void 0, element, ...ids)) return;
    cleanups.unshift(hideElementFromAccessibilityTree(element));
  });
  const restoreAccessibilityTree = () => {
    for (const cleanup of cleanups) {
      cleanup();
    }
  };
  return restoreAccessibilityTree;
}




exports.hideElementFromAccessibilityTree = hideElementFromAccessibilityTree; exports.disableAccessibilityTreeOutside = disableAccessibilityTreeOutside;
