"use strict";Object.defineProperty(exports, "__esModule", {value: true});

var _OZM4QA2Vcjs = require('./OZM4QA2V.cjs');

// src/dialog/utils/use-nested-dialogs.tsx
var _misc = require('@ariakit/core/utils/misc');
var _store = require('@ariakit/core/utils/store');






var _react = require('react');
var _jsxruntime = require('react/jsx-runtime');
var NestedDialogsContext = _react.createContext.call(void 0, {});
function useNestedDialogs(store) {
  const context = _react.useContext.call(void 0, NestedDialogsContext);
  const [dialogs, setDialogs] = _react.useState.call(void 0, []);
  const add = _react.useCallback.call(void 0, 
    (dialog) => {
      var _a;
      setDialogs((dialogs2) => [...dialogs2, dialog]);
      return _misc.chain.call(void 0, (_a = context.add) == null ? void 0 : _a.call(context, dialog), () => {
        setDialogs((dialogs2) => dialogs2.filter((d) => d !== dialog));
      });
    },
    [context]
  );
  _OZM4QA2Vcjs.useSafeLayoutEffect.call(void 0, () => {
    return _store.sync.call(void 0, store, ["open", "contentElement"], (state) => {
      var _a;
      if (!state.open) return;
      if (!state.contentElement) return;
      return (_a = context.add) == null ? void 0 : _a.call(context, store);
    });
  }, [store, context]);
  const providerValue = _react.useMemo.call(void 0, () => ({ store, add }), [store, add]);
  const wrapElement = _react.useCallback.call(void 0, 
    (element) => /* @__PURE__ */ _jsxruntime.jsx.call(void 0, NestedDialogsContext.Provider, { value: providerValue, children: element }),
    [providerValue]
  );
  return { wrapElement, nestedDialogs: dialogs };
}



exports.useNestedDialogs = useNestedDialogs;
