"use strict";Object.defineProperty(exports, "__esModule", {value: true});

var _VIIJ4PIKcjs = require('./VIIJ4PIK.cjs');





var _PH2DFCJScjs = require('./PH2DFCJS.cjs');




var _WULEED4Qcjs = require('./WULEED4Q.cjs');






var _OZM4QA2Vcjs = require('./OZM4QA2V.cjs');




var _7EQBAZ46cjs = require('./7EQBAZ46.cjs');

// src/combobox/combobox-list.tsx
var _misc = require('@ariakit/core/utils/misc');
var _react = require('react');
var _jsxruntime = require('react/jsx-runtime');
var TagName = "div";
var useComboboxList = _WULEED4Qcjs.createHook.call(void 0, 
  function useComboboxList2(_a) {
    var _b = _a, { store, alwaysVisible } = _b, props = _7EQBAZ46cjs.__objRest.call(void 0, _b, ["store", "alwaysVisible"]);
    const scopedContext = _PH2DFCJScjs.useComboboxScopedContext.call(void 0, true);
    const context = _PH2DFCJScjs.useComboboxContext.call(void 0, );
    store = store || context;
    const scopedContextSameStore = !!store && store === scopedContext;
    _misc.invariant.call(void 0, 
      store,
      process.env.NODE_ENV !== "production" && "ComboboxList must receive a `store` prop or be wrapped in a ComboboxProvider component."
    );
    const ref = _react.useRef.call(void 0, null);
    const id = _OZM4QA2Vcjs.useId.call(void 0, props.id);
    const mounted = store.useState("mounted");
    const hidden = _VIIJ4PIKcjs.isHidden.call(void 0, mounted, props.hidden, alwaysVisible);
    const style = hidden ? _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {}, props.style), { display: "none" }) : props.style;
    const multiSelectable = store.useState(
      (state) => Array.isArray(state.selectedValue)
    );
    const role = _OZM4QA2Vcjs.useAttribute.call(void 0, ref, "role", props.role);
    const isCompositeRole = role === "listbox" || role === "tree" || role === "grid";
    const ariaMultiSelectable = isCompositeRole ? multiSelectable || void 0 : void 0;
    const [hasListboxInside, setHasListboxInside] = _react.useState.call(void 0, false);
    const contentElement = store.useState("contentElement");
    _OZM4QA2Vcjs.useSafeLayoutEffect.call(void 0, () => {
      if (!mounted) return;
      const element = ref.current;
      if (!element) return;
      if (contentElement !== element) return;
      const callback = () => {
        setHasListboxInside(!!element.querySelector("[role='listbox']"));
      };
      const observer = new MutationObserver(callback);
      observer.observe(element, {
        subtree: true,
        childList: true,
        attributeFilter: ["role"]
      });
      callback();
      return () => observer.disconnect();
    }, [mounted, contentElement]);
    if (!hasListboxInside) {
      props = _7EQBAZ46cjs.__spreadValues.call(void 0, {
        role: "listbox",
        "aria-multiselectable": ariaMultiSelectable
      }, props);
    }
    props = _OZM4QA2Vcjs.useWrapElement.call(void 0, 
      props,
      (element) => /* @__PURE__ */ _jsxruntime.jsx.call(void 0, _PH2DFCJScjs.ComboboxScopedContextProvider, { value: store, children: /* @__PURE__ */ _jsxruntime.jsx.call(void 0, _PH2DFCJScjs.ComboboxListRoleContext.Provider, { value: role, children: element }) }),
      [store, role]
    );
    const setContentElement = id && (!scopedContext || !scopedContextSameStore) ? store.setContentElement : null;
    props = _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {
      id,
      hidden
    }, props), {
      ref: _OZM4QA2Vcjs.useMergeRefs.call(void 0, setContentElement, ref, props.ref),
      style
    });
    return _misc.removeUndefinedValues.call(void 0, props);
  }
);
var ComboboxList = _WULEED4Qcjs.forwardRef.call(void 0, function ComboboxList2(props) {
  const htmlProps = useComboboxList(props);
  return _WULEED4Qcjs.createElement.call(void 0, TagName, htmlProps);
});




exports.useComboboxList = useComboboxList; exports.ComboboxList = ComboboxList;
