"use strict";Object.defineProperty(exports, "__esModule", {value: true});// src/dialog/utils/use-previous-mouse-down-ref.ts
var _events = require('@ariakit/core/utils/events');
var _react = require('react');
function usePreviousMouseDownRef(enabled) {
  const previousMouseDownRef = _react.useRef.call(void 0, );
  _react.useEffect.call(void 0, () => {
    if (!enabled) {
      previousMouseDownRef.current = null;
      return;
    }
    const onMouseDown = (event) => {
      previousMouseDownRef.current = event.target;
    };
    return _events.addGlobalEventListener.call(void 0, "mousedown", onMouseDown, true);
  }, [enabled]);
  return previousMouseDownRef;
}



exports.usePreviousMouseDownRef = usePreviousMouseDownRef;
