"use strict";Object.defineProperty(exports, "__esModule", {value: true});


var _YLCVWFRAcjs = require('./YLCVWFRA.cjs');


var _D6FV6EYScjs = require('./D6FV6EYS.cjs');


var _25BPIGZHcjs = require('./25BPIGZH.cjs');



var _WULEED4Qcjs = require('./WULEED4Q.cjs');


var _OZM4QA2Vcjs = require('./OZM4QA2V.cjs');




var _7EQBAZ46cjs = require('./7EQBAZ46.cjs');

// src/composite/composite-renderer.tsx
var _react = require('react');
var TagName = "div";
function getItemObject(item) {
  if (!item || typeof item !== "object") {
    return { value: item };
  }
  return item;
}
function countItems(items) {
  if (!items) return [0];
  if (typeof items === "number") {
    return Array.from({ length: items }, (_, index) => index + 1);
  }
  return items.reduce((count, item, index) => {
    var _a, _b;
    const object = getItemObject(item);
    if (!object.items) {
    }
    if (!object.items) {
      count[index] = index + 1;
      return count;
    }
    const prevCount = (_a = count[index - 1]) != null ? _a : 0;
    const itemsCount = (_b = countItems(object.items)[object.items.length - 1]) != null ? _b : 0;
    count[index] = prevCount + itemsCount;
    return count;
  }, []);
}
function findFirst(items, offset = 1) {
  for (let index = offset > 0 ? 0 : items.length - 1; index >= 0 && index < items.length; index += offset) {
    const item = items[index];
    const object = getItemObject(item);
    if (object.items && findFirst(object.items, offset) !== -1) return index;
    if (!object.disabled) return index;
  }
  return -1;
}
function findLast(items) {
  return findFirst(items, -1);
}
function findById(items, id, baseId) {
  return items.findIndex((item, index) => {
    var _a;
    const itemId = _YLCVWFRAcjs.getCollectionRendererItemId.call(void 0, item, index, baseId);
    if (itemId === id) return true;
    const object = getItemObject(item);
    if ((_a = object.items) == null ? void 0 : _a.length) return findById(object.items, id, itemId) !== -1;
    const ids = id.split("/");
    if (ids.length === 1) return false;
    return ids.some((id2) => itemId === id2);
  });
}
function useCompositeRenderer(_a) {
  var _b = _a, {
    store,
    orientation: orientationProp,
    persistentIndices: persistentIndicesProp,
    children: renderItem,
    "aria-setsize": ariaSetSize,
    "aria-posinset": ariaPosInSet = 1
  } = _b, props = _7EQBAZ46cjs.__objRest.call(void 0, _b, [
    "store",
    "orientation",
    "persistentIndices",
    "children",
    "aria-setsize",
    "aria-posinset"
  ]);
  const context = _D6FV6EYScjs.useCompositeContext.call(void 0, );
  store = store || context;
  const orientation = _25BPIGZHcjs.useStoreState.call(void 0, 
    store,
    (state) => (orientationProp != null ? orientationProp : (state == null ? void 0 : state.orientation) === "both") ? "vertical" : state == null ? void 0 : state.orientation
  );
  const items = _25BPIGZHcjs.useStoreState.call(void 0, store, (state) => {
    var _a2;
    if (!state) return props.items;
    if ("mounted" in state && !state.mounted) return 0;
    return (_a2 = props.items) != null ? _a2 : state.items;
  });
  const id = _OZM4QA2Vcjs.useId.call(void 0, props.id);
  const itemsCount = _react.useMemo.call(void 0, () => countItems(items), [items]);
  const setSize = _react.useMemo.call(void 0, 
    () => {
      var _a2;
      return (_a2 = ariaSetSize != null ? ariaSetSize : itemsCount[itemsCount.length - 1]) != null ? _a2 : 0;
    },
    [ariaSetSize, itemsCount]
  );
  const firstIndex = _react.useMemo.call(void 0, () => {
    if (!items) return -1;
    if (typeof items === "number") return 0;
    if (!items.length) return -1;
    return findFirst(items);
  }, [items]);
  const lastIndex = _react.useMemo.call(void 0, () => {
    if (!items) return -1;
    if (typeof items === "number") return items - 1;
    if (!items.length) return -1;
    return findLast(items);
  }, [items]);
  const activeId = _25BPIGZHcjs.useStoreState.call(void 0, store, "activeId");
  const activeIndex = _react.useMemo.call(void 0, () => {
    if (!id) return -1;
    if (!items) return -1;
    if (activeId == null) return -1;
    if (typeof items === "number") return -1;
    if (!items.length) return -1;
    return findById(items, activeId, id);
  }, [id, items, activeId]);
  const persistentIndices = _react.useMemo.call(void 0, () => {
    const indices = [firstIndex, activeIndex, lastIndex].filter(
      (index) => index >= 0
    );
    if (persistentIndicesProp) {
      return [...persistentIndicesProp, ...indices];
    }
    return indices;
  }, [firstIndex, activeIndex, lastIndex, persistentIndicesProp]);
  return _YLCVWFRAcjs.useCollectionRenderer.call(void 0, _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {
    id,
    store,
    orientation,
    persistentIndices
  }, props), {
    children: (item) => {
      var _a2;
      const nextItem = _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {}, item), {
        "aria-setsize": setSize,
        "aria-posinset": ariaPosInSet + ((_a2 = itemsCount[item.index - 1]) != null ? _a2 : 0)
      });
      return renderItem == null ? void 0 : renderItem(nextItem);
    }
  }));
}
var CompositeRenderer = _WULEED4Qcjs.forwardRef.call(void 0, function CompositeRenderer2(props) {
  const htmlProps = useCompositeRenderer(props);
  return _WULEED4Qcjs.createElement.call(void 0, TagName, htmlProps);
});




exports.useCompositeRenderer = useCompositeRenderer; exports.CompositeRenderer = CompositeRenderer;
