"use strict";Object.defineProperty(exports, "__esModule", {value: true});

var _MIBORXQWcjs = require('./MIBORXQW.cjs');


var _D6FV6EYScjs = require('./D6FV6EYS.cjs');


var _25BPIGZHcjs = require('./25BPIGZH.cjs');




var _WULEED4Qcjs = require('./WULEED4Q.cjs');



var _OZM4QA2Vcjs = require('./OZM4QA2V.cjs');




var _7EQBAZ46cjs = require('./7EQBAZ46.cjs');

// src/composite/composite-container.tsx
var _dom = require('@ariakit/core/utils/dom');
var _events = require('@ariakit/core/utils/events');




var _focus = require('@ariakit/core/utils/focus');
var _misc = require('@ariakit/core/utils/misc');
var _react = require('react');
var TagName = "div";
function getFirstTabbable(container) {
  _focus.restoreFocusIn.call(void 0, container);
  const tabbable = _focus.getFirstTabbableIn.call(void 0, container);
  _focus.disableFocusIn.call(void 0, container);
  return tabbable;
}
var useCompositeContainer = _WULEED4Qcjs.createHook.call(void 0, function useCompositeContainer2(_a) {
  var _b = _a, { store } = _b, props = _7EQBAZ46cjs.__objRest.call(void 0, _b, ["store"]);
  const context = _D6FV6EYScjs.useCompositeContext.call(void 0, );
  store = store || context;
  const ref = _react.useRef.call(void 0, null);
  const isOpenRef = _react.useRef.call(void 0, false);
  const open = (collapseToEnd = false) => {
    const container = ref.current;
    if (!container) return;
    _focus.restoreFocusIn.call(void 0, container);
    const tabbable = _focus.getFirstTabbableIn.call(void 0, container);
    if (!tabbable) {
      _focus.disableFocusIn.call(void 0, container);
      return;
    }
    isOpenRef.current = true;
    queueMicrotask(() => {
      tabbable.focus();
      if (_dom.isTextField.call(void 0, tabbable) || tabbable.isContentEditable) {
        _MIBORXQWcjs.selectTextField.call(void 0, tabbable, collapseToEnd);
      }
    });
  };
  const close = () => {
    const container = ref.current;
    if (!container) return;
    isOpenRef.current = false;
    _focus.disableFocusIn.call(void 0, container);
  };
  const renderedItems = _25BPIGZHcjs.useStoreState.call(void 0, store, "renderedItems");
  _react.useEffect.call(void 0, () => {
    const container = ref.current;
    if (!container) return;
    const isOpen = isOpenRef.current;
    if (!isOpen && (renderedItems == null ? void 0 : renderedItems.length)) {
      _focus.disableFocusIn.call(void 0, container);
    }
  }, [renderedItems]);
  const onFocusProp = props.onFocus;
  const onFocus = _OZM4QA2Vcjs.useEvent.call(void 0, (event) => {
    onFocusProp == null ? void 0 : onFocusProp(event);
    if (event.defaultPrevented) return;
    if (!store) return;
    const isOpen = isOpenRef.current;
    if (_events.isSelfTarget.call(void 0, event)) {
      isOpenRef.current = false;
      const { baseElement } = store.getState();
      const composite = baseElement;
      const selector = "[data-composite-container]";
      const containers = composite == null ? void 0 : composite.querySelectorAll(selector);
      if (containers) {
        for (const container of containers) {
          _focus.disableFocusIn.call(void 0, container);
        }
      }
    } else if (!isOpen) {
      isOpenRef.current = true;
      _focus.restoreFocusIn.call(void 0, event.currentTarget);
      store == null ? void 0 : store.setState("moves", 0);
    }
  });
  const onBlurProp = props.onBlur;
  const onBlur = _OZM4QA2Vcjs.useEvent.call(void 0, (event) => {
    onBlurProp == null ? void 0 : onBlurProp(event);
    if (event.defaultPrevented) return;
    if (_events.isFocusEventOutside.call(void 0, event)) {
      close();
    }
  });
  const onKeyDownProp = props.onKeyDown;
  const onKeyDown = _OZM4QA2Vcjs.useEvent.call(void 0, (event) => {
    onKeyDownProp == null ? void 0 : onKeyDownProp(event);
    if (event.defaultPrevented) return;
    if (event.altKey) return;
    if (event.ctrlKey) return;
    if (event.metaKey) return;
    if (event.shiftKey) return;
    const container = event.currentTarget;
    if (_events.isSelfTarget.call(void 0, event)) {
      if (event.key.length === 1 && event.key !== " ") {
        const tabbable = getFirstTabbable(container);
        if (!tabbable) return;
        if (_dom.isTextField.call(void 0, tabbable) || tabbable.isContentEditable) {
          event.stopPropagation();
          open();
        }
      } else if (event.key === "Delete" || event.key === "Backspace") {
        const tabbable = getFirstTabbable(container);
        if (!tabbable) return;
        if (_dom.isTextField.call(void 0, tabbable) || tabbable.isContentEditable) {
          open();
          const onInput = () => queueMicrotask(() => container.focus());
          container.addEventListener("input", onInput, { once: true });
        }
      }
    } else if (event.key === "Escape") {
      queueMicrotask(() => container.focus());
    } else if (event.key === "Enter") {
      const target = event.target;
      const isInput = target.tagName === "INPUT" && !_dom.isButton.call(void 0, target) || target.tagName === "TEXTAREA";
      if (isInput || target.isContentEditable) {
        event.preventDefault();
        queueMicrotask(() => container.focus());
      }
    }
  });
  const onClickProp = props.onClick;
  const onClick = _OZM4QA2Vcjs.useEvent.call(void 0, (event) => {
    onClickProp == null ? void 0 : onClickProp(event);
    if (event.defaultPrevented) return;
    if (_events.isSelfTarget.call(void 0, event) && !event.detail) {
      open(true);
    }
  });
  props = _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {
    "data-composite-container": ""
  }, props), {
    ref: _OZM4QA2Vcjs.useMergeRefs.call(void 0, ref, props.ref),
    onFocus,
    onBlur,
    onKeyDown,
    onClick
  });
  return _misc.removeUndefinedValues.call(void 0, props);
});
var CompositeContainer = _WULEED4Qcjs.forwardRef.call(void 0, function CompositeContainer2(props) {
  const htmlProps = useCompositeContainer(props);
  return _WULEED4Qcjs.createElement.call(void 0, TagName, htmlProps);
});




exports.useCompositeContainer = useCompositeContainer; exports.CompositeContainer = CompositeContainer;
