"use strict";Object.defineProperty(exports, "__esModule", {value: true});

var _YVOQ2BCBcjs = require('./YVOQ2BCB.cjs');


var _4SKDRUBRcjs = require('./4SKDRUBR.cjs');


var _AQ2LO7WVcjs = require('./AQ2LO7WV.cjs');

// src/dialog/utils/mark-tree-outside.ts
var _misc = require('@ariakit/core/utils/misc');
function getPropertyName(id = "", ancestor = false) {
  return `__ariakit-dialog-${ancestor ? "ancestor" : "outside"}${id ? `-${id}` : ""}`;
}
function markElement(element, id = "") {
  return _misc.chain.call(void 0, 
    _4SKDRUBRcjs.setProperty.call(void 0, element, getPropertyName(), true),
    _4SKDRUBRcjs.setProperty.call(void 0, element, getPropertyName(id), true)
  );
}
function markAncestor(element, id = "") {
  return _misc.chain.call(void 0, 
    _4SKDRUBRcjs.setProperty.call(void 0, element, getPropertyName("", true), true),
    _4SKDRUBRcjs.setProperty.call(void 0, element, getPropertyName(id, true), true)
  );
}
function isElementMarked(element, id) {
  const ancestorProperty = getPropertyName(id, true);
  if (element[ancestorProperty]) return true;
  const elementProperty = getPropertyName(id);
  do {
    if (element[elementProperty]) return true;
    if (!element.parentElement) return false;
    element = element.parentElement;
  } while (true);
}
function markTreeOutside(id, elements) {
  const cleanups = [];
  const ids = elements.map((el) => el == null ? void 0 : el.id);
  _YVOQ2BCBcjs.walkTreeOutside.call(void 0, 
    id,
    elements,
    (element) => {
      if (_AQ2LO7WVcjs.isBackdrop.call(void 0, element, ...ids)) return;
      cleanups.unshift(markElement(element, id));
    },
    (ancestor, element) => {
      const isAnotherDialogAncestor = element.hasAttribute("data-dialog") && element.id !== id;
      if (isAnotherDialogAncestor) return;
      cleanups.unshift(markAncestor(ancestor, id));
    }
  );
  const restoreAccessibilityTree = () => {
    for (const cleanup of cleanups) {
      cleanup();
    }
  };
  return restoreAccessibilityTree;
}






exports.markElement = markElement; exports.markAncestor = markAncestor; exports.isElementMarked = isElementMarked; exports.markTreeOutside = markTreeOutside;
