"use strict";Object.defineProperty(exports, "__esModule", {value: true}); function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { newObj[key] = obj[key]; } } } newObj.default = obj; return newObj; } } function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }



var _OZM4QA2Vcjs = require('./OZM4QA2V.cjs');



var _7EQBAZ46cjs = require('./7EQBAZ46.cjs');

// src/utils/store.tsx
var _misc = require('@ariakit/core/utils/misc');
var _store = require('@ariakit/core/utils/store');
var _react = require('react'); var React = _interopRequireWildcard(_react);
var _indexjs = require('use-sync-external-store/shim/index.js'); var _indexjs2 = _interopRequireDefault(_indexjs);
var { useSyncExternalStore } = _indexjs2.default;
var noopSubscribe = () => () => {
};
function useStoreState(store, keyOrSelector = _misc.identity) {
  const storeSubscribe = React.useCallback(
    (callback) => {
      if (!store) return noopSubscribe();
      return _store.subscribe.call(void 0, store, null, callback);
    },
    [store]
  );
  const getSnapshot = () => {
    const key = typeof keyOrSelector === "string" ? keyOrSelector : null;
    const selector = typeof keyOrSelector === "function" ? keyOrSelector : null;
    const state = store == null ? void 0 : store.getState();
    if (selector) return selector(state);
    if (!state) return;
    if (!key) return;
    if (!_misc.hasOwnProperty.call(void 0, state, key)) return;
    return state[key];
  };
  return useSyncExternalStore(storeSubscribe, getSnapshot, getSnapshot);
}
function useStoreStateObject(store, object) {
  const objRef = React.useRef(
    {}
  );
  const storeSubscribe = React.useCallback(
    (callback) => {
      if (!store) return noopSubscribe();
      return _store.subscribe.call(void 0, store, null, callback);
    },
    [store]
  );
  const getSnapshot = () => {
    const state = store == null ? void 0 : store.getState();
    let updated = false;
    const obj = objRef.current;
    for (const prop in object) {
      const keyOrSelector = object[prop];
      if (typeof keyOrSelector === "function") {
        const value = keyOrSelector(state);
        if (value !== obj[prop]) {
          obj[prop] = value;
          updated = true;
        }
      }
      if (typeof keyOrSelector === "string") {
        if (!state) continue;
        if (!_misc.hasOwnProperty.call(void 0, state, keyOrSelector)) continue;
        const value = state[keyOrSelector];
        if (value !== obj[prop]) {
          obj[prop] = value;
          updated = true;
        }
      }
    }
    if (updated) {
      objRef.current = _7EQBAZ46cjs.__spreadValues.call(void 0, {}, obj);
    }
    return objRef.current;
  };
  return useSyncExternalStore(storeSubscribe, getSnapshot, getSnapshot);
}
function useStoreProps(store, props, key, setKey) {
  const value = _misc.hasOwnProperty.call(void 0, props, key) ? props[key] : void 0;
  const setValue = setKey ? props[setKey] : void 0;
  const propsRef = _OZM4QA2Vcjs.useLiveRef.call(void 0, { value, setValue });
  _OZM4QA2Vcjs.useSafeLayoutEffect.call(void 0, () => {
    return _store.sync.call(void 0, store, [key], (state, prev) => {
      const { value: value2, setValue: setValue2 } = propsRef.current;
      if (!setValue2) return;
      if (state[key] === prev[key]) return;
      if (state[key] === value2) return;
      setValue2(state[key]);
    });
  }, [store, key]);
  _OZM4QA2Vcjs.useSafeLayoutEffect.call(void 0, () => {
    if (value === void 0) return;
    store.setState(key, value);
    return _store.batch.call(void 0, store, [key], () => {
      if (value === void 0) return;
      store.setState(key, value);
    });
  });
}
function useStore(createStore, props) {
  const [store, setStore] = React.useState(() => createStore(props));
  _OZM4QA2Vcjs.useSafeLayoutEffect.call(void 0, () => _store.init.call(void 0, store), [store]);
  const useState2 = React.useCallback(
    (keyOrSelector) => useStoreState(store, keyOrSelector),
    [store]
  );
  const memoizedStore = React.useMemo(
    () => _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {}, store), { useState: useState2 }),
    [store, useState2]
  );
  const updateStore = _OZM4QA2Vcjs.useEvent.call(void 0, () => {
    setStore((store2) => createStore(_7EQBAZ46cjs.__spreadValues.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {}, props), store2.getState())));
  });
  return [memoizedStore, updateStore];
}






exports.useStoreState = useStoreState; exports.useStoreStateObject = useStoreStateObject; exports.useStoreProps = useStoreProps; exports.useStore = useStore;
