"use strict";Object.defineProperty(exports, "__esModule", {value: true});

var _SHOLYDNPcjs = require('../__chunks/SHOLYDNP.cjs');


var _RNIVVQWXcjs = require('../__chunks/RNIVVQWX.cjs');
require('../__chunks/GDZQUFNP.cjs');
require('../__chunks/MNBBM5CR.cjs');
require('../__chunks/726BNPQZ.cjs');




var _ASR6PAFNcjs = require('../__chunks/ASR6PAFN.cjs');



var _MLCPLY2Pcjs = require('../__chunks/MLCPLY2P.cjs');



var _7EQBAZ46cjs = require('../__chunks/7EQBAZ46.cjs');

// src/tag/tag-store.ts
function createTagStore(props = {}) {
  var _a;
  const syncState = (_a = props.store) == null ? void 0 : _a.getState();
  const composite = _RNIVVQWXcjs.createCompositeStore.call(void 0, props);
  const initialState = _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {}, composite.getState()), {
    inputElement: _MLCPLY2Pcjs.defaultValue.call(void 0, syncState == null ? void 0 : syncState.inputElement, null),
    labelElement: _MLCPLY2Pcjs.defaultValue.call(void 0, syncState == null ? void 0 : syncState.labelElement, null),
    value: _MLCPLY2Pcjs.defaultValue.call(void 0, props.value, syncState == null ? void 0 : syncState.value, props.defaultValue, ""),
    values: _MLCPLY2Pcjs.defaultValue.call(void 0, 
      props.values,
      syncState == null ? void 0 : syncState.values,
      props.defaultValues,
      []
    )
  });
  const tag = _ASR6PAFNcjs.createStore.call(void 0, initialState, composite, props.store);
  _ASR6PAFNcjs.setup.call(void 0, 
    tag,
    () => _ASR6PAFNcjs.sync.call(void 0, tag, ["inputElement", "activeId"], (state) => {
      if (!state.inputElement) return;
      if (state.activeId !== void 0) return;
      tag.setState("activeId", state.inputElement.id);
    })
  );
  const setValues = (values) => {
    const { values: previousValues } = tag.getState();
    _SHOLYDNPcjs.UndoManager.execute(() => {
      let changed = true;
      tag.setState("values", (prev) => {
        const next = _MLCPLY2Pcjs.applyState.call(void 0, values, prev);
        if (next === prev) {
          changed = false;
        }
        return next;
      });
      if (!changed) return;
      return () => {
        var _a2;
        tag.setState("values", previousValues);
        composite.move((_a2 = tag.getState().inputElement) == null ? void 0 : _a2.id);
      };
    });
  };
  return _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {}, composite), tag), {
    setInputElement: (inputElement) => tag.setState("inputElement", inputElement),
    setLabelElement: (labelElement) => tag.setState("labelElement", labelElement),
    setValue: (value) => tag.setState("value", value),
    resetValue: () => tag.setState("value", initialState.value),
    setValues,
    addValue: (value) => {
      setValues((values) => {
        if (values.includes(value)) return values;
        return [...values, value];
      });
    },
    removeValue: (value) => setValues((values) => values.filter((v) => v !== value))
  });
}


exports.createTagStore = createTagStore;
