"use strict";Object.defineProperty(exports, "__esModule", {value: true});

var _RNIVVQWXcjs = require('../__chunks/RNIVVQWX.cjs');
require('../__chunks/GDZQUFNP.cjs');


var _MNBBM5CRcjs = require('../__chunks/MNBBM5CR.cjs');
require('../__chunks/726BNPQZ.cjs');







var _ASR6PAFNcjs = require('../__chunks/ASR6PAFN.cjs');



var _MLCPLY2Pcjs = require('../__chunks/MLCPLY2P.cjs');




var _7EQBAZ46cjs = require('../__chunks/7EQBAZ46.cjs');

// src/tab/tab-store.ts
function createTabStore(_a = {}) {
  var _b = _a, {
    composite: parentComposite,
    combobox
  } = _b, props = _7EQBAZ46cjs.__objRest.call(void 0, _b, [
    "composite",
    "combobox"
  ]);
  const independentKeys = [
    "items",
    "renderedItems",
    "moves",
    "orientation",
    "virtualFocus",
    "includesBaseElement",
    "baseElement",
    "focusLoop",
    "focusShift",
    "focusWrap"
  ];
  const store = _ASR6PAFNcjs.mergeStore.call(void 0, 
    props.store,
    _ASR6PAFNcjs.omit.call(void 0, parentComposite, independentKeys),
    _ASR6PAFNcjs.omit.call(void 0, combobox, independentKeys)
  );
  const syncState = store == null ? void 0 : store.getState();
  const composite = _RNIVVQWXcjs.createCompositeStore.call(void 0, _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {}, props), {
    store,
    // We need to explicitly set the default value of `includesBaseElement` to
    // `false` since we don't want the composite store to default it to `true`
    // when the activeId state is null, which could be the case when rendering
    // combobox with tab.
    includesBaseElement: _MLCPLY2Pcjs.defaultValue.call(void 0, 
      props.includesBaseElement,
      syncState == null ? void 0 : syncState.includesBaseElement,
      false
    ),
    orientation: _MLCPLY2Pcjs.defaultValue.call(void 0, 
      props.orientation,
      syncState == null ? void 0 : syncState.orientation,
      "horizontal"
    ),
    focusLoop: _MLCPLY2Pcjs.defaultValue.call(void 0, props.focusLoop, syncState == null ? void 0 : syncState.focusLoop, true)
  }));
  const panels = _MNBBM5CRcjs.createCollectionStore.call(void 0, );
  const initialState = _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {}, composite.getState()), {
    selectedId: _MLCPLY2Pcjs.defaultValue.call(void 0, 
      props.selectedId,
      syncState == null ? void 0 : syncState.selectedId,
      props.defaultSelectedId
    ),
    selectOnMove: _MLCPLY2Pcjs.defaultValue.call(void 0, 
      props.selectOnMove,
      syncState == null ? void 0 : syncState.selectOnMove,
      true
    )
  });
  const tab = _ASR6PAFNcjs.createStore.call(void 0, initialState, composite, store);
  _ASR6PAFNcjs.setup.call(void 0, 
    tab,
    () => _ASR6PAFNcjs.sync.call(void 0, tab, ["moves"], () => {
      const { activeId, selectOnMove } = tab.getState();
      if (!selectOnMove) return;
      if (!activeId) return;
      const tabItem = composite.item(activeId);
      if (!tabItem) return;
      if (tabItem.dimmed) return;
      if (tabItem.disabled) return;
      tab.setState("selectedId", tabItem.id);
    })
  );
  let syncActiveId = true;
  _ASR6PAFNcjs.setup.call(void 0, 
    tab,
    () => _ASR6PAFNcjs.batch.call(void 0, tab, ["selectedId"], (state, prev) => {
      if (!syncActiveId) {
        syncActiveId = true;
        return;
      }
      if (parentComposite && state.selectedId === prev.selectedId) return;
      tab.setState("activeId", state.selectedId);
    })
  );
  _ASR6PAFNcjs.setup.call(void 0, 
    tab,
    () => _ASR6PAFNcjs.sync.call(void 0, tab, ["selectedId", "renderedItems"], (state) => {
      if (state.selectedId !== void 0) return;
      const { activeId, renderedItems } = tab.getState();
      const tabItem = composite.item(activeId);
      if (tabItem && !tabItem.disabled && !tabItem.dimmed) {
        tab.setState("selectedId", tabItem.id);
      } else {
        const tabItem2 = renderedItems.find(
          (item) => !item.disabled && !item.dimmed
        );
        tab.setState("selectedId", tabItem2 == null ? void 0 : tabItem2.id);
      }
    })
  );
  _ASR6PAFNcjs.setup.call(void 0, 
    tab,
    () => _ASR6PAFNcjs.sync.call(void 0, tab, ["renderedItems"], (state) => {
      const tabs = state.renderedItems;
      if (!tabs.length) return;
      return _ASR6PAFNcjs.sync.call(void 0, panels, ["renderedItems"], (state2) => {
        const items = state2.renderedItems;
        const hasOrphanPanels = items.some((panel) => !panel.tabId);
        if (!hasOrphanPanels) return;
        items.forEach((panel, i) => {
          if (panel.tabId) return;
          const tabItem = tabs[i];
          if (!tabItem) return;
          panels.renderItem(_7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {}, panel), { tabId: tabItem.id }));
        });
      });
    })
  );
  let selectedIdFromSelectedValue = null;
  _ASR6PAFNcjs.setup.call(void 0, tab, () => {
    const backupSelectedId = () => {
      selectedIdFromSelectedValue = tab.getState().selectedId;
    };
    const restoreSelectedId = () => {
      syncActiveId = false;
      tab.setState("selectedId", selectedIdFromSelectedValue);
    };
    if (parentComposite && "setSelectElement" in parentComposite) {
      return _MLCPLY2Pcjs.chain.call(void 0, 
        _ASR6PAFNcjs.sync.call(void 0, parentComposite, ["value"], backupSelectedId),
        _ASR6PAFNcjs.sync.call(void 0, parentComposite, ["mounted"], restoreSelectedId)
      );
    }
    if (!combobox) return;
    return _MLCPLY2Pcjs.chain.call(void 0, 
      _ASR6PAFNcjs.sync.call(void 0, combobox, ["selectedValue"], backupSelectedId),
      _ASR6PAFNcjs.sync.call(void 0, combobox, ["mounted"], restoreSelectedId)
    );
  });
  return _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {}, composite), tab), {
    panels,
    setSelectedId: (id) => tab.setState("selectedId", id),
    select: (id) => {
      tab.setState("selectedId", id);
      composite.move(id);
    }
  });
}


exports.createTabStore = createTabStore;
