import type { CompositeStoreFunctions, CompositeStoreItem, CompositeStoreOptions, CompositeStoreState } from "../composite/composite-store.ts";
import type { PopoverStoreFunctions, PopoverStoreOptions, PopoverStoreState } from "../popover/popover-store.ts";
import type { TagStore } from "../tag/tag-store.ts";
import type { Store, StoreOptions, StoreProps } from "../utils/store.ts";
import type { PickRequired, SetState } from "../utils/types.ts";
type MutableValue<T extends ComboboxStoreSelectedValue = ComboboxStoreSelectedValue> = T extends string ? string : T;
/**
 * Creates a combobox store.
 */
export declare function createComboboxStore<T extends ComboboxStoreSelectedValue = ComboboxStoreSelectedValue>(props: PickRequired<ComboboxStoreProps<T>, "selectedValue" | "defaultSelectedValue">): ComboboxStore<T>;
export declare function createComboboxStore(props?: ComboboxStoreProps): ComboboxStore;
export type ComboboxStoreSelectedValue = string | string[];
export interface ComboboxStoreItem extends CompositeStoreItem {
    value?: string;
}
export interface ComboboxStoreState<T extends ComboboxStoreSelectedValue = ComboboxStoreSelectedValue> extends CompositeStoreState<ComboboxStoreItem>, PopoverStoreState {
    /** @default true */
    includesBaseElement: CompositeStoreState<ComboboxStoreItem>["includesBaseElement"];
    /** @default true */
    focusLoop: CompositeStoreState<ComboboxStoreItem>["focusLoop"];
    /** @default true */
    focusWrap: CompositeStoreState<ComboboxStoreItem>["focusWrap"];
    /** @default "vertical" */
    orientation: CompositeStoreState<ComboboxStoreItem>["orientation"];
    /** @default true */
    virtualFocus: CompositeStoreState<ComboboxStoreItem>["virtualFocus"];
    /**
     * The combobox input value.
     *
     * Live examples:
     * - [Combobox with integrated
     *   filter](https://ariakit.org/examples/combobox-filtering-integrated)
     * - [Combobox with links](https://ariakit.org/examples/combobox-links)
     * - [Combobox filtering](https://ariakit.org/examples/combobox-filtering)
     * - [Multi-selectable
     *   Combobox](https://ariakit.org/examples/combobox-multiple)
     * - [Textarea with inline
     *   Combobox](https://ariakit.org/examples/combobox-textarea)
     * - [Command Menu with
     *   Tabs](https://ariakit.org/examples/dialog-combobox-tab-command-menu)
     */
    value: string;
    /**
     * The value of the currently active item. This state automatically updates as
     * the user navigates the combobox items either by keyboard or mouse click.
     * Note that it doesn't update when the user simply hovers over the items.
     */
    activeValue: string | undefined;
    /**
     * The value(s) of the currently selected item(s). This can be a string or an
     * array of strings. If it's an array, the combobox is considered
     * [multi-selectable](https://ariakit.org/examples/combobox-multiple).
     *
     * Live examples:
     * - [Multi-selectable
     *   Combobox](https://ariakit.org/examples/combobox-multiple)
     */
    selectedValue: MutableValue<T>;
    /**
     * Whether to reset the value when the combobox popover closes. This prop is
     * automatically set to `true` by default if the combobox supports multiple
     * selections. In other words, if the
     * [`selectedValue`](https://ariakit.org/reference/combobox-provider#selectedvalue)
     * or
     * [`defaultSelectedValue`](https://ariakit.org/reference/combobox-provider#defaultselectedvalue)
     * props are arrays.
     *
     * Live examples:
     * - [Multi-selectable
     *   Combobox](https://ariakit.org/examples/combobox-multiple)
     * - [Menu with Combobox](https://ariakit.org/examples/menu-combobox)
     * - [Select with Combobox](https://ariakit.org/examples/select-combobox)
     * - [Submenu with
     *   Combobox](https://ariakit.org/examples/menu-nested-combobox)
     * - [Command Menu with
     *   Tabs](https://ariakit.org/examples/dialog-combobox-tab-command-menu)
     * - [Select with Combobox and
     *   Tabs](https://ariakit.org/examples/select-combobox-tab)
     */
    resetValueOnHide: boolean;
    /**
     * Whether to reset the value when an item is selected. This prop is
     * automatically set to `true` by default if the combobox supports multiple
     * selections. In other words, if the
     * [`selectedValue`](https://ariakit.org/reference/combobox-provider#selectedvalue)
     * or
     * [`defaultSelectedValue`](https://ariakit.org/reference/combobox-provider#defaultselectedvalue)
     * props are arrays.
     * @deprecated Use the
     * [`resetValueOnSelect`](https://ariakit.org/reference/combobox-item#resetvalueonselect)
     * prop on [`ComboboxItem`](https://ariakit.org/reference/combobox-item)
     * instead.
     */
    resetValueOnSelect: boolean;
}
export interface ComboboxStoreFunctions<T extends ComboboxStoreSelectedValue = ComboboxStoreSelectedValue> extends Pick<ComboboxStoreOptions<T>, "tag">, CompositeStoreFunctions<ComboboxStoreItem>, PopoverStoreFunctions {
    /**
     * Sets the [`value`](https://ariakit.org/reference/combobox-provider#value)
     * state.
     *
     * Live examples:
     * - [Textarea with inline
     *   Combobox](https://ariakit.org/examples/combobox-textarea)
     * @example
     * store.setValue("Hello world");
     * store.setValue((value) => value + "!");
     */
    setValue: SetState<ComboboxStoreState<T>["value"]>;
    /**
     * Resets the [`value`](https://ariakit.org/reference/combobox-provider#value)
     * state to its initial value.
     */
    resetValue: () => void;
    /**
     * Sets the
     * [`selectedValue`](https://ariakit.org/reference/combobox-provider#selectedvalue)
     * state.
     */
    setSelectedValue: SetState<ComboboxStoreState<T>["selectedValue"]>;
}
export interface ComboboxStoreOptions<T extends ComboboxStoreSelectedValue = ComboboxStoreSelectedValue> extends StoreOptions<ComboboxStoreState<T>, "includesBaseElement" | "focusLoop" | "focusWrap" | "orientation" | "virtualFocus" | "value" | "selectedValue" | "resetValueOnHide" | "resetValueOnSelect">, CompositeStoreOptions<ComboboxStoreItem>, PopoverStoreOptions {
    /** @default null */
    defaultActiveId?: CompositeStoreOptions<ComboboxStoreItem>["activeId"];
    /**
     * The initial value of the combobox input.
     * @default ""
     */
    defaultValue?: ComboboxStoreState<T>["value"];
    /**
     * The initial value of the
     * [`selectedValue`](https://ariakit.org/reference/combobox-provider#selectedvalue)
     * state. This can be a string or an array of strings. If it's an array, the
     * combobox is considered
     * [multi-selectable](https://ariakit.org/examples/combobox-multiple).
     * @default ""
     */
    defaultSelectedValue?: ComboboxStoreState<T>["selectedValue"];
    /**
     * A reference to a tag store. This is used when rendering a combobox within a
     * tag list. The stores will share the same state.
     */
    tag?: TagStore | null;
}
export interface ComboboxStoreProps<T extends ComboboxStoreSelectedValue = ComboboxStoreSelectedValue> extends ComboboxStoreOptions<T>, StoreProps<ComboboxStoreState<T>> {
}
export interface ComboboxStore<T extends ComboboxStoreSelectedValue = ComboboxStoreSelectedValue> extends ComboboxStoreFunctions<T>, Store<ComboboxStoreState<T>> {
}
export {};
