"use strict";Object.defineProperty(exports, "__esModule", {value: true});

var _726BNPQZcjs = require('./726BNPQZ.cjs');

// src/utils/platform.ts
function isTouchDevice() {
  return _726BNPQZcjs.canUseDOM && !!navigator.maxTouchPoints;
}
function isApple() {
  if (!_726BNPQZcjs.canUseDOM) return false;
  return /mac|iphone|ipad|ipod/i.test(navigator.platform);
}
function isSafari() {
  return _726BNPQZcjs.canUseDOM && isApple() && /apple/i.test(navigator.vendor);
}
function isFirefox() {
  return _726BNPQZcjs.canUseDOM && /firefox\//i.test(navigator.userAgent);
}
function isMac() {
  return _726BNPQZcjs.canUseDOM && navigator.platform.startsWith("Mac") && !isTouchDevice();
}







exports.isTouchDevice = isTouchDevice; exports.isApple = isApple; exports.isSafari = isSafari; exports.isFirefox = isFirefox; exports.isMac = isMac;
