"use strict";Object.defineProperty(exports, "__esModule", {value: true});







var _ASR6PAFNcjs = require('./ASR6PAFN.cjs');


var _MLCPLY2Pcjs = require('./MLCPLY2P.cjs');



var _7EQBAZ46cjs = require('./7EQBAZ46.cjs');

// src/disclosure/disclosure-store.ts
function createDisclosureStore(props = {}) {
  const store = _ASR6PAFNcjs.mergeStore.call(void 0, 
    props.store,
    _ASR6PAFNcjs.omit.call(void 0, props.disclosure, ["contentElement", "disclosureElement"])
  );
  _ASR6PAFNcjs.throwOnConflictingProps.call(void 0, props, store);
  const syncState = store == null ? void 0 : store.getState();
  const open = _MLCPLY2Pcjs.defaultValue.call(void 0, 
    props.open,
    syncState == null ? void 0 : syncState.open,
    props.defaultOpen,
    false
  );
  const animated = _MLCPLY2Pcjs.defaultValue.call(void 0, props.animated, syncState == null ? void 0 : syncState.animated, false);
  const initialState = {
    open,
    animated,
    animating: !!animated && open,
    mounted: open,
    contentElement: _MLCPLY2Pcjs.defaultValue.call(void 0, syncState == null ? void 0 : syncState.contentElement, null),
    disclosureElement: _MLCPLY2Pcjs.defaultValue.call(void 0, syncState == null ? void 0 : syncState.disclosureElement, null)
  };
  const disclosure = _ASR6PAFNcjs.createStore.call(void 0, initialState, store);
  _ASR6PAFNcjs.setup.call(void 0, 
    disclosure,
    () => _ASR6PAFNcjs.sync.call(void 0, disclosure, ["animated", "animating"], (state) => {
      if (state.animated) return;
      disclosure.setState("animating", false);
    })
  );
  _ASR6PAFNcjs.setup.call(void 0, 
    disclosure,
    () => _ASR6PAFNcjs.subscribe.call(void 0, disclosure, ["open"], () => {
      if (!disclosure.getState().animated) return;
      disclosure.setState("animating", true);
    })
  );
  _ASR6PAFNcjs.setup.call(void 0, 
    disclosure,
    () => _ASR6PAFNcjs.sync.call(void 0, disclosure, ["open", "animating"], (state) => {
      disclosure.setState("mounted", state.open || state.animating);
    })
  );
  return _7EQBAZ46cjs.__spreadProps.call(void 0, _7EQBAZ46cjs.__spreadValues.call(void 0, {}, disclosure), {
    disclosure: props.disclosure,
    setOpen: (value) => disclosure.setState("open", value),
    show: () => disclosure.setState("open", true),
    hide: () => disclosure.setState("open", false),
    toggle: () => disclosure.setState("open", (open2) => !open2),
    stopAnimation: () => disclosure.setState("animating", false),
    setContentElement: (value) => disclosure.setState("contentElement", value),
    setDisclosureElement: (value) => disclosure.setState("disclosureElement", value)
  });
}



exports.createDisclosureStore = createDisclosureStore;
