# Changelog

All notable changes to this project will be documented in this file. See [standard-version](https://github.com/conventional-changelog/standard-version) for commit guidelines.

## [3.21.0](https://github.com/standardnotes/app/compare/v3.20.3...v3.21.0) (2022-06-13)


### Features

* ability to cancel multiple selection from UI ([#1045](https://github.com/standardnotes/app/issues/1045)) ([8877c42](https://github.com/standardnotes/app/commit/8877c42079e0b78fe44a087453b810d2724adecb))
* add "Listed actions" option in note context menu ([#891](https://github.com/standardnotes/app/issues/891)) ([209bd99](https://github.com/standardnotes/app/commit/209bd99fe520250dae30114a9f8e9070bec62e4a))
* add account switcher menu ([#941](https://github.com/standardnotes/app/issues/941)) ([a764987](https://github.com/standardnotes/app/commit/a764987b20a06fe6353d621f89068f5c0c67dee1))
* add change editor button ([#874](https://github.com/standardnotes/app/issues/874)) ([1983b94](https://github.com/standardnotes/app/commit/1983b94a4922a07ffca7366c3df2e0c89a5bdb4f))
* add check since ICONS wont have all IconType ([#843](https://github.com/standardnotes/app/issues/843)) ([1dc1b1e](https://github.com/standardnotes/app/commit/1dc1b1ea1f630b0bda2cde26a1683401cb5ff2ec))
* add delete option to file menu ([#936](https://github.com/standardnotes/app/issues/936)) ([105c0cd](https://github.com/standardnotes/app/commit/105c0cdce94ac6ffe41a4df90952dbe3535fbe1f))
* add desktop repo ([#1071](https://github.com/standardnotes/app/issues/1071)) ([0b7ce82](https://github.com/standardnotes/app/commit/0b7ce82aaa21018da084149bb52b5c90b2273bc8))
* add file information panel to file preview modal ([#965](https://github.com/standardnotes/app/issues/965)) ([3126d97](https://github.com/standardnotes/app/commit/3126d97dcab9b3ab33011c29521916259383fab9))
* add file preview modal ([#945](https://github.com/standardnotes/app/issues/945)) ([12e3bb0](https://github.com/standardnotes/app/commit/12e3bb095982bdad308f75feca24e27aa44a1722))
* add file view ([#1064](https://github.com/standardnotes/app/issues/1064)) ([92024ec](https://github.com/standardnotes/app/commit/92024ec7cab69a49a1bdf081c2e74afd5056e679))
* add files button to multiple selection view ([#1067](https://github.com/standardnotes/app/issues/1067)) ([218e7a3](https://github.com/standardnotes/app/commit/218e7a3d069e037005837f63e2f504900ea35c8e))
* add files popover in note toolbar ([#913](https://github.com/standardnotes/app/issues/913)) ([b31afee](https://github.com/standardnotes/app/commit/b31afee10819a6beffd060039eb559ee09895c16))
* add icon to listed group header ([#895](https://github.com/standardnotes/app/issues/895)) ([3e14a77](https://github.com/standardnotes/app/commit/3e14a77d62fc390bb87c6164770c2ee2c2639d4c))
* add image zoom options ([#984](https://github.com/standardnotes/app/issues/984)) ([a78c0ce](https://github.com/standardnotes/app/commit/a78c0ce2a12e093b1cecbd2f4d69651e301df823))
* add Labs pane to preferences ([#892](https://github.com/standardnotes/app/issues/892)) ([ab6e5ac](https://github.com/standardnotes/app/commit/ab6e5ac367c248e6e89474c4f96f19ade0494602))
* add migration pref pane ([#825](https://github.com/standardnotes/app/issues/825)) ([3c0bc79](https://github.com/standardnotes/app/commit/3c0bc79768e355335896033268ba4bb5ff1d189f))
* Add new "Change Editor" option to note context menu ([#823](https://github.com/standardnotes/app/issues/823)) ([b932e2a](https://github.com/standardnotes/app/commit/b932e2a45e2eeb789fb03a53b3d5b0d2ad1e9ec4))
* add tag context menu ([#890](https://github.com/standardnotes/app/issues/890)) ([22718d8](https://github.com/standardnotes/app/commit/22718d8a9f5d54739c172238623629202a130da8))
* add themes source ([#1089](https://github.com/standardnotes/app/issues/1089)) ([e80eb44](https://github.com/standardnotes/app/commit/e80eb441a717b7c892307635ff3af4db2e25d57c))
* add toast notifications using stylekit ([#905](https://github.com/standardnotes/app/issues/905)) ([c5eb84d](https://github.com/standardnotes/app/commit/c5eb84d7e8eb1cd1d05d37e98c7118d8d5c6d6ff))
* add warning to note options menu if note size is >0.5mb ([#851](https://github.com/standardnotes/app/issues/851)) ([5605bae](https://github.com/standardnotes/app/commit/5605baeb57742f356d77c8592fe28d80057efaff))
* add workspace switcher to lock screen ([#969](https://github.com/standardnotes/app/issues/969)) ([9ba7b87](https://github.com/standardnotes/app/commit/9ba7b875a87f15dedd528a68848bcd311466c3da))
* ask for password before previewing protected files ([#991](https://github.com/standardnotes/app/issues/991)) ([eacfa80](https://github.com/standardnotes/app/commit/eacfa80dbab125a57fb870393f5b2ff9dad8af75))
* autoplay videos when previewing ([#1036](https://github.com/standardnotes/app/issues/1036)) ([ce39fe5](https://github.com/standardnotes/app/commit/ce39fe55db77e1c4c2450d77bb0af7b2aa373ca5))
* better decryption attempt; upgrade snjs with file size changes ([d33e48e](https://github.com/standardnotes/app/commit/d33e48edd884568dc4827456ae811ad1478f8554))
* check for files beta role ([#986](https://github.com/standardnotes/app/issues/986)) ([925504d](https://github.com/standardnotes/app/commit/925504de320162cf72228f19243382f6b2501ba8))
* close change editor menu once editor is selected ([#907](https://github.com/standardnotes/app/issues/907)) ([c150cd6](https://github.com/standardnotes/app/commit/c150cd6867af87a6aa82cfaae809214cae57ad44))
* close submenu if another submenu is opened ([#911](https://github.com/standardnotes/app/issues/911)) ([08fb913](https://github.com/standardnotes/app/commit/08fb913b0e1d1b23b2eb83100c8c08aea44f3fd4))
* demo token ([67e0bf0](https://github.com/standardnotes/app/commit/67e0bf0ccfeebf872040689bfa1141be8fb79927))
* desktop compatibility, beta 1 ([0f01d29](https://github.com/standardnotes/app/commit/0f01d296e47cfb8abb46a8d175311b7fe0e46f96))
* disable autocomplete for search input ([#919](https://github.com/standardnotes/app/issues/919)) ([7720793](https://github.com/standardnotes/app/commit/772079338fb42721f2468a2c0ac0057b1de9e14b))
* disable note title input autocomplete ([#963](https://github.com/standardnotes/app/issues/963)) ([d1df913](https://github.com/standardnotes/app/commit/d1df913578815b533cfa08aa05fce1d6fabbff30))
* display files quota in preferences ([#994](https://github.com/standardnotes/app/issues/994)) ([68ad0f1](https://github.com/standardnotes/app/commit/68ad0f17ae1a6e5f52fbe847e3c8db3557a8ac49))
* display folders even without the premium ([#826](https://github.com/standardnotes/app/issues/826)) ([7726b12](https://github.com/standardnotes/app/commit/7726b1249c3eef7aedb4e31955775902111e2ed3))
* drag file on tab button to switch to that tab ([#1013](https://github.com/standardnotes/app/issues/1013)) ([c981cdc](https://github.com/standardnotes/app/commit/c981cdced4e55cee806e32a17d3963df2696a1d1))
* enable email backups for everyone ([58b6389](https://github.com/standardnotes/app/commit/58b63898de716c52bfec3af96025b61f9d4d6691))
* enable folders by default and remove from experimental features ([70f4dd6](https://github.com/standardnotes/app/commit/70f4dd63532276bba41eaa1ec9d2552a74de8722))
* error decrypting preferences section ([#990](https://github.com/standardnotes/app/issues/990)) ([fdf290e](https://github.com/standardnotes/app/commit/fdf290ea1a9cf8f712e84c15d03446b56a992f08))
* export as zip if multiple notes are selected ([#926](https://github.com/standardnotes/app/issues/926)) ([a2a4b6b](https://github.com/standardnotes/app/commit/a2a4b6b180284c2062b18d7b6b4d07cf9133ae14))
* file backups ([#1024](https://github.com/standardnotes/app/issues/1024)) ([942226e](https://github.com/standardnotes/app/commit/942226e15a5676ec4dd127e2e67e3b89ab159530))
* files related improvements ([d7ba393](https://github.com/standardnotes/app/commit/d7ba3935edd97f8f6cf52d02916220f429e4daac))
* generic items list ([#1035](https://github.com/standardnotes/app/issues/1035)) ([6401da2](https://github.com/standardnotes/app/commit/6401da2570d4a54fd77ca449629e6e023afd8f85))
* get editor icons and their colors from snjs ([#828](https://github.com/standardnotes/app/issues/828)) ([bf382ce](https://github.com/standardnotes/app/commit/bf382ce0f858ad6d34fa48dcbbf77f22f0d1e255))
* handle removed grey-x colors from stylekit ([#1046](https://github.com/standardnotes/app/issues/1046)) ([c6839f7](https://github.com/standardnotes/app/commit/c6839f776a447568040c58a83c220406c34efc3f))
* hide some prefs if not logged in ([#979](https://github.com/standardnotes/app/issues/979)) ([9dafdee](https://github.com/standardnotes/app/commit/9dafdeeddb0159bd09fa9829e060231383385fe7))
* import svg files from stylekit ([#844](https://github.com/standardnotes/app/issues/844)) ([00d57aa](https://github.com/standardnotes/app/commit/00d57aa69ddf646326418a9c3408e2aed0624afb))
* improve change editor menu keyboard navigation ([#831](https://github.com/standardnotes/app/issues/831)) ([0ecbde6](https://github.com/standardnotes/app/commit/0ecbde6bac0c93ef232fea9c9f7fcad037d739f1))
* improve preference copy and case consistency ([03f707e](https://github.com/standardnotes/app/commit/03f707ee63f0c5bd0c8240011efcce0794eeb851))
* initially focus "create account" if no account ([#944](https://github.com/standardnotes/app/issues/944)) ([8715a8b](https://github.com/standardnotes/app/commit/8715a8b8f489154a2108bbd9e8f773eb35773ea0))
* listen to file dnd event on window instead of just popover ([#921](https://github.com/standardnotes/app/issues/921)) ([5b42eed](https://github.com/standardnotes/app/commit/5b42eedd978e0de6be51fae7889a85e6b4eda7c9))
* make listed menu sorting consistent ([#896](https://github.com/standardnotes/app/issues/896)) ([f9fafec](https://github.com/standardnotes/app/commit/f9fafec11a9e2f32b25b144d220dd79e21315c34))
* make whole menu switch be clickable ([#837](https://github.com/standardnotes/app/issues/837)) ([7c41cfc](https://github.com/standardnotes/app/commit/7c41cfc3dcc55626db840ec472a6aadb5392150b))
* mobile app package ([#1075](https://github.com/standardnotes/app/issues/1075)) ([8248a38](https://github.com/standardnotes/app/commit/8248a38280cb7c92da2b2e9c7db298f34ae8ffdf))
* move change editor up in menu ([#847](https://github.com/standardnotes/app/issues/847)) ([3fb2732](https://github.com/standardnotes/app/commit/3fb27326fa4ab93aa3c0bad140ad007cfbfd59b5))
* move SubscriptionState to central AppState ([#869](https://github.com/standardnotes/app/issues/869)) ([dab8080](https://github.com/standardnotes/app/commit/dab8080da67b1ee19263987a0ae0d58efe57d171))
* multiple files selected view ([#1062](https://github.com/standardnotes/app/issues/1062)) ([4caf958](https://github.com/standardnotes/app/commit/4caf9586598a5bb090b52716f45e7a20b5e570c4))
* native listed integration ([#846](https://github.com/standardnotes/app/issues/846)) ([6970a37](https://github.com/standardnotes/app/commit/6970a375b7eb31901edbcd3bcc19e6394028c24c))
* new lock screen and challenge modal design ([#957](https://github.com/standardnotes/app/issues/957)) ([c16f23a](https://github.com/standardnotes/app/commit/c16f23a75fa82949fd87d2939cd2524e97259dc3))
* new revision history UI ([#861](https://github.com/standardnotes/app/issues/861)) ([71c7ee1](https://github.com/standardnotes/app/commit/71c7ee1bec2bdff18f81fe9004c4ae64d7283ca1))
* note types ([f5a9006](https://github.com/standardnotes/app/commit/f5a90060ea75e262a1fd59289a9c4644f2692b2f))
* only fetch files quota when prefs are opened ([#999](https://github.com/standardnotes/app/issues/999)) ([50d047a](https://github.com/standardnotes/app/commit/50d047a90334d35f3d69ef78c3a5cdb0a51a5753))
* option to sign out all workspaces ([#1005](https://github.com/standardnotes/app/issues/1005)) ([bce8c5f](https://github.com/standardnotes/app/commit/bce8c5fcbaeb195e1f2579f6640d10401ffc5529))
* option to toggle adding note to all parent folders ([#937](https://github.com/standardnotes/app/issues/937)) ([bd9a6e2](https://github.com/standardnotes/app/commit/bd9a6e2ae5078dc8bbe199ba846cae509111de25))
* persist tags expanded state ([0c3d1fc](https://github.com/standardnotes/app/commit/0c3d1fce0caf969b4105ad342644e71ca1e6f23c))
* preview improvements ([#989](https://github.com/standardnotes/app/issues/989)) ([1391f88](https://github.com/standardnotes/app/commit/1391f882636635b57254e1ab09cf0573234cc9e1))
* preview next/prev files using arrow keys ([#1004](https://github.com/standardnotes/app/issues/1004)) ([96be0d5](https://github.com/standardnotes/app/commit/96be0d578d4233f0919020f0847a4203ab66e697))
* privacy prefs ([#935](https://github.com/standardnotes/app/issues/935)) ([fb9bd37](https://github.com/standardnotes/app/commit/fb9bd37d72ddd87d5d4dd88eebb16217a929c3e0))
* redesign search filtering experience ([#908](https://github.com/standardnotes/app/issues/908)) ([5d49352](https://github.com/standardnotes/app/commit/5d49352f938dbd5001460103fa0eabb9936909b6))
* redirect subscribers to dashboard instead of plans page ([#897](https://github.com/standardnotes/app/issues/897)) ([7fe0873](https://github.com/standardnotes/app/commit/7fe0873bbb570e2557a505175d9a3cb3dcdfb24a))
* remove bugsnag ([#931](https://github.com/standardnotes/app/issues/931)) ([bcfb22f](https://github.com/standardnotes/app/commit/bcfb22fef650feaa1ac3f545166f0d1d41cc5427))
* remove privacy prefs from unfinished features ([e83b183](https://github.com/standardnotes/app/commit/e83b183f78d9f620198c4da1bbb45ff1ce0bab46))
* remove unfinished flag for private workspaces ([f623afe](https://github.com/standardnotes/app/commit/f623afeed8528cbdb7e4bdcee73ed284380dcbb1))
* remove vertical padding from change editor menu ([#836](https://github.com/standardnotes/app/issues/836)) ([c1f1aa4](https://github.com/standardnotes/app/commit/c1f1aa4c8d6dbf7dd3f435198e6bc52b7397417a))
* replace accordion in change editor menu with regular menu ([#871](https://github.com/standardnotes/app/issues/871)) ([cc2bc1e](https://github.com/standardnotes/app/commit/cc2bc1e21c971b6907090ae50eb04a291d8d22fe))
* replace IonIcons with svg icons ([#1069](https://github.com/standardnotes/app/issues/1069)) ([4c65784](https://github.com/standardnotes/app/commit/4c65784421bebf1cd508a516452c43681c083845))
* show alert if file exceeds classic reader limit ([#948](https://github.com/standardnotes/app/issues/948)) ([97f14e2](https://github.com/standardnotes/app/commit/97f14e2a95d24ba84d26ae9ca70933414e84cd1e))
* show alert when changing to non-interchangeable editor ([#834](https://github.com/standardnotes/app/issues/834)) ([6150f58](https://github.com/standardnotes/app/commit/6150f58c73b3c26eba327f324eb8557b3796b75d))
* show all themes and premium icon if not entitled ([#854](https://github.com/standardnotes/app/issues/854)) ([139853a](https://github.com/standardnotes/app/commit/139853a491c30dd2190d1e23950fc3b308d4bc11))
* show download progress in file preview modal ([#1011](https://github.com/standardnotes/app/issues/1011)) ([2c807e2](https://github.com/standardnotes/app/commit/2c807e2b8022e9b117d4bb8634dfb76767d16d20))
* show download/upload progess in toast ([#1008](https://github.com/standardnotes/app/issues/1008)) ([e4fbb25](https://github.com/standardnotes/app/commit/e4fbb2515e323779e9be8fa1a609e9ebe7021c3c))
* show sign-in/sign-up errors under input instead of alert ([#904](https://github.com/standardnotes/app/issues/904)) ([6311c68](https://github.com/standardnotes/app/commit/6311c687127cb0e19935bbf76e69e18a6e3c2a11))
* show toast before applying system color scheme ([#964](https://github.com/standardnotes/app/issues/964)) ([ff4debf](https://github.com/standardnotes/app/commit/ff4debfeb8d8b60cb132d8eccb4cf385a527b001))
* snjs with auto integrity resolution ([#912](https://github.com/standardnotes/app/issues/912)) ([ae5b182](https://github.com/standardnotes/app/commit/ae5b182ac1afae040ba2dad119fe51c7336c7733))
* sort files by name ([#1001](https://github.com/standardnotes/app/issues/1001)) ([99d83af](https://github.com/standardnotes/app/commit/99d83af3ba8d1bbe88dfed9027defb77ea0fe923))
* sort note cell tags alphabetically ([#848](https://github.com/standardnotes/app/issues/848)) ([cc21691](https://github.com/standardnotes/app/commit/cc2169152eeb151c4b256ea944c567af8bdb2846))
* styles package ([#1074](https://github.com/standardnotes/app/issues/1074)) ([3100327](https://github.com/standardnotes/app/commit/31003276b73d3e89824bc002fe616fa055e918c4))
* switch to notes view when creating new note ([#1058](https://github.com/standardnotes/app/issues/1058)) ([4aacdda](https://github.com/standardnotes/app/commit/4aacdda51c5489ccf003c2a4c6480b052895f06d))
* toast package ([#1073](https://github.com/standardnotes/app/issues/1073)) ([6d0b6e9](https://github.com/standardnotes/app/commit/6d0b6e9018b2a612b8df4827336883fe04033128))
* untagged notes smart view ([60bddd0](https://github.com/standardnotes/app/commit/60bddd0f4159a1aa30ce74db462c6c0315e55674))
* update line height and width of note size warning text ([#852](https://github.com/standardnotes/app/issues/852)) ([7f5f0d9](https://github.com/standardnotes/app/commit/7f5f0d9d17922a4b403a0a400cdccc3e9ab1cb42))
* update note type menu design ([#1032](https://github.com/standardnotes/app/issues/1032)) ([9524a83](https://github.com/standardnotes/app/commit/9524a83ec32bc630b03034d9b88ffa8b6513a478))
* updated "note editing disabled" design ([#1033](https://github.com/standardnotes/app/issues/1033)) ([cb6a81a](https://github.com/standardnotes/app/commit/cb6a81afd670e4f9d44e7f8727ea0eea602f7243))
* upload prompt on add button click in FilesView ([#1053](https://github.com/standardnotes/app/issues/1053)) ([501da8e](https://github.com/standardnotes/app/commit/501da8ecc675e4720d5def57d04ae91c50173778))
* use improved style calculation for change editor submenu ([#899](https://github.com/standardnotes/app/issues/899)) ([4db8ca8](https://github.com/standardnotes/app/commit/4db8ca8bddbf19cac0d099b6f1f3e4552d9b63ca))
* use new zip.js module for backup ([#929](https://github.com/standardnotes/app/issues/929)) ([66c9b26](https://github.com/standardnotes/app/commit/66c9b26962aabba69a49a4e1d9e6e2536bc0537c))
* use tint color for pref section headers ([754a189](https://github.com/standardnotes/app/commit/754a1895320fddf1b4f559f2a580a6a023bd84ac))
* vaults ([#927](https://github.com/standardnotes/app/issues/927)) ([57469d6](https://github.com/standardnotes/app/commit/57469d6b2dba431d3d333b9f3047d03d45a8d519))
* wait 1ms before menu collision detection ([#859](https://github.com/standardnotes/app/issues/859)) ([9c046a3](https://github.com/standardnotes/app/commit/9c046a389059ead66a3f207c35e482c297b4f1fc))
* **wip:** components monorepo ([#1082](https://github.com/standardnotes/app/issues/1082)) ([e3d6001](https://github.com/standardnotes/app/commit/e3d6001a178e11e619ca724b2b155b7c0405c023))
* wrap search option bubbles if not enough space ([#918](https://github.com/standardnotes/app/issues/918)) ([be6a9fd](https://github.com/standardnotes/app/commit/be6a9fdb34f297891b98e6dbef19fc0b101009a9))


### Bug Fixes

* "file can't be previewed" flashing ([#993](https://github.com/standardnotes/app/issues/993)) ([b594aae](https://github.com/standardnotes/app/commit/b594aae8b97dd1a59ccebb997813e34582c09975))
* activate cached themes without entitlement check ([b8e242c](https://github.com/standardnotes/app/commit/b8e242cbee8a30318c5c3fddf5a29016dd72da9f))
* actually disable backup buttons if the user is not entitled ([#955](https://github.com/standardnotes/app/issues/955)) ([3ca7102](https://github.com/standardnotes/app/commit/3ca7102fd0c0d73567cd2afa86a00112dd0fd27f))
* allow experimental editors if component is installed regardless of feature state ([8db127b](https://github.com/standardnotes/app/commit/8db127b79813169ed85f55e3935293364fc0e301))
* allow users to disable any active cloud integration even if they are not entitled to cloud backups ([#870](https://github.com/standardnotes/app/issues/870)) ([80cc37f](https://github.com/standardnotes/app/commit/80cc37fbd437bca44a6a59dfee0115bf1eeaefbd))
* app column layout ([ed729ab](https://github.com/standardnotes/app/commit/ed729ab4ef243eb9bb191d148ec5d60fa34ccc77))
* apply active themes after features updated ([3d6c10b](https://github.com/standardnotes/app/commit/3d6c10b70eb56cc5ab0be4e0cc25a58d5b590da1))
* background color to use for selected note cell ([131f13c](https://github.com/standardnotes/app/commit/131f13c5580db2438df44f3442414b3052acc34c))
* callback methods ([18e68ad](https://github.com/standardnotes/app/commit/18e68adbb00e02afcd5e2013dff7dc15bf5f8d69))
* challenge modal button label ([#972](https://github.com/standardnotes/app/issues/972)) ([a91a1cb](https://github.com/standardnotes/app/commit/a91a1cbddd2c1f272d9127e75eafb1ab4b82de78))
* challenge modal styles ([#987](https://github.com/standardnotes/app/issues/987)) ([9f8c402](https://github.com/standardnotes/app/commit/9f8c402e1ad2189d4d1098e46e794a800c7e21ff))
* change editor menu position on large viewport ([#857](https://github.com/standardnotes/app/issues/857)) ([3b830b0](https://github.com/standardnotes/app/commit/3b830b00d904a697fa73920783913e1f0829c18c))
* change undefined css class ([94199fb](https://github.com/standardnotes/app/commit/94199fb6b53ba19e77b2b43f47d717898c085ba1))
* check if user is entitled to theme before activating it ([#867](https://github.com/standardnotes/app/issues/867)) ([ca3112d](https://github.com/standardnotes/app/commit/ca3112dcaff80efb41124fe0f64c796c3acb1c68))
* circular dependencies ([#1040](https://github.com/standardnotes/app/issues/1040)) ([0e25885](https://github.com/standardnotes/app/commit/0e258856d80f5b8899bf655621b95a3bf95156fe))
* correctly check if cloud backups are available for the user ([#845](https://github.com/standardnotes/app/issues/845)) ([8388265](https://github.com/standardnotes/app/commit/8388265493b4b6bb59af3aca0eb5bb912ada8e46))
* deactivate themes when switching accounts ([d920bf6](https://github.com/standardnotes/app/commit/d920bf663f0322932582613352c1810c7e3f6119))
* decorated input text color ([#968](https://github.com/standardnotes/app/issues/968)) ([369ece1](https://github.com/standardnotes/app/commit/369ece1a505e1f81022efb9b504a18ad532a4cc4))
* desktop ([#1080](https://github.com/standardnotes/app/issues/1080)) ([6801c3d](https://github.com/standardnotes/app/commit/6801c3dd3b931d9bfa3987c7867282da63c65266))
* destroy editor component on show protected overlay ([0729aa6](https://github.com/standardnotes/app/commit/0729aa692635fd30f7e8b8ab11c851064c204075))
* dimmed banner colors ([#1043](https://github.com/standardnotes/app/issues/1043)) ([4e621ca](https://github.com/standardnotes/app/commit/4e621cadde07f6e1cefa82a6030beb7fc3d570cf))
* dimmed tags issue on safari + increase tag density ([072af12](https://github.com/standardnotes/app/commit/072af12ffec2050f29ee7c49b3786730ef1a81a3))
* display full tag path in add tags menu ([453488f](https://github.com/standardnotes/app/commit/453488f752c10d5d3462dd2083e93ca237cc2dad))
* do not deactivate all themes on theme service deinit; themes should remain activated on application lock ([f9c47a1](https://github.com/standardnotes/app/commit/f9c47a10cae64cbf7b8d71d171a16d3489859f9d))
* dom nesting error ([#1066](https://github.com/standardnotes/app/issues/1066)) ([59dcca1](https://github.com/standardnotes/app/commit/59dcca18d63f4bf346fca27e87b84ef1cc0a29cb))
* don't apply system color scheme anytime any preference changes ([4923577](https://github.com/standardnotes/app/commit/492357777c23aea2538804fe2785352c2933f463))
* don't close popover when previewing file ([#1017](https://github.com/standardnotes/app/issues/1017)) ([f35a454](https://github.com/standardnotes/app/commit/f35a454614cd4e5f4bb970e57850e3d28be96405))
* don't deselect active note if in user created view ([#1081](https://github.com/standardnotes/app/issues/1081)) ([2ecfcde](https://github.com/standardnotes/app/commit/2ecfcdecb4a0af20003e4b5c4e0544448f680633))
* don't get backups settings if there is no logged-in user ([#842](https://github.com/standardnotes/app/issues/842)) ([616b77a](https://github.com/standardnotes/app/commit/616b77a5f748b7d19eadc8e1660afa9a7de4fd17))
* don't show entitlement modal if dragging file backup ([d47d295](https://github.com/standardnotes/app/commit/d47d2952984f898664ff78e9c6a85b73c41a5dcc))
* download success toast showing up even if download errors ([#1018](https://github.com/standardnotes/app/issues/1018)) ([9e370df](https://github.com/standardnotes/app/commit/9e370df2e83a9ac095eaed0b4e03662bf1b98fde))
* dropdown and files button ui ([#1076](https://github.com/standardnotes/app/issues/1076)) ([12f052a](https://github.com/standardnotes/app/commit/12f052a0b202df10ea55351ea4bf6232c2ecb56f))
* duplicate element id ([b1022cd](https://github.com/standardnotes/app/commit/b1022cd3c34fc35b07f5d6dfc03efff1e860ed79))
* duplicate files quota calls in preferences ([#1006](https://github.com/standardnotes/app/issues/1006)) ([e7fb9b6](https://github.com/standardnotes/app/commit/e7fb9b67f87f94e08e279db11f920d5ae51a2030))
* early return file dnd if not dragging files ([#1000](https://github.com/standardnotes/app/issues/1000)) ([63fcd3d](https://github.com/standardnotes/app/commit/63fcd3d217bf2e09a44fed424cc2f8f3b1acfdf5))
* encryption section styles ([#976](https://github.com/standardnotes/app/issues/976)) ([ec8b307](https://github.com/standardnotes/app/commit/ec8b3072353008f13b51deb77e3346a5b685578c))
* error on aborting file selection ([#951](https://github.com/standardnotes/app/issues/951)) ([9c74364](https://github.com/standardnotes/app/commit/9c74364757a6abe7712cfc36fb04af38cc2a038a))
* exception when selected note is deleted permanently ([#1010](https://github.com/standardnotes/app/issues/1010)) ([bb4fd24](https://github.com/standardnotes/app/commit/bb4fd2449af61f161683afa0af5d0c3ae178f0a1))
* experimental features not reloading after toggling ([#917](https://github.com/standardnotes/app/issues/917)) ([87631dc](https://github.com/standardnotes/app/commit/87631dcb0dea716540649c05103a29049e98c719))
* export location of ElectronDesktopCallbacks ([fc3d575](https://github.com/standardnotes/app/commit/fc3d575fe0777d2f86bcdf6195784045a98a9748))
* failing deploy by removing vendor step ([#930](https://github.com/standardnotes/app/issues/930)) ([bd6a883](https://github.com/standardnotes/app/commit/bd6a8836798648a330636809890e73fd2b4f3816))
* feature id reference ([af69a02](https://github.com/standardnotes/app/commit/af69a02555f4c2f0f8102a3a255e45a07e01d884))
* file backups drag ([ed5f649](https://github.com/standardnotes/app/commit/ed5f6495aaa841744cbfb70a2f644c77c545e93e))
* file drag-n-drop issue ([#923](https://github.com/standardnotes/app/issues/923)) ([7e67061](https://github.com/standardnotes/app/commit/7e6706109723d3524eb6a8f9b42553776b44fac6))
* file list item icon alignment ([#1039](https://github.com/standardnotes/app/issues/1039)) ([51248f2](https://github.com/standardnotes/app/commit/51248f2588ca311ffcba1a91dc90bbbd531dc73a))
* file mimeType related issues ([#922](https://github.com/standardnotes/app/issues/922)) ([a1c7ad7](https://github.com/standardnotes/app/commit/a1c7ad7d7e16a8cb35f72411e598400cf8f4b616))
* file popover not closing when click inside editor ([#924](https://github.com/standardnotes/app/issues/924)) ([89c4b9a](https://github.com/standardnotes/app/commit/89c4b9a9f8d119ef4b9d033a0ca681e2edee068e))
* files navigation ([#1084](https://github.com/standardnotes/app/issues/1084)) ([5d09057](https://github.com/standardnotes/app/commit/5d090572fe511d008f8b2f9686de5a18db678532))
* files popover illustration size ([#928](https://github.com/standardnotes/app/issues/928)) ([8caf343](https://github.com/standardnotes/app/commit/8caf3431761790106897e062e0a4d6dc7e185ecb))
* first history entry being fetched twice ([#903](https://github.com/standardnotes/app/issues/903)) ([c184ef2](https://github.com/standardnotes/app/commit/c184ef2449044982ff27f162807f916fd16cce4a))
* focus trap error ([#974](https://github.com/standardnotes/app/issues/974)) ([c2edeb4](https://github.com/standardnotes/app/commit/c2edeb47e14d970fff9087d852fb1c19dc076d59))
* folders migration issue ([d17edfc](https://github.com/standardnotes/app/commit/d17edfc5cff79deadc0aef8e4b64d5e6d79db0e6))
* function binding ([cf1720b](https://github.com/standardnotes/app/commit/cf1720ba202fb6609241666bba2de4453464dbe8))
* handle undefined desktop service when running in web environment ([e8ed38b](https://github.com/standardnotes/app/commit/e8ed38bcb2d4d76d5f94e97af7cc5fbddaccab00))
* handle undefined env value ([ef8fc83](https://github.com/standardnotes/app/commit/ef8fc83e3691cf73f8c5a79d489863e381bd24bb))
* header button border ([#887](https://github.com/standardnotes/app/issues/887)) ([96bfd6e](https://github.com/standardnotes/app/commit/96bfd6efc2119b15195e130162c8dc783a5f9582))
* icons package ([4df06c1](https://github.com/standardnotes/app/commit/4df06c1d1a59f95ce735f87c106066ea28e5816c))
* image zoom over 100% ([#998](https://github.com/standardnotes/app/issues/998)) ([d0d97a8](https://github.com/standardnotes/app/commit/d0d97a8dbcdcff443786bb90bd77becb55155c39))
* image zoom scroll ([#1038](https://github.com/standardnotes/app/issues/1038)) ([509bd50](https://github.com/standardnotes/app/commit/509bd506b5756f5a1bae6acb60bae6e4e2b33fac))
* import ([e1da2be](https://github.com/standardnotes/app/commit/e1da2be83571fe92ef4fc91beed3df661ca1c171))
* improve deinit logic and flow ([e43c8a6](https://github.com/standardnotes/app/commit/e43c8a6f07b778491b6ab9707be126914504c109))
* increase tag menu item margin ([cc28306](https://github.com/standardnotes/app/commit/cc283061c940c0576e09baa05a634ce01f4dbf3f))
* insert template note before opening editor menu ([#838](https://github.com/standardnotes/app/issues/838)) ([ebd8848](https://github.com/standardnotes/app/commit/ebd8848b5ab4da77d77ce6aa9728de374365dac8))
* issue with some smart views not working ([89de4d6](https://github.com/standardnotes/app/commit/89de4d64888abdcc76fdc56bd0e4f0b200cb489d))
* legacy history ([#879](https://github.com/standardnotes/app/issues/879)) ([fbabbbb](https://github.com/standardnotes/app/commit/fbabbbb7d37b6bf0472d529bb598db543b46257f))
* list tags key warning ([#1056](https://github.com/standardnotes/app/issues/1056)) ([ef7166c](https://github.com/standardnotes/app/commit/ef7166c3d2cfca99f1e6fe5168d494a9bd177030))
* locking message ([#1029](https://github.com/standardnotes/app/issues/1029)) ([27f864a](https://github.com/standardnotes/app/commit/27f864aa1d2877e4a4d5f8974085a8277a880d3b))
* main app container overflow ([a2d7752](https://github.com/standardnotes/app/commit/a2d775235eb64753d535217eb70014e20bc67720))
* make display options copy type-agnostic ([#1054](https://github.com/standardnotes/app/issues/1054)) ([cab2765](https://github.com/standardnotes/app/commit/cab27656ba9dadfb0322dc48f45d9d2d5863dda6))
* make file renaming consistent with tag & note renaming ([#920](https://github.com/standardnotes/app/issues/920)) ([fc2a350](https://github.com/standardnotes/app/commit/fc2a350cca8f17c24b6504305164b59ba0574e77))
* make search case-insensitive ([#925](https://github.com/standardnotes/app/issues/925)) ([6f41577](https://github.com/standardnotes/app/commit/6f41577ec91281ab0475c04d661735a605806ec8))
* markdown visual 1.0.2 ([f2e2ca6](https://github.com/standardnotes/app/commit/f2e2ca6451e43312663b9b21977c9b248b0712b0))
* meta tags ([4200baa](https://github.com/standardnotes/app/commit/4200baadba22f64282dcc8823305e84a188aeb62))
* minor files related fixes ([#1016](https://github.com/standardnotes/app/issues/1016)) ([8ca9e37](https://github.com/standardnotes/app/commit/8ca9e37ae1bc70f002c63d3f2a00bdcaa99ba5cb))
* modifier-only key observers not working ([#1009](https://github.com/standardnotes/app/issues/1009)) ([c7e849a](https://github.com/standardnotes/app/commit/c7e849ac9089442ca2ec3e1189d02331c7325e3a))
* move Labs behind unfinished features flag ([7e0e620](https://github.com/standardnotes/app/commit/7e0e620ab87568cde3ae3316bbc62625a7e355f6))
* note icons getting pushed by extra-long words ([#835](https://github.com/standardnotes/app/issues/835)) ([0e00901](https://github.com/standardnotes/app/commit/0e00901f1596454d94c4a3e9d3e2383a1b845d23))
* note list item border ([#862](https://github.com/standardnotes/app/issues/862)) ([03ba4af](https://github.com/standardnotes/app/commit/03ba4afd2e4eee0d70ed66593fcb34742d308a32))
* note tags list styling ([#1052](https://github.com/standardnotes/app/issues/1052)) ([7edd65c](https://github.com/standardnotes/app/commit/7edd65cfe83b9896d77283cabd9f149f147771b3))
* notes list item layout when title is empty ([#850](https://github.com/standardnotes/app/issues/850)) ([9932c2a](https://github.com/standardnotes/app/commit/9932c2a1776dc0209fc40cc3b500411178402fb5))
* Notes list options menu getting hidden ([#827](https://github.com/standardnotes/app/issues/827)) ([36584b0](https://github.com/standardnotes/app/commit/36584b07bd19886dc1e913a77c39d57e5c4246be))
* notes list options menu not toggling correctly ([#840](https://github.com/standardnotes/app/issues/840)) ([1f5d235](https://github.com/standardnotes/app/commit/1f5d235cd47deb85bd8a0912f316398de41ae68b))
* notes list options menu size regression ([#910](https://github.com/standardnotes/app/issues/910)) ([a17b7e7](https://github.com/standardnotes/app/commit/a17b7e7f461f1c080e2634459edfe2dfdc41ccba))
* notes options closing when selecting note id ([#888](https://github.com/standardnotes/app/issues/888)) ([a5da191](https://github.com/standardnotes/app/commit/a5da1910346abcca78bd6940f9290ca1af2bd68b))
* notes view not selected on launch issue ([57ec497](https://github.com/standardnotes/app/commit/57ec49733d265946637838155fe40b4b0f94fb2f))
* object url not being revoked on modal close ([#1044](https://github.com/standardnotes/app/issues/1044)) ([acdf442](https://github.com/standardnotes/app/commit/acdf442e61b56924e93ddbba868c5495f6641234))
* only show color scheme toast if change is required ([#973](https://github.com/standardnotes/app/issues/973)) ([4405f3b](https://github.com/standardnotes/app/commit/4405f3bbf21ae2c83115ad821f9c49edbc570886))
* options button text color ([#841](https://github.com/standardnotes/app/issues/841)) ([84cef22](https://github.com/standardnotes/app/commit/84cef22fbf5fb6af2c0f0140c84b822cdcc05eba))
* pinch zoom on preview modal ([#1012](https://github.com/standardnotes/app/issues/1012)) ([a3d5f57](https://github.com/standardnotes/app/commit/a3d5f57657ba85b0f1d5a54ed1c67dbcb5fe1efa))
* plain editor font changing ([#880](https://github.com/standardnotes/app/issues/880)) ([cd814bf](https://github.com/standardnotes/app/commit/cd814bf473f6536d23fb55ed06e9f7ff54fcb81a))
* plain editor revision rendering ([#889](https://github.com/standardnotes/app/issues/889)) ([538e41d](https://github.com/standardnotes/app/commit/538e41d1cb611f9e44f734ac07081d0c823a67d7))
* plain editor revision rendering and revision list sorting ([#878](https://github.com/standardnotes/app/issues/878)) ([1887d5d](https://github.com/standardnotes/app/commit/1887d5d01e8a96688a63ecc8d2cabd9c8c417579))
* popover closing on delete dialog ([#1022](https://github.com/standardnotes/app/issues/1022)) ([ada8d5a](https://github.com/standardnotes/app/commit/ada8d5ab80ca79f81e503f2cf3da98d3b319bcc5))
* popover closing when renaming file ([#950](https://github.com/standardnotes/app/issues/950)) ([1bdda36](https://github.com/standardnotes/app/commit/1bdda366d04bee25a8e428e2845a318975477a87))
* preferences pane order ([f6c9a9f](https://github.com/standardnotes/app/commit/f6c9a9f9adaea0e8c7680e9fdb4bea93bbea7176))
* prevent component viewer double reload ([a477281](https://github.com/standardnotes/app/commit/a47728188f4554f4ee722c44c243c1885b0554a9))
* prevent save status overflow from changing width of editor pane ([d12eebe](https://github.com/standardnotes/app/commit/d12eebe8837c3f130fa16f770fd4485bc9a51ca5))
* progress bar color on firefox ([#958](https://github.com/standardnotes/app/issues/958)) ([df54c37](https://github.com/standardnotes/app/commit/df54c3701c05e7e87da96ef76b65146a1d0c7240))
* react-related fixes ([#1050](https://github.com/standardnotes/app/issues/1050)) ([834459d](https://github.com/standardnotes/app/commit/834459d3a84dce6b64094bb4e4115bd882ea0932))
* remove max height on note options menu ([d3ef05d](https://github.com/standardnotes/app/commit/d3ef05d2d6187534c9541ca135860d290e0f3afb))
* render change editor menu only if it is open ([#894](https://github.com/standardnotes/app/issues/894)) ([0e2ea3a](https://github.com/standardnotes/app/commit/0e2ea3af749150f1997b52617996b7f6bf8170b4))
* render change editor menu only if it is open ([#894](https://github.com/standardnotes/app/issues/894)) ([5df3e59](https://github.com/standardnotes/app/commit/5df3e596045deeaeda51e996a74ef5a33d06ba54))
* render root element on dom load ([46ee84c](https://github.com/standardnotes/app/commit/46ee84ce24a4f407c8390dd7d26255b819dd0f13))
* revision content screen copy ([#876](https://github.com/standardnotes/app/issues/876)) ([723a70d](https://github.com/standardnotes/app/commit/723a70dd28f661fd54e6a0ef06aaca5fcd14db49))
* revision textarea background color ([#966](https://github.com/standardnotes/app/issues/966)) ([290c3ba](https://github.com/standardnotes/app/commit/290c3badd09872b7e8871b7504f3093a2853eeec))
* running tests and adding tests to CI & CD ([#1047](https://github.com/standardnotes/app/issues/1047)) ([2d3221c](https://github.com/standardnotes/app/commit/2d3221c944ca20543179257b4c77631c75ef0be7))
* sanitize alert string ([333d4c4](https://github.com/standardnotes/app/commit/333d4c4808081ebc7c0de350593a7f4e05904def))
* saving status while fully offline ([7abad65](https://github.com/standardnotes/app/commit/7abad65a510f76a33587ba93067c712954ed55ae))
* select home navigation view when creating note inside smart view ([#1059](https://github.com/standardnotes/app/issues/1059)) ([78f39ec](https://github.com/standardnotes/app/commit/78f39ec85db3d3c38e29e5f8a6d744398d285d6b))
* selected smart view and note list issue ([#1042](https://github.com/standardnotes/app/issues/1042)) ([599e2b8](https://github.com/standardnotes/app/commit/599e2b886e22a283529b17fc081e819390c3fd1d))
* sign out dialog disappearing when account menu is unfocused ([#863](https://github.com/standardnotes/app/issues/863)) ([0e1b94b](https://github.com/standardnotes/app/commit/0e1b94b5cdf67eb64a5841dcd4d1d83150b767a6))
* slightly increase tag display density ([dcf07f7](https://github.com/standardnotes/app/commit/dcf07f70fd824e7d3962908e0f1ce8a725bc73a1))
* snjs types ([aca5f41](https://github.com/standardnotes/app/commit/aca5f41e55741c4b030ffc5d919e29ac158c64fe))
* spellcheck control for 3rd-party editors ([#839](https://github.com/standardnotes/app/issues/839)) ([528bafd](https://github.com/standardnotes/app/commit/528bafde96b5bff6c50be8f8b56c764149b1c079))
* spinner loading infinitely on unsupported file types ([#1002](https://github.com/standardnotes/app/issues/1002)) ([93fbfff](https://github.com/standardnotes/app/commit/93fbfffbd24c7943b8beec53d91c89d69f333073))
* start command in docker entrypoint ([7073c2f](https://github.com/standardnotes/app/commit/7073c2f136b915f25d3b7ba3816c27bc98814c24))
* switching between previewable & non-previewable files ([#1021](https://github.com/standardnotes/app/issues/1021)) ([ae1097f](https://github.com/standardnotes/app/commit/ae1097f20771506f8539fc754009e49aa1e8661c))
* sync request before downloading/previewing file ([#1003](https://github.com/standardnotes/app/issues/1003)) ([9a99cc8](https://github.com/standardnotes/app/commit/9a99cc8df2d187ec7451b24c0ddd746008ea6952))
* tag context menu ([#893](https://github.com/standardnotes/app/issues/893)) ([68daa21](https://github.com/standardnotes/app/commit/68daa216aabc383932fe942fa64d7156e423afd6))
* tag context menu ([#893](https://github.com/standardnotes/app/issues/893)) ([5265a0d](https://github.com/standardnotes/app/commit/5265a0d01076c0661520cc11815fb8490ef6f9c8))
* tag drag-n-drop intercepted by files drag-n-drop ([#997](https://github.com/standardnotes/app/issues/997)) ([46582b2](https://github.com/standardnotes/app/commit/46582b2577b439e1d0d404fa9d2f865eb2ddaf6c))
* tag search causing regex exception ([#938](https://github.com/standardnotes/app/issues/938)) ([8265d94](https://github.com/standardnotes/app/commit/8265d94c86160dd0dfa6ffa29c9b20f5059016c5))
* theme entitlement logic ([0369d03](https://github.com/standardnotes/app/commit/0369d0354275915de5f97134d6e2ef046eded422))
* theme sorting in quick settings menu ([#882](https://github.com/standardnotes/app/issues/882)) ([a47556b](https://github.com/standardnotes/app/commit/a47556b8406d2956c839cc4882b0a44d69d3e66c))
* timed color scheme toast ([#978](https://github.com/standardnotes/app/issues/978)) ([a9bab09](https://github.com/standardnotes/app/commit/a9bab0938b4054accc6dff30ab49757c517c482e))
* title sorting ([65f2266](https://github.com/standardnotes/app/commit/65f22669f6e208cc9361d194f42e891c312a6342))
* toolbar change editor menu not updating ([#909](https://github.com/standardnotes/app/issues/909)) ([263640d](https://github.com/standardnotes/app/commit/263640d47628320c1ad1a3c5f27bba20ab31f135))
* unmount application view when ephemeral identifier changes ([b549cc3](https://github.com/standardnotes/app/commit/b549cc38bfb1da2927309e44161c08b7558eb48f))
* update filepicker to latest version ([c6ed953](https://github.com/standardnotes/app/commit/c6ed9534fb6be8ddc879d53138dc75b5f50e728e))
* updated "editing disabled" banner ([#1037](https://github.com/standardnotes/app/issues/1037)) ([079140e](https://github.com/standardnotes/app/commit/079140eb924aef83f1c8ec7dd7468009fa7ccad3))
* upgrade deps to introduce PKCE sign in ([9f11b02](https://github.com/standardnotes/app/commit/9f11b02e4aeeb20e91540a2ef26158ac7319e6ba))
* upgrade sncrypto-web for base64 url encode without padding ([e9aafbb](https://github.com/standardnotes/app/commit/e9aafbbe000dfc3e8f79f4a5d36ec805fa789b24))
* use break-word for note list item title; closes [#873](https://github.com/standardnotes/app/issues/873) ([#875](https://github.com/standardnotes/app/issues/875)) ([3373a47](https://github.com/standardnotes/app/commit/3373a47da41b9dd9c499277dbf206ebfeedebc4f))
* use component displayName property ([e52e2da](https://github.com/standardnotes/app/commit/e52e2daf39761c64c32658d7d4554436025febbf))
* use full path when searching autocomplete tags ([78ec092](https://github.com/standardnotes/app/commit/78ec092bf0fb8bef4139a5dce3ab1b64b8488ca1))
* video preview csp error ([#992](https://github.com/standardnotes/app/issues/992)) ([9b47f2e](https://github.com/standardnotes/app/commit/9b47f2e2352484adddbbd0bb68e4771cc91149d8))
* window property ([7f12f93](https://github.com/standardnotes/app/commit/7f12f9349a3cedbf7702875112179c2ad64d4deb))
* workspace signout all ([abe9b70](https://github.com/standardnotes/app/commit/abe9b70525825b9fc5df22ed2522b118c7e54b08))


### Reverts

* "fix: popover closing on delete dialog" ([#1030](https://github.com/standardnotes/app/issues/1030)) ([b3f6888](https://github.com/standardnotes/app/commit/b3f6888683f3d52d652a15857545545f10ae897e))

### 0.0.2 (2022-06-13)


### Features

* 'forgot passcode' on unlock priviledges modal ([6052392](https://github.com/standardnotes/app/commit/60523928339d3a2ed9ff0c495eb5fd06b658de5f))
* (wip) add error reporting ([0e9cdba](https://github.com/standardnotes/app/commit/0e9cdba215e611745dcf4f10ee63572c7af25430))
* (wip) authorize note access ([252183a](https://github.com/standardnotes/app/commit/252183a7c52bbf27886f17afa5a4b80c481db0ef))
* (wip) sessions management ([2c0f215](https://github.com/standardnotes/app/commit/2c0f215409a3b5f4d2001703b7c174e654829b73))
* ability to cancel multiple selection from UI ([#1045](https://github.com/standardnotes/app/issues/1045)) ([8877c42](https://github.com/standardnotes/app/commit/8877c42079e0b78fe44a087453b810d2724adecb))
* ability to uninstall any extension ([0413615](https://github.com/standardnotes/app/commit/04136159dcb19c09f83b2fbcfdec510863684278))
* add 'add tags' option to menu ([601ece8](https://github.com/standardnotes/app/commit/601ece8cbdec03d31f6a9c42d4ff8589c57142d2))
* Add "Appearance" pane to preferences ([#816](https://github.com/standardnotes/app/issues/816)) ([da1d4f7](https://github.com/standardnotes/app/commit/da1d4f75c8c3b44227b4959aaa91b4c526568c55))
* add "Email Backups" to "Backups" section ([#778](https://github.com/standardnotes/app/issues/778)) ([a342a3a](https://github.com/standardnotes/app/commit/a342a3a224cb0eedd6bef06ff01d9179431746e1))
* Add "Export" and "Duplicate" buttons in notes options menu. ([#688](https://github.com/standardnotes/app/issues/688)) ([3a4e250](https://github.com/standardnotes/app/commit/3a4e2509af94bdf02048a53ca5091d9f6a27ac03))
* add "Listed actions" option in note context menu ([#891](https://github.com/standardnotes/app/issues/891)) ([209bd99](https://github.com/standardnotes/app/commit/209bd99fe520250dae30114a9f8e9070bec62e4a))
* Add "Manage subscription" button to Subscription preferences ([#705](https://github.com/standardnotes/app/issues/705)) ([53ec0d4](https://github.com/standardnotes/app/commit/53ec0d47423f22eb28bf8c97cc34a6ca72e575fa))
* Add "Pin selected notes" button to editor title bar ([#760](https://github.com/standardnotes/app/issues/760)) ([31c48af](https://github.com/standardnotes/app/commit/31c48af01cbcd648cf467943cf01efe75d747df3))
* add "sync" pane to preferences -> account tab ([#621](https://github.com/standardnotes/app/issues/621)) ([5b18fc7](https://github.com/standardnotes/app/commit/5b18fc71465840b1f49d480391f27dca4423e56b))
* add account switcher menu ([#941](https://github.com/standardnotes/app/issues/941)) ([a764987](https://github.com/standardnotes/app/commit/a764987b20a06fe6353d621f89068f5c0c67dee1))
* add alternative server for purposes of switching to API v1 ([#571](https://github.com/standardnotes/app/issues/571)) ([8dde06b](https://github.com/standardnotes/app/commit/8dde06b93bfb08566c6637877ab0fa63a3211a2d))
* Add app version & server to account menu ([#682](https://github.com/standardnotes/app/issues/682)) ([3953713](https://github.com/standardnotes/app/commit/3953713f4533eaa5401d568c94dbc46188232a53))
* add arrow key navigation for results dropdown ([31d454c](https://github.com/standardnotes/app/commit/31d454cdc52468276e4538b6ff33c1acc79d539d))
* add autocomplete tags input and dropdown ([be6893b](https://github.com/standardnotes/app/commit/be6893b8dc7da0c932801a3e91f38c00a471aac3))
* add beta deployment ([b5d3c9c](https://github.com/standardnotes/app/commit/b5d3c9cd73548f8cf2d4a955306de6490c6d187f))
* add beta deployment on feature branches ([46e8348](https://github.com/standardnotes/app/commit/46e8348ea28dc6074ddeee779663a043a9bab294))
* add change editor button ([#874](https://github.com/standardnotes/app/issues/874)) ([1983b94](https://github.com/standardnotes/app/commit/1983b94a4922a07ffca7366c3df2e0c89a5bdb4f))
* add changing email ([#634](https://github.com/standardnotes/app/issues/634)) ([6afce84](https://github.com/standardnotes/app/commit/6afce84324cefe446521da09489b67b2c702de70))
* add check since ICONS wont have all IconType ([#843](https://github.com/standardnotes/app/issues/843)) ([1dc1b1e](https://github.com/standardnotes/app/commit/1dc1b1ea1f630b0bda2cde26a1683401cb5ff2ec))
* add configurable log level ([7375500](https://github.com/standardnotes/app/commit/737550096e88d68f700185b325278a7b02a9e7ee))
* add datadog integration and lograge JSON logs formatting ([c2ac21b](https://github.com/standardnotes/app/commit/c2ac21be9d0b7b1b7b0995d309eb34764261df24))
* add delete option to file menu ([#936](https://github.com/standardnotes/app/issues/936)) ([105c0cd](https://github.com/standardnotes/app/commit/105c0cdce94ac6ffe41a4df90952dbe3535fbe1f))
* add delete tag button and refactor NoteTag to separate component ([684a3fb](https://github.com/standardnotes/app/commit/684a3fb0bf4236c8ec556470216ed39d6fe7b187))
* add desktop repo ([#1071](https://github.com/standardnotes/app/issues/1071)) ([0b7ce82](https://github.com/standardnotes/app/commit/0b7ce82aaa21018da084149bb52b5c90b2273bc8))
* add dev-only utilities ([d2af65c](https://github.com/standardnotes/app/commit/d2af65c3378cf506b89f9cdd31dc9135d0d7812c))
* add docker-compose setup ([b2fde84](https://github.com/standardnotes/app/commit/b2fde84f8b95d53d7e5f076003226e93cbf0a553))
* Add editor icons ([6d47821](https://github.com/standardnotes/app/commit/6d47821b8f967f52fea3e43bdf2f4102257928b4))
* add empty notes list view ([572e2ce](https://github.com/standardnotes/app/commit/572e2ce3715086221577dc9896f273e916711628))
* add empty trash option ([674f14b](https://github.com/standardnotes/app/commit/674f14bf89148d12286252d5af0c3cf5d6afb5d6))
* add error reporting ([6cd4b87](https://github.com/standardnotes/app/commit/6cd4b8707ad2b6df89ae14eab199766cad66a91e))
* add file information panel to file preview modal ([#965](https://github.com/standardnotes/app/issues/965)) ([3126d97](https://github.com/standardnotes/app/commit/3126d97dcab9b3ab33011c29521916259383fab9))
* add file preview modal ([#945](https://github.com/standardnotes/app/issues/945)) ([12e3bb0](https://github.com/standardnotes/app/commit/12e3bb095982bdad308f75feca24e27aa44a1722))
* add file view ([#1064](https://github.com/standardnotes/app/issues/1064)) ([92024ec](https://github.com/standardnotes/app/commit/92024ec7cab69a49a1bdf081c2e74afd5056e679))
* add files button to multiple selection view ([#1067](https://github.com/standardnotes/app/issues/1067)) ([218e7a3](https://github.com/standardnotes/app/commit/218e7a3d069e037005837f63e2f504900ea35c8e))
* add files popover in note toolbar ([#913](https://github.com/standardnotes/app/issues/913)) ([b31afee](https://github.com/standardnotes/app/commit/b31afee10819a6beffd060039eb559ee09895c16))
* add icon to listed group header ([#895](https://github.com/standardnotes/app/issues/895)) ([3e14a77](https://github.com/standardnotes/app/commit/3e14a77d62fc390bb87c6164770c2ee2c2639d4c))
* add image zoom options ([#984](https://github.com/standardnotes/app/issues/984)) ([a78c0ce](https://github.com/standardnotes/app/commit/a78c0ce2a12e093b1cecbd2f4d69651e301df823))
* add Labs pane to preferences ([#892](https://github.com/standardnotes/app/issues/892)) ([ab6e5ac](https://github.com/standardnotes/app/commit/ab6e5ac367c248e6e89474c4f96f19ade0494602))
* Add Listed pane in preferences ([#651](https://github.com/standardnotes/app/issues/651)) ([e72d737](https://github.com/standardnotes/app/commit/e72d7372204756e2513b5d38e2b9e32ce4fe3abb))
* add migration pref pane ([#825](https://github.com/standardnotes/app/issues/825)) ([3c0bc79](https://github.com/standardnotes/app/commit/3c0bc79768e355335896033268ba4bb5ff1d189f))
* Add new "Change Editor" option to note context menu ([#823](https://github.com/standardnotes/app/issues/823)) ([b932e2a](https://github.com/standardnotes/app/commit/b932e2a45e2eeb789fb03a53b3d5b0d2ad1e9ec4))
* add new tag hint to dropdown ([42b1f4d](https://github.com/standardnotes/app/commit/42b1f4d62f0061822c4647927ad0633d5d6de740))
* Add note attributes to notes options menu ([#681](https://github.com/standardnotes/app/issues/681)) ([7f1dddf](https://github.com/standardnotes/app/commit/7f1dddf2d2fbe4a4a08affb1a91a3377c7e147cc))
* Add note ID for errored notes in note options ([#737](https://github.com/standardnotes/app/issues/737)) ([60eeee3](https://github.com/standardnotes/app/commit/60eeee385d28933208baa6e9b9288d8d77c0f856))
* add onSignOut bridge hook ([257c0f6](https://github.com/standardnotes/app/commit/257c0f6cab12ee86d9495845542fb47437007ba2))
* Add option to toggle editor icon in new notes list design ([#799](https://github.com/standardnotes/app/issues/799)) ([875f541](https://github.com/standardnotes/app/commit/875f5417befb4f84c830ef459e67967ffd2510dc))
* add parent chain tags when adding a tag ([6617362](https://github.com/standardnotes/app/commit/6617362783d984eef9908d3e42a661aea47fadcf))
* add placeholder to tag input ([0200351](https://github.com/standardnotes/app/commit/0200351ecc3e9e2ccaf6f11c286e4a1bbcc22205))
* add protect option to menu ([8302733](https://github.com/standardnotes/app/commit/8302733a49c66c4056bfc96fbb86300a6ba9ef49))
* add purchase url ([#695](https://github.com/standardnotes/app/issues/695)) ([e79811a](https://github.com/standardnotes/app/commit/e79811afdad268909de97c46b3e9b27780079cc5))
* Add quick settings menu with theme switcher and other changes ([#673](https://github.com/standardnotes/app/issues/673)) ([c8dc07d](https://github.com/standardnotes/app/commit/c8dc07d42b706ca6dd694f0de95cf676b53ca64c))
* add random identifier to bugsnag reports ([0bd3143](https://github.com/standardnotes/app/commit/0bd3143481bcecc3d09673c7c1b0c86e4d289bf2))
* add right-click context menu ([b70cc0e](https://github.com/standardnotes/app/commit/b70cc0e7e40219a67e8219cd25af87d4ea8ae58f))
* Add support for icons in Dropdown ([47b49aa](https://github.com/standardnotes/app/commit/47b49aa7a978896ccd20ddc5b350ccfa9405d837))
* add tag context menu ([#890](https://github.com/standardnotes/app/issues/890)) ([22718d8](https://github.com/standardnotes/app/commit/22718d8a9f5d54739c172238623629202a130da8))
* add tag on dropdown option click ([a8d6080](https://github.com/standardnotes/app/commit/a8d6080a6f1a2c2968e8ed152fb4afb259614bbc))
* add themes source ([#1089](https://github.com/standardnotes/app/issues/1089)) ([e80eb44](https://github.com/standardnotes/app/commit/e80eb441a717b7c892307635ff3af4db2e25d57c))
* add toast notifications using stylekit ([#905](https://github.com/standardnotes/app/issues/905)) ([c5eb84d](https://github.com/standardnotes/app/commit/c5eb84d7e8eb1cd1d05d37e98c7118d8d5c6d6ff))
* add warning to note options menu if note size is >0.5mb ([#851](https://github.com/standardnotes/app/issues/851)) ([5605bae](https://github.com/standardnotes/app/commit/5605baeb57742f356d77c8592fe28d80057efaff))
* add workspace switcher to lock screen ([#969](https://github.com/standardnotes/app/issues/969)) ([9ba7b87](https://github.com/standardnotes/app/commit/9ba7b875a87f15dedd528a68848bcd311466c3da))
* Added Slack deployment notifications ([0d56a4b](https://github.com/standardnotes/app/commit/0d56a4b605a8a665eef1295cfca0f061a9b5ea1f))
* adjust search options defaults (include archived notes by default) ([b56ba17](https://github.com/standardnotes/app/commit/b56ba1786741aad71c22d1254e40cf876b6c3dac))
* allow dev server port configuration from CLI ([49d8ca6](https://github.com/standardnotes/app/commit/49d8ca666d1bb4b07be71b3e93444c6ceec29b65))
* allow devServer writing to disk from the command line ([337589b](https://github.com/standardnotes/app/commit/337589b7e91a2f65f026e00708993ddc1bb4bf70))
* allow specifying if platform is web or not ([efc7596](https://github.com/standardnotes/app/commit/efc75965caa8b12b1bf02722eceb66b9be9bfd9c))
* allows duplicate names in tags folder & smart tags ([#792](https://github.com/standardnotes/app/issues/792)) ([a165fa9](https://github.com/standardnotes/app/commit/a165fa9b4eb83545102c5c78b2f9174f3e98acdf))
* Always show quick settings menu ([#765](https://github.com/standardnotes/app/issues/765)) ([dc9dc10](https://github.com/standardnotes/app/commit/dc9dc104c9670c3412673bbc150f2ab94d41efd3))
* animate search options entrance ([c6c8d84](https://github.com/standardnotes/app/commit/c6c8d842daf68a19b3d29b8529273ebaa20a019b))
* ask for password before previewing protected files ([#991](https://github.com/standardnotes/app/issues/991)) ([eacfa80](https://github.com/standardnotes/app/commit/eacfa80dbab125a57fb870393f5b2ff9dad8af75))
* authorize CloudLink access ([59dbbcf](https://github.com/standardnotes/app/commit/59dbbcf6fd179c6d4555b52ea04eb68350819ac8))
* autoplay videos when previewing ([#1036](https://github.com/standardnotes/app/issues/1036)) ([ce39fe5](https://github.com/standardnotes/app/commit/ce39fe55db77e1c4c2450d77bb0af7b2aa373ca5))
* batch manager protection + react challenge modal + eslint fix ([5d65364](https://github.com/standardnotes/app/commit/5d65364885d259933e9a1f1d5462d3639fddea1a))
* better decryption attempt; upgrade snjs with file size changes ([d33e48e](https://github.com/standardnotes/app/commit/d33e48edd884568dc4827456ae811ad1478f8554))
* bold editor, markdown pro spellcheck bump ([5df8a74](https://github.com/standardnotes/app/commit/5df8a742944812b4ffc9524542b530466633ad41))
* bump editors with concern alert ([62cb707](https://github.com/standardnotes/app/commit/62cb70728e5c96ce0af1f8ec02f9ef45cebbf94b))
* cancelable challenges ([3057eaa](https://github.com/standardnotes/app/commit/3057eaafb43e9efcbf446a8cd4b3190f0de07fad))
* change `label` to `button` for better accessibility, let users to import backup by keyboard as well ([a76213d](https://github.com/standardnotes/app/commit/a76213dd1f84e5a0db2497e89e13eaa26ead364d))
* Change bg color when focusing tag instead of border ([#751](https://github.com/standardnotes/app/issues/751)) ([21433b5](https://github.com/standardnotes/app/commit/21433b5544179700188d91d2893b0b923198b112))
* change restore locked note message ([197a552](https://github.com/standardnotes/app/commit/197a552d87cde52c595a40d307b6da8d8c5defbd))
* check for files beta role ([#986](https://github.com/standardnotes/app/issues/986)) ([925504d](https://github.com/standardnotes/app/commit/925504de320162cf72228f19243382f6b2501ba8))
* **ci:** add workflow_dispatch to dev action ([54486e4](https://github.com/standardnotes/app/commit/54486e4e81443b19c1333ad9f270e0dec6adeff1))
* clear protection session ([badff15](https://github.com/standardnotes/app/commit/badff1568d6181909caa06c4546c93b75dcba83b))
* clicking on tag sets it as active ([bf1fba9](https://github.com/standardnotes/app/commit/bf1fba91dc9a3ee47ab1ef29704e91674e04cace))
* close change editor menu once editor is selected ([#907](https://github.com/standardnotes/app/issues/907)) ([c150cd6](https://github.com/standardnotes/app/commit/c150cd6867af87a6aa82cfaae809214cae57ad44))
* close context menu on extension click ([278bec8](https://github.com/standardnotes/app/commit/278bec8d56e8a29a2114b4c590c0820bf4679258))
* close submenu if another submenu is opened ([#911](https://github.com/standardnotes/app/issues/911)) ([08fb913](https://github.com/standardnotes/app/commit/08fb913b0e1d1b23b2eb83100c8c08aea44f3fd4))
* collapse tags on click outside ([b5906ec](https://github.com/standardnotes/app/commit/b5906ecf788fdc1832ea6b205aefb1cb4bef0038))
* Component toggleability and add toggleable components to quick settings menu ([#707](https://github.com/standardnotes/app/issues/707)) ([fd6d836](https://github.com/standardnotes/app/commit/fd6d83655c54c74ba9ac9eeddd6f9fc27a3baa3d))
* component viewer ([#781](https://github.com/standardnotes/app/issues/781)) ([ebdae31](https://github.com/standardnotes/app/commit/ebdae31965c6f827c568d4a2134d9107dff1231b))
* confirm navigating away when upgrade is in progress ([1e00dc2](https://github.com/standardnotes/app/commit/1e00dc2be80bca777e4180558c8a0982786f53ec))
* context menu for deleting tags ([de31fe7](https://github.com/standardnotes/app/commit/de31fe7d6149bd72ca5630f8f894e8f1f1c922b0))
* create and add tag on click enter ([e3ea0aa](https://github.com/standardnotes/app/commit/e3ea0aaafcc517a48ee6ca5eff9e38773f0cdd83))
* create and add tag to note on hint click ([4c6bfb8](https://github.com/standardnotes/app/commit/4c6bfb8519e5c42175365ff2b829c505a4a5edf7))
* create placeholder only in All view ([02ccc2d](https://github.com/standardnotes/app/commit/02ccc2d8a6218ddf35477fb94dd7dd17b97e5dba))
* custom challenges ([d42518f](https://github.com/standardnotes/app/commit/d42518fc61cb4edd185da406798583a99e076b2f))
* decrease editor font size ([7f7b849](https://github.com/standardnotes/app/commit/7f7b849ab8c5b474bbc1ee614799361e2974c79f))
* default to delete permanently option for errored note ([dbb2598](https://github.com/standardnotes/app/commit/dbb2598f81a80a0d11b3df00cb2dec6a65df1bff))
* delete local backups when signing out ([6a52721](https://github.com/standardnotes/app/commit/6a52721ea789c60c9877d28358e4b1a51e2ddd4e))
* demo token ([67e0bf0](https://github.com/standardnotes/app/commit/67e0bf0ccfeebf872040689bfa1141be8fb79927))
* desktop compatibility, beta 1 ([0f01d29](https://github.com/standardnotes/app/commit/0f01d296e47cfb8abb46a8d175311b7fe0e46f96))
* **dev:** preload dev account from .env ([#803](https://github.com/standardnotes/app/issues/803)) ([561ebca](https://github.com/standardnotes/app/commit/561ebcadcf93cdd22c151713772a72d2b8ca7b7d))
* disable autocomplete for search input ([#919](https://github.com/standardnotes/app/issues/919)) ([7720793](https://github.com/standardnotes/app/commit/772079338fb42721f2468a2c0ac0057b1de9e14b))
* disable note title input autocomplete ([#963](https://github.com/standardnotes/app/issues/963)) ([d1df913](https://github.com/standardnotes/app/commit/d1df913578815b533cfa08aa05fce1d6fabbff30))
* disabled 2fa feature ([#631](https://github.com/standardnotes/app/issues/631)) ([7b1499d](https://github.com/standardnotes/app/commit/7b1499d75eeb25a1f85190e63aea1a0c70b08c9c))
* display beta warning on desktop ([ee563cd](https://github.com/standardnotes/app/commit/ee563cd09b68f84d971638a4eb66f8947ed38a7b))
* display feature status ([#745](https://github.com/standardnotes/app/issues/745)) ([cf36647](https://github.com/standardnotes/app/commit/cf3664751f5530ad96fedb6404a5b2357da7567b))
* display files quota in preferences ([#994](https://github.com/standardnotes/app/issues/994)) ([68ad0f1](https://github.com/standardnotes/app/commit/68ad0f17ae1a6e5f52fbe847e3c8db3557a8ac49))
* display folders even without the premium ([#826](https://github.com/standardnotes/app/issues/826)) ([7726b12](https://github.com/standardnotes/app/commit/7726b1249c3eef7aedb4e31955775902111e2ed3))
* display warning banner when using the app with no account ([c084268](https://github.com/standardnotes/app/commit/c084268f51b46bc5008a33010b6c7c58f5725f88))
* download backup before changing password ([add0497](https://github.com/standardnotes/app/commit/add0497e1461f8f802a3d35cdcd36ae0fe6f0613))
* drag file on tab button to switch to that tab ([#1013](https://github.com/standardnotes/app/issues/1013)) ([c981cdc](https://github.com/standardnotes/app/commit/c981cdced4e55cee806e32a17d3963df2696a1d1))
* Dropdown component ([a98409a](https://github.com/standardnotes/app/commit/a98409a95ff6a571d0c0c12f2d0196444758718a))
* enable email backups for everyone ([58b6389](https://github.com/standardnotes/app/commit/58b63898de716c52bfec3af96025b61f9d4d6691))
* enable folders by default and remove from experimental features ([70f4dd6](https://github.com/standardnotes/app/commit/70f4dd63532276bba41eaa1ec9d2552a74de8722))
* enable sessions management for every build ([4d30d01](https://github.com/standardnotes/app/commit/4d30d019ee52aed511e0f23785ee27b27c9838ee))
* enable websocket connection ([3cba208](https://github.com/standardnotes/app/commit/3cba208b0703e7656a335f94f34e243313e5fa0f))
* encryption status dynamic string ([#642](https://github.com/standardnotes/app/issues/642)) ([30deea7](https://github.com/standardnotes/app/commit/30deea79b24088efb930be65c5dc6673914a6e7f))
* error decrypting preferences section ([#990](https://github.com/standardnotes/app/issues/990)) ([fdf290e](https://github.com/standardnotes/app/commit/fdf290ea1a9cf8f712e84c15d03446b56a992f08))
* escape when submenu is open should close it instead of entire menu ([660525d](https://github.com/standardnotes/app/commit/660525dc1870be673c08673b0346592055ad9aa9))
* export as zip if multiple notes are selected ([#926](https://github.com/standardnotes/app/issues/926)) ([a2a4b6b](https://github.com/standardnotes/app/commit/a2a4b6b180284c2062b18d7b6b4d07cf9133ae14))
* extension manager in preferences ([#670](https://github.com/standardnotes/app/issues/670)) ([7b6c99d](https://github.com/standardnotes/app/commit/7b6c99d1883ab9a11d776dd5afa57ad77065daff))
* fetch features and store locally for offline users ([#706](https://github.com/standardnotes/app/issues/706)) ([04fab80](https://github.com/standardnotes/app/commit/04fab80adb42d153a980fdd89a072c4f32ee5e90))
* file backups ([#1024](https://github.com/standardnotes/app/issues/1024)) ([942226e](https://github.com/standardnotes/app/commit/942226e15a5676ec4dd127e2e67e3b89ab159530))
* files related improvements ([d7ba393](https://github.com/standardnotes/app/commit/d7ba3935edd97f8f6cf52d02916220f429e4daac))
* Fix menu border color ([#730](https://github.com/standardnotes/app/issues/730)) ([716e1cf](https://github.com/standardnotes/app/commit/716e1cf46518f8f3a6c4445e72d746722c16edec))
* focus back on passcode input after failure ([729a1a8](https://github.com/standardnotes/app/commit/729a1a8dfdae4a346f22bf0ffe8969dbe9221be8))
* focus input after selecting tag ([622cca7](https://github.com/standardnotes/app/commit/622cca770fef93778022a21b8fdb31ccde5c73fe))
* focus last tag when pressing backspace on input ([d6f1cc3](https://github.com/standardnotes/app/commit/d6f1cc3730a6ff01cb844637406a411df01728db))
* generic items list ([#1035](https://github.com/standardnotes/app/issues/1035)) ([6401da2](https://github.com/standardnotes/app/commit/6401da2570d4a54fd77ca449629e6e023afd8f85))
* get editor icons and their colors from snjs ([#828](https://github.com/standardnotes/app/issues/828)) ([bf382ce](https://github.com/standardnotes/app/commit/bf382ce0f858ad6d34fa48dcbbf77f22f0d1e255))
* get plan name from subscriptions endpoint ([1b87df1](https://github.com/standardnotes/app/commit/1b87df18bc42b0f4491d881465ffdead96de4762))
* get sorted tags for note ([237a64c](https://github.com/standardnotes/app/commit/237a64c3220beb1eb925e8bf10c0c7c5929f0fc3))
* git sync ([#754](https://github.com/standardnotes/app/issues/754)) ([b5e89f4](https://github.com/standardnotes/app/commit/b5e89f461e1b29a74e5b59d030369445faabed4c))
* handle removed grey-x colors from stylekit ([#1046](https://github.com/standardnotes/app/issues/1046)) ([c6839f7](https://github.com/standardnotes/app/commit/c6839f776a447568040c58a83c220406c34efc3f))
* handle unprotected session expiration ([#747](https://github.com/standardnotes/app/issues/747)) ([8db549f](https://github.com/standardnotes/app/commit/8db549f6f6a474e73b57bb31d8d9c8dc95bd0a85))
* handle unprotected session expiration ([#779](https://github.com/standardnotes/app/issues/779)) ([f120af3](https://github.com/standardnotes/app/commit/f120af3b435a7520afe21d39a049b6d25442c982))
* hide some prefs if not logged in ([#979](https://github.com/standardnotes/app/issues/979)) ([9dafdee](https://github.com/standardnotes/app/commit/9dafdeeddb0159bd09fa9829e060231383385fe7))
* highlight tag on click ([90cc806](https://github.com/standardnotes/app/commit/90cc806e1564a9ade6a6e359883df766c3c8b24f))
* implement credentials information on Prefs -> Account pane ([#632](https://github.com/standardnotes/app/issues/632)) ([b0ed19d](https://github.com/standardnotes/app/commit/b0ed19d6a36c6219851d1d5c4e6b9ef4bd70fc59))
* implement enableUnfinishedFeatures flag and hidden preferences button ([3f94636](https://github.com/standardnotes/app/commit/3f946366155d24e0e1414b11f63389a18cb91783))
* implement encrypted items info ([#641](https://github.com/standardnotes/app/issues/641)) ([7b5b788](https://github.com/standardnotes/app/commit/7b5b78832a4ee51994df14f501753a07a181c822))
* implement preferences pane ([a987021](https://github.com/standardnotes/app/commit/a9870214ea0b62381d759bff162e08804289b1c6))
* implement Protections in prefs ([#645](https://github.com/standardnotes/app/issues/645)) ([5f65d2e](https://github.com/standardnotes/app/commit/5f65d2eca76cf5925aff309e54a73a1760345061))
* implement SNApplication.hasProtectionSources ([1852b5e](https://github.com/standardnotes/app/commit/1852b5e0454efe7aac369fd43201f6ff1037c405))
* implement SNJS backup file password retrieval ([d4f02a1](https://github.com/standardnotes/app/commit/d4f02a124df66432aeb569cf7e48c125cf085ea6))
* implement SNJS blocking dialog title ([ed07655](https://github.com/standardnotes/app/commit/ed07655289734f6b9493d9c4b68a5ce0f7e55b48))
* implement spinner for 2fa loading ([#640](https://github.com/standardnotes/app/issues/640)) ([a9610fd](https://github.com/standardnotes/app/commit/a9610fdbc6dd17c378929dcfde55603f982df417))
* implement tags folder as experimental feature ([#788](https://github.com/standardnotes/app/issues/788)) ([237cd91](https://github.com/standardnotes/app/commit/237cd91acd78967929bc77258e0e46eb8e9877ef)), closes [#10](https://github.com/standardnotes/app/issues/10) [#9](https://github.com/standardnotes/app/issues/9) [#13](https://github.com/standardnotes/app/issues/13) [#774](https://github.com/standardnotes/app/issues/774) [#775](https://github.com/standardnotes/app/issues/775) [#776](https://github.com/standardnotes/app/issues/776) [#785](https://github.com/standardnotes/app/issues/785)
* implement UI for logging out ([#638](https://github.com/standardnotes/app/issues/638)) ([77525a5](https://github.com/standardnotes/app/commit/77525a56cd48aed2617a2b5790655e1f8e19ffed))
* import svg files from stylekit ([#844](https://github.com/standardnotes/app/issues/844)) ([00d57aa](https://github.com/standardnotes/app/commit/00d57aa69ddf646326418a9c3408e2aed0624afb))
* improve 2fa styles based on feedback ([#635](https://github.com/standardnotes/app/issues/635)) ([8fb34f2](https://github.com/standardnotes/app/commit/8fb34f2e85d346f86e1cc75dd3b9ebb7ed6114f9))
* improve bridge and exported types ([016b730](https://github.com/standardnotes/app/commit/016b73028d6c50b1e9a648aafa29b51b32288d1d))
* improve change editor menu keyboard navigation ([#831](https://github.com/standardnotes/app/issues/831)) ([0ecbde6](https://github.com/standardnotes/app/commit/0ecbde6bac0c93ef232fea9c9f7fcad037d739f1))
* improve filename sanitizing ([275c8cb](https://github.com/standardnotes/app/commit/275c8cbd1f56cf1cb3bf585837260009a1632063))
* improve focus styles ([5f02540](https://github.com/standardnotes/app/commit/5f025406681815f192083139f9d18b19d4e49936))
* improve preference copy and case consistency ([03f707e](https://github.com/standardnotes/app/commit/03f707ee63f0c5bd0c8240011efcce0794eeb851))
* improve strings, challenges, and template readiness ([b3e5ca3](https://github.com/standardnotes/app/commit/b3e5ca340d913b9b1c2212da286dcb685ba417e3))
* initially focus "create account" if no account ([#944](https://github.com/standardnotes/app/issues/944)) ([8715a8b](https://github.com/standardnotes/app/commit/8715a8b8f489154a2108bbd9e8f773eb35773ea0))
* integrate two factor authentication ([#626](https://github.com/standardnotes/app/issues/626)) ([1294b94](https://github.com/standardnotes/app/commit/1294b941175e72a7298c246d58966289cba2086c))
* Keep only "Manage subscription" button in account subscription prefs ([#711](https://github.com/standardnotes/app/issues/711)) ([db1139f](https://github.com/standardnotes/app/commit/db1139fd44edf0fb4049579caa931bb8e5f4a8f8))
* label new note button ([465a6b5](https://github.com/standardnotes/app/commit/465a6b55a03fcf049a25f793b035832afcf01391))
* line up sessions management with latest SNJS ([7261c2f](https://github.com/standardnotes/app/commit/7261c2f119a399b96f1dfcf1a5f6ced27b607dfd))
* listen to file dnd event on window instead of just popover ([#921](https://github.com/standardnotes/app/issues/921)) ([5b42eed](https://github.com/standardnotes/app/commit/5b42eedd978e0de6be51fae7889a85e6b4eda7c9))
* make "Protected" flag more subtle ([ed7f093](https://github.com/standardnotes/app/commit/ed7f093e02c3e69a889651c5967fde080ca609a6))
* make archived false by default on search options ([3648f29](https://github.com/standardnotes/app/commit/3648f29174b6ce3cc409a9cc1cb56187369534b0))
* make delete backups checkbox off by default ([c38b1f0](https://github.com/standardnotes/app/commit/c38b1f042f401f9ccb8cf9dd14dfa9b0a1bb3f2a))
* make encrypted backups protected ([#524](https://github.com/standardnotes/app/issues/524)) ([d49e508](https://github.com/standardnotes/app/commit/d49e508cfce409a3578f57f0bc3642f06ff729b0))
* make error reporting opt-in ([d44748f](https://github.com/standardnotes/app/commit/d44748fcad6e353839295d6b9dd17419a329ab47))
* make hint fixed on bottom of dropdown ([f7bc9e0](https://github.com/standardnotes/app/commit/f7bc9e0b0ac0d10435e0a3e458cd5795918b2144))
* make listed menu sorting consistent ([#896](https://github.com/standardnotes/app/issues/896)) ([f9fafec](https://github.com/standardnotes/app/commit/f9fafec11a9e2f32b25b144d220dd79e21315c34))
* Make purchase flow modal mobile-friendly ([#732](https://github.com/standardnotes/app/issues/732)) ([1e21969](https://github.com/standardnotes/app/commit/1e219699dfc4f568b00bf77b649ac3999c45a9ab))
* make SNWebCrypto a constant ([2c4742a](https://github.com/standardnotes/app/commit/2c4742a91dad3bfa8a1a7799991fd6da7bd6d0e1))
* make tags container expandable ([7ac5856](https://github.com/standardnotes/app/commit/7ac58562058004faad039e8684e1795fd13837a1))
* make unprotecting a note a protected action ([a3f73ba](https://github.com/standardnotes/app/commit/a3f73ba6645372a1be6628aa5c23e2d8c4d00534))
* make whole menu switch be clickable ([#837](https://github.com/standardnotes/app/issues/837)) ([7c41cfc](https://github.com/standardnotes/app/commit/7c41cfc3dcc55626db840ec472a6aadb5392150b))
* mobile app package ([#1075](https://github.com/standardnotes/app/issues/1075)) ([8248a38](https://github.com/standardnotes/app/commit/8248a38280cb7c92da2b2e9c7db298f34ae8ffdf))
* modify current tags to v4 style ([90250d2](https://github.com/standardnotes/app/commit/90250d22a3d3f60cd7e47d4380ddd6f27b45c2bf))
* move change editor up in menu ([#847](https://github.com/standardnotes/app/issues/847)) ([3fb2732](https://github.com/standardnotes/app/commit/3fb27326fa4ab93aa3c0bad140ad007cfbfd59b5))
* move extensions from prefs menu's left pane to General->Advanced section ([#718](https://github.com/standardnotes/app/issues/718)) ([bbc81ea](https://github.com/standardnotes/app/commit/bbc81ea276e147bbed3d0cd5e9ceb6477e47c99f))
* move save method into snjs controller ([#809](https://github.com/standardnotes/app/issues/809)) ([c1b7f60](https://github.com/standardnotes/app/commit/c1b7f60e358cb54978cd430f1bc2106cb4d8754d))
* move SubscriptionState to central AppState ([#869](https://github.com/standardnotes/app/issues/869)) ([dab8080](https://github.com/standardnotes/app/commit/dab8080da67b1ee19263987a0ae0d58efe57d171))
* multiple files selected view ([#1062](https://github.com/standardnotes/app/issues/1062)) ([4caf958](https://github.com/standardnotes/app/commit/4caf9586598a5bb090b52716f45e7a20b5e570c4))
* Multiple minor changes ([#769](https://github.com/standardnotes/app/issues/769)) ([24c6b83](https://github.com/standardnotes/app/commit/24c6b831c6ae7ae23133a7ef601393e1b787312b))
* multiple selected notes panel ([abfc588](https://github.com/standardnotes/app/commit/abfc588368a71d7ee5fc753253d82d2ab5ee9ad4))
* namespaced keychain ([#428](https://github.com/standardnotes/app/issues/428)) ([568fb14](https://github.com/standardnotes/app/commit/568fb14f3ac5d7251833dd18ed880e2146b46ecc))
* native components ([#789](https://github.com/standardnotes/app/issues/789)) ([66d8efd](https://github.com/standardnotes/app/commit/66d8efd090b107ee15c66e73738e80a5382a1a3b)), closes [#781](https://github.com/standardnotes/app/issues/781)
* native listed integration ([#846](https://github.com/standardnotes/app/issues/846)) ([6970a37](https://github.com/standardnotes/app/commit/6970a375b7eb31901edbcd3bcc19e6394028c24c))
* native smart tags ([#782](https://github.com/standardnotes/app/issues/782)) ([c3772e0](https://github.com/standardnotes/app/commit/c3772e06b459e22d54a69ef307cfb74500c2e16d))
* Nativize "No distraction" theme as "Focus Mode" ([#758](https://github.com/standardnotes/app/issues/758)) ([9730006](https://github.com/standardnotes/app/commit/9730006cba755ddbfb3ccf2692af9d785562a8a0))
* navigate tags with arrow keys ([672331f](https://github.com/standardnotes/app/commit/672331faaae53cf7b30522135d3d57948afccc92))
* New account menu and text input with icon & toggle ([#665](https://github.com/standardnotes/app/issues/665)) ([f1122f2](https://github.com/standardnotes/app/commit/f1122f292ecf8f44a1b8f4a711bc5d56a0069cdf))
* new lock screen and challenge modal design ([#957](https://github.com/standardnotes/app/issues/957)) ([c16f23a](https://github.com/standardnotes/app/commit/c16f23a75fa82949fd87d2939cd2524e97259dc3))
* New notes list design ([#780](https://github.com/standardnotes/app/issues/780)) ([7dd4a60](https://github.com/standardnotes/app/commit/7dd4a605952dc50f7c183ada225ae36808334c3b))
* new revision history UI ([#861](https://github.com/standardnotes/app/issues/861)) ([71c7ee1](https://github.com/standardnotes/app/commit/71c7ee1bec2bdff18f81fe9004c4ae64d7283ca1))
* nicer smart filters & folders theme ([#795](https://github.com/standardnotes/app/issues/795)) ([7996f4e](https://github.com/standardnotes/app/commit/7996f4e5a2b6d38c282f66633b9fd86792d62216))
* note types ([f5a9006](https://github.com/standardnotes/app/commit/f5a90060ea75e262a1fd59289a9c4644f2692b2f))
* notes display criteria ([#530](https://github.com/standardnotes/app/issues/530)) ([e0ab938](https://github.com/standardnotes/app/commit/e0ab938ccf995dd3d33ff43d86954a8ea9bec7d3))
* omit active note tags from dropdown ([b2d15be](https://github.com/standardnotes/app/commit/b2d15be1845498a656e2300fbf2dbbc3bc0e1783))
* only fetch files quota when prefs are opened ([#999](https://github.com/standardnotes/app/issues/999)) ([50d047a](https://github.com/standardnotes/app/commit/50d047a90334d35f3d69ef78c3a5cdb0a51a5753))
* open purchase flow ([e134598](https://github.com/standardnotes/app/commit/e134598c20ba6fe3c73936813312759f0fb77bfa))
* option to sign out all workspaces ([#1005](https://github.com/standardnotes/app/issues/1005)) ([bce8c5f](https://github.com/standardnotes/app/commit/bce8c5fcbaeb195e1f2579f6640d10401ffc5529))
* option to toggle adding note to all parent folders ([#937](https://github.com/standardnotes/app/issues/937)) ([bd9a6e2](https://github.com/standardnotes/app/commit/bd9a6e2ae5078dc8bbe199ba846cae509111de25))
* Pass period & plan params to purchase page ([#733](https://github.com/standardnotes/app/issues/733)) ([3c3131a](https://github.com/standardnotes/app/commit/3c3131adef4ebc431f020bb8174fc98966e5812c))
* pass web app version to snjs application ([#623](https://github.com/standardnotes/app/issues/623)) ([041d437](https://github.com/standardnotes/app/commit/041d437bd453950fc2033357780d5a437803dc27))
* passcode lock in preferences ([#644](https://github.com/standardnotes/app/issues/644)) ([73f03e6](https://github.com/standardnotes/app/commit/73f03e6ea67eb1ae1647714bbe25df75a1c29063))
* password wizard typescripting and UI improvements ([de55a4d](https://github.com/standardnotes/app/commit/de55a4dd1e5479639305b50dec4b45e99eeb9a6f))
* per-note spellcheck ([#815](https://github.com/standardnotes/app/issues/815)) ([063c3b2](https://github.com/standardnotes/app/commit/063c3b2fee4c6177c5103f48b2dbab73b748a59e))
* persist tags expanded state ([0c3d1fc](https://github.com/standardnotes/app/commit/0c3d1fce0caf969b4105ad342644e71ca1e6f23c))
* preferences help & feedback ([#596](https://github.com/standardnotes/app/issues/596)) ([f6b1b57](https://github.com/standardnotes/app/commit/f6b1b5797176b6d0088cc538cbe2d665855a5674))
* **preferences:** 2FA activation dialog with mocked state ([#605](https://github.com/standardnotes/app/issues/605)) ([84bb17b](https://github.com/standardnotes/app/commit/84bb17ba1d68eac13eb49ec7d6431dd6d0acda6b))
* **preferences:** close preferences with Esc button ([#647](https://github.com/standardnotes/app/issues/647)) ([150f7a7](https://github.com/standardnotes/app/commit/150f7a7835491bae5c2157cf59622e42263cd9f2))
* **preferences:** Defaults segment ([b4fcc99](https://github.com/standardnotes/app/commit/b4fcc993aa6d994efadff8a7401d5515eb43fa1b))
* **preferences:** error reporting segment ([#652](https://github.com/standardnotes/app/issues/652)) ([3867f62](https://github.com/standardnotes/app/commit/3867f625f1ef524b8039b25ffcb09738befd5115))
* **preferences:** extension modals into extension panes ([#683](https://github.com/standardnotes/app/issues/683)) ([31222e1](https://github.com/standardnotes/app/commit/31222e1236e2765fc9f9ac2dab40b6c21422f341))
* **preferences:** improve custom extension installation design ([#674](https://github.com/standardnotes/app/issues/674)) ([d61ff51](https://github.com/standardnotes/app/commit/d61ff5138b2bbbb761efda7c9a435a47781bbd5e))
* **preferences:** no-subscription for non logged in users ([#676](https://github.com/standardnotes/app/issues/676)) ([6f18664](https://github.com/standardnotes/app/commit/6f18664564be8d64ba8ea1c3c96dc6b9fb796f43))
* **preferences:** not logged in segment ([#649](https://github.com/standardnotes/app/issues/649)) ([b312df4](https://github.com/standardnotes/app/commit/b312df41a6b768edcf4b8d8866a9a21e382de268))
* **preferences:** show latest extension version ([#675](https://github.com/standardnotes/app/issues/675)) ([e0c6aab](https://github.com/standardnotes/app/commit/e0c6aab03d5b003bb35fd8d95744b7c61eea853a))
* **preferences:** Tools segment ([#657](https://github.com/standardnotes/app/issues/657)) ([7dbfa2f](https://github.com/standardnotes/app/commit/7dbfa2fde01fc1078458eec2f764c9936ef10f6f))
* prevent refreshing when setting passcode ([5b72f4e](https://github.com/standardnotes/app/commit/5b72f4e88fdc2af67e8ee57b1fc706497bb6ffd9))
* preview improvements ([#989](https://github.com/standardnotes/app/issues/989)) ([1391f88](https://github.com/standardnotes/app/commit/1391f882636635b57254e1ab09cf0573234cc9e1))
* preview next/prev files using arrow keys ([#1004](https://github.com/standardnotes/app/issues/1004)) ([96be0d5](https://github.com/standardnotes/app/commit/96be0d578d4233f0919020f0847a4203ab66e697))
* privacy prefs ([#935](https://github.com/standardnotes/app/issues/935)) ([fb9bd37](https://github.com/standardnotes/app/commit/fb9bd37d72ddd87d5d4dd88eebb16217a929c3e0))
* Purchase "Create account" & "Sign in" flows and Floating label input ([#672](https://github.com/standardnotes/app/issues/672)) ([f9b1526](https://github.com/standardnotes/app/commit/f9b15262c7c6efb9aff8da44e82f39c28f0bf23d))
* redesign search filtering experience ([#908](https://github.com/standardnotes/app/issues/908)) ([5d49352](https://github.com/standardnotes/app/commit/5d49352f938dbd5001460103fa0eabb9936909b6))
* redirect subscribers to dashboard instead of plans page ([#897](https://github.com/standardnotes/app/issues/897)) ([7fe0873](https://github.com/standardnotes/app/commit/7fe0873bbb570e2557a505175d9a3cb3dcdfb24a))
* reduce number of steps needed to get going for local development ([#454](https://github.com/standardnotes/app/issues/454)) ([57aa942](https://github.com/standardnotes/app/commit/57aa942c913587fd21d9648d98673b56997e7c7b))
* remove 2fa UI in favor of challenges ([8cec60f](https://github.com/standardnotes/app/commit/8cec60f9ff85697906ca8063f47297d0de637366))
* remove account menu sync spinner ([a39d8ed](https://github.com/standardnotes/app/commit/a39d8ed72ed3edaafda51f356e5c2a0a54027293))
* remove animations from context menu ([633add7](https://github.com/standardnotes/app/commit/633add73c913f541d281d9ed3fef2af37141d6f0))
* remove batch manager ([e24734e](https://github.com/standardnotes/app/commit/e24734e3cdb887a4841c3a9068ad0fc78cdd057b))
* remove broadcasting Extensions Manager events from `ComponentView` ([#703](https://github.com/standardnotes/app/issues/703)) ([b898e88](https://github.com/standardnotes/app/commit/b898e886a5a57b994f90211c8961080a06f73a29))
* remove bugsnag ([#931](https://github.com/standardnotes/app/issues/931)) ([bcfb22f](https://github.com/standardnotes/app/commit/bcfb22fef650feaa1ac3f545166f0d1d41cc5427))
* remove extensions manager ([#696](https://github.com/standardnotes/app/issues/696)) ([8d9b192](https://github.com/standardnotes/app/commit/8d9b192b81e13d385fd4664e2a5a1a1d97b32d95))
* remove note options from legacy options menu ([97b999d](https://github.com/standardnotes/app/commit/97b999d18b97d304183b321c8fec42ec16ab4865))
* Remove obselete code related to editor preferences ([#691](https://github.com/standardnotes/app/issues/691)) ([bbeab4f](https://github.com/standardnotes/app/commit/bbeab4f6232632c5205d1c939fc3819eeacba8c5))
* remove overflowed tags feature ([02f3c7c](https://github.com/standardnotes/app/commit/02f3c7c26cf850a994965e0d52f950a3fec3fea3))
* remove previous tag input ([c05220a](https://github.com/standardnotes/app/commit/c05220af7ac90a9968bcf197de423f2ee8acca1b))
* remove privacy prefs from unfinished features ([e83b183](https://github.com/standardnotes/app/commit/e83b183f78d9f620198c4da1bbb45ff1ce0bab46))
* Remove references of default editor ([f6c019b](https://github.com/standardnotes/app/commit/f6c019b63c7ab5ac9ba2d030dabad3e08b1baf6d))
* Remove Set Default & Undefault buttons ([1a92fff](https://github.com/standardnotes/app/commit/1a92fffcd46941de944f8416060c27e6624a157d))
* remove tag on backspace press ([69c9247](https://github.com/standardnotes/app/commit/69c9247cd9bd8a4715a520d4593be7504b433618))
* remove unfinished flag for private workspaces ([f623afe](https://github.com/standardnotes/app/commit/f623afeed8528cbdb7e4bdcee73ed284380dcbb1))
* remove vertical padding from change editor menu ([#836](https://github.com/standardnotes/app/issues/836)) ([c1f1aa4](https://github.com/standardnotes/app/commit/c1f1aa4c8d6dbf7dd3f435198e6bc52b7397417a))
* rename backup files to mention their importing capabilities ([207890d](https://github.com/standardnotes/app/commit/207890dc2f9d893d493c3624164bd1355905ea63))
* replace accordion in change editor menu with regular menu ([#871](https://github.com/standardnotes/app/issues/871)) ([cc2bc1e](https://github.com/standardnotes/app/commit/cc2bc1e21c971b6907090ae50eb04a291d8d22fe))
* Replace border-gray-300 with border-neutral ([#716](https://github.com/standardnotes/app/issues/716)) ([bad87a4](https://github.com/standardnotes/app/commit/bad87a4f2f97c6d66c7d7ac5d239ba63f00d06e5))
* replace IonIcons with svg icons ([#1069](https://github.com/standardnotes/app/issues/1069)) ([4c65784](https://github.com/standardnotes/app/commit/4c65784421bebf1cd508a516452c43681c083845))
* reword storage upgrade migration ([a81e2f0](https://github.com/standardnotes/app/commit/a81e2f02e5df3790e728d592708faa33ba2d1d33))
* search options ([#540](https://github.com/standardnotes/app/issues/540)) ([ed69680](https://github.com/standardnotes/app/commit/ed69680295d48986af21d8526f9de916d0e47b43))
* search protected notes text ([56665b2](https://github.com/standardnotes/app/commit/56665b2315adbfdde7f75c3f2e3f2f70dea935db))
* select multiple notes in list ([0f53361](https://github.com/standardnotes/app/commit/0f533616897c0437e4fb513639a5fbd50e98e6fa))
* set tabindex depending on overflowed tags ([70e4425](https://github.com/standardnotes/app/commit/70e4425e20a3dc0334e56646c8146a12851876ca))
* shift-click to select range of notes ([9bf9cc3](https://github.com/standardnotes/app/commit/9bf9cc37da83280a59739ddaf9394ec8c19ed700))
* show alert if file exceeds classic reader limit ([#948](https://github.com/standardnotes/app/issues/948)) ([97f14e2](https://github.com/standardnotes/app/commit/97f14e2a95d24ba84d26ae9ca70933414e84cd1e))
* show alert when changing to non-interchangeable editor ([#834](https://github.com/standardnotes/app/issues/834)) ([6150f58](https://github.com/standardnotes/app/commit/6150f58c73b3c26eba327f324eb8557b3796b75d))
* show all themes and premium icon if not entitled ([#854](https://github.com/standardnotes/app/issues/854)) ([139853a](https://github.com/standardnotes/app/commit/139853a491c30dd2190d1e23950fc3b308d4bc11))
* show button to remove note on focus ([093acd1](https://github.com/standardnotes/app/commit/093acd151954949e1c961f3580d26b236b25732b))
* show data upgrade when available ([02ad4b8](https://github.com/standardnotes/app/commit/02ad4b8197b0b6c653493d573ef136aa4d12e843))
* show date on revision preview ([8951264](https://github.com/standardnotes/app/commit/895126475768682c0b42ba66fa9b003b30cd42ac))
* show deprecation notice ([#587](https://github.com/standardnotes/app/issues/587)) ([b3347b7](https://github.com/standardnotes/app/commit/b3347b75bad6f61f916bbae4a5e3ed6069b6e293))
* show download progress in file preview modal ([#1011](https://github.com/standardnotes/app/issues/1011)) ([2c807e2](https://github.com/standardnotes/app/commit/2c807e2b8022e9b117d4bb8634dfb76767d16d20))
* show download/upload progess in toast ([#1008](https://github.com/standardnotes/app/issues/1008)) ([e4fbb25](https://github.com/standardnotes/app/commit/e4fbb2515e323779e9be8fa1a609e9ebe7021c3c))
* show editor version under selected editor title ([#536](https://github.com/standardnotes/app/issues/536)) ([fb7ca90](https://github.com/standardnotes/app/commit/fb7ca903df737ba01cccd7be9dd1b7d3c8539f3d))
* show menu options according to v4 specs ([894e151](https://github.com/standardnotes/app/commit/894e151a7e5f342ad4ee3e08a84b40922973c8ef))
* show offline status in saving indicator ([#539](https://github.com/standardnotes/app/issues/539)) ([57ddeb3](https://github.com/standardnotes/app/commit/57ddeb3e0952303df195b6ae18e43735e6f86efc))
* show protected warning after protecting a note without protections ([9f5c640](https://github.com/standardnotes/app/commit/9f5c640bcd619ce50b4a9c7ef9660307cfabcf82))
* show sign-in/sign-up errors under input instead of alert ([#904](https://github.com/standardnotes/app/issues/904)) ([6311c68](https://github.com/standardnotes/app/commit/6311c687127cb0e19935bbf76e69e18a6e3c2a11))
* show toast before applying system color scheme ([#964](https://github.com/standardnotes/app/issues/964)) ([ff4debf](https://github.com/standardnotes/app/commit/ff4debfeb8d8b60cb132d8eccb4cf385a527b001))
* show warning when protecting a note with no protection source ([ef3a962](https://github.com/standardnotes/app/commit/ef3a962d788c4d1c375ed0fee28ce92da5a914de))
* show/hide search options based on focused element ([c2ba112](https://github.com/standardnotes/app/commit/c2ba11238c581494de17c201787e9f1ed56c2d9f))
* slim account menu and icon buttons ([#655](https://github.com/standardnotes/app/issues/655)) ([0e5692d](https://github.com/standardnotes/app/commit/0e5692d8ab637c811d029edf1b89dfca4999da93))
* snjs app groups ([#468](https://github.com/standardnotes/app/issues/468)) ([2b6abee](https://github.com/standardnotes/app/commit/2b6abeebfcb9ab99ef853020f79c5a4b6b6200f9))
* SNJS preferences ([aca5ad0](https://github.com/standardnotes/app/commit/aca5ad0dfa9cb45a5864921a87202ef4ab0d727f))
* snjs upgrade and fixes ([82ee097](https://github.com/standardnotes/app/commit/82ee0974c1a94a09e71558edbb94f65283d9f663))
* snjs with auto integrity resolution ([#912](https://github.com/standardnotes/app/issues/912)) ([ae5b182](https://github.com/standardnotes/app/commit/ae5b182ac1afae040ba2dad119fe51c7336c7733))
* sort files by name ([#1001](https://github.com/standardnotes/app/issues/1001)) ([99d83af](https://github.com/standardnotes/app/commit/99d83af3ba8d1bbe88dfed9027defb77ea0fe923))
* sort note cell tags alphabetically ([#848](https://github.com/standardnotes/app/issues/848)) ([cc21691](https://github.com/standardnotes/app/commit/cc2169152eeb151c4b256ea944c567af8bdb2846))
* styles package ([#1074](https://github.com/standardnotes/app/issues/1074)) ([3100327](https://github.com/standardnotes/app/commit/31003276b73d3e89824bc002fe616fa055e918c4))
* subscription info in preferences ([84ba497](https://github.com/standardnotes/app/commit/84ba497857db1afbbbefa556fc44cf28d69027d9))
* switch from npm to yarn ([#500](https://github.com/standardnotes/app/issues/500)) ([993d241](https://github.com/standardnotes/app/commit/993d241c724fe286a71697f94c75117430d0339e))
* switch to notes view when creating new note ([#1058](https://github.com/standardnotes/app/issues/1058)) ([4aacdda](https://github.com/standardnotes/app/commit/4aacdda51c5489ccf003c2a4c6480b052895f06d))
* toast package ([#1073](https://github.com/standardnotes/app/issues/1073)) ([6d0b6e9](https://github.com/standardnotes/app/commit/6d0b6e9018b2a612b8df4827336883fe04033128))
* toggle move to trash to delete permanently on alt key down ([44bf907](https://github.com/standardnotes/app/commit/44bf907aa425ffb48a62424514a8ffeab25be20b))
* two factor authentication segment in preferences with mocked state ([#600](https://github.com/standardnotes/app/issues/600)) ([d9c5fd5](https://github.com/standardnotes/app/commit/d9c5fd51292a3d8b9a2998ea60a6e1c4feb1cf87))
* untagged notes smart view ([60bddd0](https://github.com/standardnotes/app/commit/60bddd0f4159a1aa30ce74db462c6c0315e55674))
* Update "Change Email" and "Change Password" modal designs ([#714](https://github.com/standardnotes/app/issues/714)) ([4f56c45](https://github.com/standardnotes/app/commit/4f56c453cb38faf51f080b98b29983c7439a5a7d))
* update email for help and feedback ([#648](https://github.com/standardnotes/app/issues/648)) ([f12bb7b](https://github.com/standardnotes/app/commit/f12bb7b7e8dea4ef79dc28e4b47e26d67b933b5c))
* update line height and width of note size warning text ([#852](https://github.com/standardnotes/app/issues/852)) ([7f5f0d9](https://github.com/standardnotes/app/commit/7f5f0d9d17922a4b403a0a400cdccc3e9ab1cb42))
* update note type menu design ([#1032](https://github.com/standardnotes/app/issues/1032)) ([9524a83](https://github.com/standardnotes/app/commit/9524a83ec32bc630b03034d9b88ffa8b6513a478))
* Update notes list options menu to new design ([#687](https://github.com/standardnotes/app/issues/687)) ([397e496](https://github.com/standardnotes/app/commit/397e4963bd2ae796999aaa3f8bfbbed63d9c6089))
* updated "note editing disabled" design ([#1033](https://github.com/standardnotes/app/issues/1033)) ([cb6a81a](https://github.com/standardnotes/app/commit/cb6a81afd670e4f9d44e7f8727ea0eea602f7243))
* upgrade to latest active node LTS version ([3660848](https://github.com/standardnotes/app/commit/36608487ce53169506b3297536a699adc0da7537))
* upload prompt on add button click in FilesView ([#1053](https://github.com/standardnotes/app/issues/1053)) ([501da8e](https://github.com/standardnotes/app/commit/501da8ecc675e4720d5def57d04ae91c50173778))
* Use border-main ([#721](https://github.com/standardnotes/app/issues/721)) ([42b3cf5](https://github.com/standardnotes/app/commit/42b3cf5750fe005a317fb129afcbdb8bd2894199))
* use existing change password wizard in preferences ([#639](https://github.com/standardnotes/app/issues/639)) ([8464824](https://github.com/standardnotes/app/commit/8464824c610018b602fee1c868007af94bdf4a32))
* use improved style calculation for change editor submenu ([#899](https://github.com/standardnotes/app/issues/899)) ([4db8ca8](https://github.com/standardnotes/app/commit/4db8ca8bddbf19cac0d099b6f1f3e4552d9b63ca))
* Use lighter border on Dropdown ([e71c5cc](https://github.com/standardnotes/app/commit/e71c5cc85d41f080894f8725f90b6947ba5c94d5))
* Use Menu component in the general account menu ([#698](https://github.com/standardnotes/app/issues/698)) ([f494924](https://github.com/standardnotes/app/commit/f4949249f25bcbe60e7608f50517ad82e44b56f9))
* Use menu-border instead of menu-border-color ([#731](https://github.com/standardnotes/app/issues/731)) ([2866143](https://github.com/standardnotes/app/commit/28661436c5673504bf17df3e245a47dc59c0e363))
* Use menu-border-color ([#729](https://github.com/standardnotes/app/issues/729)) ([9d4172b](https://github.com/standardnotes/app/commit/9d4172bf7a4fbea23f2d35f4665a17eab3f44955))
* Use new design for signed out pane in preferences ([#734](https://github.com/standardnotes/app/issues/734)) ([f6ca7ef](https://github.com/standardnotes/app/commit/f6ca7ef2b1f358f145e9123372f714557dd4d65a))
* use new zip.js module for backup ([#929](https://github.com/standardnotes/app/issues/929)) ([66c9b26](https://github.com/standardnotes/app/commit/66c9b26962aabba69a49a4e1d9e6e2536bc0537c))
* use opacity for overflowed tags animation ([1aebe44](https://github.com/standardnotes/app/commit/1aebe44dcdd602903bb4f906459d68f2c9575aca))
* use panel width event instead of ResizeObserver ([b7c2fa0](https://github.com/standardnotes/app/commit/b7c2fa0b60a77195b8c8f0c7f6e62084437df248))
* use pencil off icon for note bar ([15db476](https://github.com/standardnotes/app/commit/15db4767f5228c20b17bbf3a1b5f48aaa855edde))
* use snjs tag notes index for note counts ([#810](https://github.com/standardnotes/app/issues/810)) ([5e07697](https://github.com/standardnotes/app/commit/5e0769745cd6c6a524dfb8df7316d6d38f8bdab8)), closes [#811](https://github.com/standardnotes/app/issues/811)
* use SNJS userCanManageSessions ([7c69cce](https://github.com/standardnotes/app/commit/7c69cce7b78eaa8adc3494712abd2a3122ebf4b4))
* use stylekit fonts for the editor ([5cb3bbf](https://github.com/standardnotes/app/commit/5cb3bbf4359fd8a36a0db6f1df0c06651abbd6d3))
* use tint color for pref section headers ([754a189](https://github.com/standardnotes/app/commit/754a1895320fddf1b4f559f2a580a6a023bd84ac))
* Use toggle switch for layerable themes in quick settings menu ([#712](https://github.com/standardnotes/app/issues/712)) ([5da5104](https://github.com/standardnotes/app/commit/5da51048bffab3044c09fb3972cd8552f53d1f62))
* vaults ([#927](https://github.com/standardnotes/app/issues/927)) ([57469d6](https://github.com/standardnotes/app/commit/57469d6b2dba431d3d333b9f3047d03d45a8d519))
* visual indicator for selected tags and remove them when re-clicking ([437aa40](https://github.com/standardnotes/app/commit/437aa40d7a2561f6cc8b1a31f696a099eb32f0df))
* wait 1ms before menu collision detection ([#859](https://github.com/standardnotes/app/issues/859)) ([9c046a3](https://github.com/standardnotes/app/commit/9c046a389059ead66a3f207c35e482c297b4f1fc))
* warning for protected note without protection ([cc474da](https://github.com/standardnotes/app/commit/cc474da0c3bae7c07c45e6b12ec343866b084c6d))
* when creating a new note, focus on title instead of body ([b3e8d73](https://github.com/standardnotes/app/commit/b3e8d73a9472d71ede00899088748e9698df9dfd))
* when removing a tag, remove descendants as well ([b036174](https://github.com/standardnotes/app/commit/b036174d11b4d0a903b538abf858c5f4fc710bd5))
* **wip:** components monorepo ([#1082](https://github.com/standardnotes/app/issues/1082)) ([e3d6001](https://github.com/standardnotes/app/commit/e3d6001a178e11e619ca724b2b155b7c0405c023))
* wrap search option bubbles if not enough space ([#918](https://github.com/standardnotes/app/issues/918)) ([be6a9fd](https://github.com/standardnotes/app/commit/be6a9fdb34f297891b98e6dbef19fc0b101009a9))


### Bug Fixes

* 'Spellcheck' option removes note editor from view ([72de951](https://github.com/standardnotes/app/commit/72de9516b8b740756236d82301f22e681dbec3c7))
* "file can't be previewed" flashing ([#993](https://github.com/standardnotes/app/issues/993)) ([b594aae](https://github.com/standardnotes/app/commit/b594aae8b97dd1a59ccebb997813e34582c09975))
* "Tools" preferences' toggles not showing correct initial state ([#689](https://github.com/standardnotes/app/issues/689)) ([474f1e6](https://github.com/standardnotes/app/commit/474f1e60e3bf313aad47b8cd2ef4b41494f5e06f))
* [#363](https://github.com/standardnotes/app/issues/363) ([fb275ab](https://github.com/standardnotes/app/commit/fb275ab2e0b569c744cb7e63d3e3f6fe0a353e9a))
* Account switcher icon proportions ([#783](https://github.com/standardnotes/app/issues/783)) ([94b9ff5](https://github.com/standardnotes/app/commit/94b9ff5032586b0ee53500b87d68b236debcb0ef))
* actions not loading ([#448](https://github.com/standardnotes/app/issues/448)) ([4b173bd](https://github.com/standardnotes/app/commit/4b173bdf643014a7136a8b21daa45743c45fe598))
* activate cached themes without entitlement check ([b8e242c](https://github.com/standardnotes/app/commit/b8e242cbee8a30318c5c3fddf5a29016dd72da9f))
* activate themes on desktop ([92b223d](https://github.com/standardnotes/app/commit/92b223d35a282578e819148195eacf0a743efb43))
* actually disable backup buttons if the user is not entitled ([#955](https://github.com/standardnotes/app/issues/955)) ([3ca7102](https://github.com/standardnotes/app/commit/3ca7102fd0c0d73567cd2afa86a00112dd0fd27f))
* actually display tags extension ([405ac65](https://github.com/standardnotes/app/commit/405ac65be41248fdd68c0f4b22551bd349086ad4))
* add ability to subscribe without account ([#722](https://github.com/standardnotes/app/issues/722)) ([e1e38c6](https://github.com/standardnotes/app/commit/e1e38c65db39f6903605ebf5426cb2a9b96b4f9d))
* add arrows navigation for tag hint ([a9f0c6f](https://github.com/standardnotes/app/commit/a9f0c6fd2fa07eba418b70f7147ad9e90daa0a42))
* add border to generated 2fa QR code ([#749](https://github.com/standardnotes/app/issues/749)) ([ba3c584](https://github.com/standardnotes/app/commit/ba3c58457a718aef7cae2a949842d63e3ddaa96a))
* add cannonical tag for the .COM TLD ([c382039](https://github.com/standardnotes/app/commit/c3820391db4d6fe5c5b47178ee416dde0826b6d6))
* add close on blur to overflow menu dropdown ([49788c4](https://github.com/standardnotes/app/commit/49788c436ce7ec76e742a90e4a871da941f73691))
* add close on blur to search options dropdown ([59737f4](https://github.com/standardnotes/app/commit/59737f43584a07409ef93268c9cb3c92101a3394))
* add close on blur to tags dropdown ([f433576](https://github.com/standardnotes/app/commit/f43357693028725a2aab583492fdd4c719ba547c))
* add delete permanently option, restore icon and show alerts for locked notes ([02249eb](https://github.com/standardnotes/app/commit/02249ebacad779260ec7873192d928023fe24c90))
* add dependencies array to `useEffect` so that it doesn't run on every render ([205c48b](https://github.com/standardnotes/app/commit/205c48b0e05c3b30d36e4d64f0a625f7cb90abee))
* add desktop bundle variant ([6f8543b](https://github.com/standardnotes/app/commit/6f8543b6e5a9e9420b8d2f1b4b86d90a709c02f0))
* add ellipsis overflow to tag text on note options ([75cefc1](https://github.com/standardnotes/app/commit/75cefc122ecb0f91026ce7de34515efd497d6b71))
* add env var for disabling new relic browser monitoring ([e43636b](https://github.com/standardnotes/app/commit/e43636bf18335a13b7883658af4124e0b3a7627b))
* add Firefox-specific font smoothing properties ([844e853](https://github.com/standardnotes/app/commit/844e853afda23574bd063c30933c5592f1175c90))
* add flag to sandbox so that action bar can save notes in chrome ([80b4b53](https://github.com/standardnotes/app/commit/80b4b530ee05f2b874ac22ffa7a3862ad818ce1e))
* add logs and traces correlation for datadog ([a5860ff](https://github.com/standardnotes/app/commit/a5860ff293b51ef57adbf7b1394b5d830ea16b0c))
* add missing git submodules initialization on ci ([98adaec](https://github.com/standardnotes/app/commit/98adaeccc8518bbeda1ec4f0c0c5658bc2db0165))
* add missing key ([c230cde](https://github.com/standardnotes/app/commit/c230cdee812d320a6ea55b4274f486f9544e0c8c))
* add missing placeholders for submodules ([#516](https://github.com/standardnotes/app/issues/516)) ([2cbc7a0](https://github.com/standardnotes/app/commit/2cbc7a08e55984096cfcf6981ee1544b7f683628))
* add option to dispatch beta deployment ([a63f6ca](https://github.com/standardnotes/app/commit/a63f6ca6b2f97e35cffe195ccff56ed71ce28090))
* add rel="noreferrer" to bugsnag links ([83eb0bd](https://github.com/standardnotes/app/commit/83eb0bd76c0963527fe7416e23aaf84201534150))
* add robots.txt dependant on the environment ([c1e3d32](https://github.com/standardnotes/app/commit/c1e3d32e1616c730ee8edf70e67bf52462c44326))
* add streamItems event listener for tags ([9aa2021](https://github.com/standardnotes/app/commit/9aa2021e1173ab1c626baddece42dde196ba8bf0))
* add sync after adding tag ([ee975df](https://github.com/standardnotes/app/commit/ee975df6d3a45ebb1e4db6a0364897051f3fa43c))
* add type checking before deploying changes to master ([83bf5d7](https://github.com/standardnotes/app/commit/83bf5d7192ca9b665caba5a1cd06fb71fe59b881))
* adjust footer element height so it doesn't produce a scrollbar ([#663](https://github.com/standardnotes/app/issues/663)) ([bf37633](https://github.com/standardnotes/app/commit/bf3763300af60ee83136b0f6f1200fd6236a7e29))
* adjust layout for all zoom values and font sizes ([a72815a](https://github.com/standardnotes/app/commit/a72815acbd63eaf7a68f6e96554d85ade627c779))
* alertService.confirm ([875d4f1](https://github.com/standardnotes/app/commit/875d4f1fc0c4b7301fd37c92f97a859ba97856c5))
* allow experimental editors if component is installed regardless of feature state ([8db127b](https://github.com/standardnotes/app/commit/8db127b79813169ed85f55e3935293364fc0e301))
* allow switching to plain editor when another default editor is set ([23860e0](https://github.com/standardnotes/app/commit/23860e0902709d47358f5d9b46ecaa26955449a2))
* allow users to disable any active cloud integration even if they are not entitled to cloud backups ([#870](https://github.com/standardnotes/app/issues/870)) ([80cc37f](https://github.com/standardnotes/app/commit/80cc37fbd437bca44a6a59dfee0115bf1eeaefbd))
* always create a template note ([27ec6f9](https://github.com/standardnotes/app/commit/27ec6f9b997bae780d3979c8996b866c4daca2e5))
* always show archived notes when active tag is archive tag ([4ae680e](https://github.com/standardnotes/app/commit/4ae680e936f04921b1e0b7f1181dbd67798a79ab))
* always show placeholder note in empty "all notes" list on start ([aeafe8c](https://github.com/standardnotes/app/commit/aeafe8c7c1ed57e31b45917cd70416fe2ba92689))
* always show title for revision previews ([2f720d3](https://github.com/standardnotes/app/commit/2f720d39f0a0bb5398b51d4443398819ea06441f))
* app column layout ([ed729ab](https://github.com/standardnotes/app/commit/ed729ab4ef243eb9bb191d148ec5d60fa34ccc77))
* application namespace for datadog trace collection ([af7da1d](https://github.com/standardnotes/app/commit/af7da1d79cb6cd3101da6fd5e4fa0d425a5ceb41))
* apply active themes after features updated ([3d6c10b](https://github.com/standardnotes/app/commit/3d6c10b70eb56cc5ab0be4e0cc25a58d5b590da1))
* appropriate wording for passcode prompt when registering ([1595ea5](https://github.com/standardnotes/app/commit/1595ea518e4b0dab4f7345c16491468238f3e3af))
* argument misordering ([3d3ca9b](https://github.com/standardnotes/app/commit/3d3ca9b94ac78dc0805f26ebc644bf23e52e0e30))
* asset pipeline ([9b06e00](https://github.com/standardnotes/app/commit/9b06e00ba84f6fa63b30c7beb90b37827e0e3899))
* assign active tag when creating a new note ([d49d2e9](https://github.com/standardnotes/app/commit/d49d2e996b47738252fdb8b44cd53b6ea882b9cb))
* associate new note with default editor ([54e5fc9](https://github.com/standardnotes/app/commit/54e5fc918478eb53c04a7b0b542bc07a175cbfa1))
* associate note with selected tag when saving with editor ([507223c](https://github.com/standardnotes/app/commit/507223c5b738948176add336a1d00231d2ce6bb7))
* async device interface keychain methods ([a6e6044](https://github.com/standardnotes/app/commit/a6e6044e5938c310d1bea4c10883495b22f689eb))
* autolock polling for desktop ([184ce19](https://github.com/standardnotes/app/commit/184ce19ad70cae6a902f0846b1e6a9c50d645b5e))
* avoid changing selected note when editing archived or trashed note from search results ([0b8cd1b](https://github.com/standardnotes/app/commit/0b8cd1b7b4eaa17634a97d4eb5c0e535096b68ce))
* avoid event propagation when deleting a tag ([3d0c8d5](https://github.com/standardnotes/app/commit/3d0c8d5cce18c999a6245ba979b54591e5dc6efb))
* avoid tag menu opening behind footer ([eb929f9](https://github.com/standardnotes/app/commit/eb929f9e874efd1147876631180e3586d44cfc0a))
* background color to use for selected note cell ([131f13c](https://github.com/standardnotes/app/commit/131f13c5580db2438df44f3442414b3052acc34c))
* base keyboard modifier state on latest event ([8f4f188](https://github.com/standardnotes/app/commit/8f4f1887330ac2ed071f8a2a7a1f0120319d12e2))
* begin purchase flow for logged in user ([#697](https://github.com/standardnotes/app/issues/697)) ([ebe0d26](https://github.com/standardnotes/app/commit/ebe0d26d0dcc560c43af1d88f799a05525608777))
* beta workflow name ([8d8be26](https://github.com/standardnotes/app/commit/8d8be260282dbaf59e4b9487a52262637b2f4a9e))
* better handle import errors ([553f057](https://github.com/standardnotes/app/commit/553f057dbfcdd7bb45888de8757919af8a6e1648))
* better protected notes handling and allow shift-clicking note up in the list ([6a6e170](https://github.com/standardnotes/app/commit/6a6e1708d61f5a7463fa87030bf73fbfeacfa535))
* better style and copy for challenge modal ([93deb92](https://github.com/standardnotes/app/commit/93deb92463f8cd4243d84fde761c0f3eaf6a8e0c))
* better subscription state text ([fbafc13](https://github.com/standardnotes/app/commit/fbafc136e87b30c0473280277a3336b819e3cfe0))
* bind modals to application lifetime ([94a8241](https://github.com/standardnotes/app/commit/94a82412bd157cfab5a03cf8f1297844bd3112ef))
* break long extension url text when it exceeds container width ([#741](https://github.com/standardnotes/app/issues/741)) ([b2877a5](https://github.com/standardnotes/app/commit/b2877a5435cf0fbdb769bfbe5c097091d78f751d))
* broken AlertService call ([0e44cce](https://github.com/standardnotes/app/commit/0e44cce2d9cf6b933015918a07e388865374c5b1))
* browser monitoring default to false ([e93660c](https://github.com/standardnotes/app/commit/e93660c5645c6c108a62c5da4eefe20b2937f991))
* bugsnag info wording ([02d57b6](https://github.com/standardnotes/app/commit/02d57b6564b8eb932df58e9e490985c21e310f4c))
* build web app before precompiling assets ([8e4104c](https://github.com/standardnotes/app/commit/8e4104c4a58bcf712b1f99aaac2799e8f6ba402f))
* building image with extensions and batch manager ([378afdc](https://github.com/standardnotes/app/commit/378afdc4734089ac493027e4d9bf292c0ccac999))
* bundle files together when exporting a decrypted backup ([b888e68](https://github.com/standardnotes/app/commit/b888e68c5aa9853c1fa7d046c928920b22cc4337))
* button casing ([734505c](https://github.com/standardnotes/app/commit/734505c133782a2a27c3b499c7d0f673922a7268))
* calculate menus height or width depending on browser font size ([3813537](https://github.com/standardnotes/app/commit/3813537e5ce4fd02a83ab3ca02d2e6bec88e3195))
* callback methods ([18e68ad](https://github.com/standardnotes/app/commit/18e68adbb00e02afcd5e2013dff7dc15bf5f8d69))
* can't create new note inside view ([2ff9ab8](https://github.com/standardnotes/app/commit/2ff9ab8afb34b697fd12cb0cc95e40680a8a39c8))
* cancel in-progress workflows for concurrency deployment groups ([d383f2f](https://github.com/standardnotes/app/commit/d383f2f804f3321de71192b2996063ae0b96a524))
* cancel session revoking when pressing escape on confirm dialog ([d9576b4](https://github.com/standardnotes/app/commit/d9576b4afe2b5b003575c7a3503735488e6616a8))
* challenge modal button label ([#972](https://github.com/standardnotes/app/issues/972)) ([a91a1cb](https://github.com/standardnotes/app/commit/a91a1cbddd2c1f272d9127e75eafb1ab4b82de78))
* challenge modal form not submitting on enter ([fff226b](https://github.com/standardnotes/app/commit/fff226b86150228f60032a76698cef7c5b4d747c))
* challenge modal logic ([f6fb245](https://github.com/standardnotes/app/commit/f6fb24508ea5df93ca5172c7f9627c8ed0232e74))
* challenge modal styles ([#987](https://github.com/standardnotes/app/issues/987)) ([9f8c402](https://github.com/standardnotes/app/commit/9f8c402e1ad2189d4d1098e46e794a800c7e21ff))
* challenge modal: cancel instead of dismiss when pressing escape ([611ca2f](https://github.com/standardnotes/app/commit/611ca2fd1308d998165c0a6e5c99ae8554dd1609))
* Change bg-neutral to bg-border ([#723](https://github.com/standardnotes/app/issues/723)) ([2fdb748](https://github.com/standardnotes/app/commit/2fdb748babefb476207e664d03a1cc8b00ab562e))
* change editor menu position on large viewport ([#857](https://github.com/standardnotes/app/issues/857)) ([3b830b0](https://github.com/standardnotes/app/commit/3b830b00d904a697fa73920783913e1f0829c18c))
* change filename of secret key download ([#610](https://github.com/standardnotes/app/issues/610)) ([eb6d8c9](https://github.com/standardnotes/app/commit/eb6d8c9cbaa8228b8e067e64295ab695879e6ccb))
* change lock mentions to prevent editing ([0330497](https://github.com/standardnotes/app/commit/0330497d1deb3ac6d59fdd126a4ea3b65381bd09))
* change naming of publishing feature branches to beta branches ([eb4c8d0](https://github.com/standardnotes/app/commit/eb4c8d00914310afcc651c36e1d279d904d6aced))
* change setHost to setCustomHost ([5ebdd4f](https://github.com/standardnotes/app/commit/5ebdd4f13b40b5731c5c3ead4e07486abb66323a))
* change undefined css class ([94199fb](https://github.com/standardnotes/app/commit/94199fb6b53ba19e77b2b43f47d717898c085ba1))
* change version number to 3.6.0 ([7df39e7](https://github.com/standardnotes/app/commit/7df39e796cd90bb090482ad9ffd3f94c430229a5))
* check backup file version first before importing ([6f798e3](https://github.com/standardnotes/app/commit/6f798e3ba9a7f565da022916e8e50546c0fb5cf2))
* check if ref is present before setting overflow position ([a071d4c](https://github.com/standardnotes/app/commit/a071d4c9d025b91f89119586aa9b81a7615a60d1))
* check if single note is already selected before selecting ([2f77985](https://github.com/standardnotes/app/commit/2f77985927dec4addef5fbdd097a682e7536513d))
* check if user is entitled to theme before activating it ([#867](https://github.com/standardnotes/app/issues/867)) ([ca3112d](https://github.com/standardnotes/app/commit/ca3112dcaff80efb41124fe0f64c796c3acb1c68))
* check onKeyUp instead of onKeyDown ([1576da0](https://github.com/standardnotes/app/commit/1576da01c4399be83db9521fd0882a8ee29a0ded))
* circular dependencies ([#1040](https://github.com/standardnotes/app/issues/1040)) ([0e25885](https://github.com/standardnotes/app/commit/0e258856d80f5b8899bf655621b95a3bf95156fe))
* **CI:** Use better typescript job name ([d1bfb49](https://github.com/standardnotes/app/commit/d1bfb49ead2a06946a9508f57301b9e86731db0e))
* clear desktop search highlight when tag is selected ([2f53720](https://github.com/standardnotes/app/commit/2f5372008cbc146375bf77a7181e3b5b5c93db4f))
* clear note change listener on editor vie deinit ([36d8b81](https://github.com/standardnotes/app/commit/36d8b81d2f01c554fdf2a5ea8f37134024c376eb))
* close dropdown after creating a tag ([53a55d4](https://github.com/standardnotes/app/commit/53a55d4bc7d90c1cb6ce90af6f1fa7af6ad190ab))
* close history menu when other menu item is clicked ([5180638](https://github.com/standardnotes/app/commit/518063829fd5859fdf85610f9faea1c1a57120c1))
* close tags submenu when closing menu ([ecd9dd4](https://github.com/standardnotes/app/commit/ecd9dd432444dd599097dd925f3e0d53025db0af))
* cloudlink url ([4153c81](https://github.com/standardnotes/app/commit/4153c816382a31e82866435b44cf246825657c40))
* compile assets ([5ee44d5](https://github.com/standardnotes/app/commit/5ee44d56c2120afdfe42b5b413c3687f0748172e))
* compile error ([d6f7779](https://github.com/standardnotes/app/commit/d6f7779a76c158157d2e2f96f4910c4afeaf9188))
* component expiration for custom extensions ([76258f5](https://github.com/standardnotes/app/commit/76258f546202bb933747ed5c44fad7ae92da0337))
* component viewer stream context item issue ([e79f326](https://github.com/standardnotes/app/commit/e79f326e5b0e58f6124e809bcc0f301205294b98))
* components copy script ([ea3b82e](https://github.com/standardnotes/app/commit/ea3b82e73af586f0b7c3bac99bfbd2b680d0b0e6))
* components path ([bc02754](https://github.com/standardnotes/app/commit/bc02754534426cad8fc788f6d7899e4ccb24aa68))
* componentView: do not throw on inactive editors ([814d41f](https://github.com/standardnotes/app/commit/814d41f9b272306dd2519a51ba0c7312bdc47089))
* consistent alignment for inputs in modals ([e201d43](https://github.com/standardnotes/app/commit/e201d438c1ae9ea388b4bcb9f70ce7c384ae4bf1))
* consistent challenge/privileges modal centering ([12d77af](https://github.com/standardnotes/app/commit/12d77afd9117ea914423b7635c432b588bb4eab1))
* convert bugsnag to static import ([63233fc](https://github.com/standardnotes/app/commit/63233fcd52ac6b62ddc90a481895c3ec33d42a64))
* copy improvement ([ac9c19d](https://github.com/standardnotes/app/commit/ac9c19d68169203f5e64e6791ba6271eb4dc8307))
* correct monospace state name ([ce40cc4](https://github.com/standardnotes/app/commit/ce40cc4ba17a01166413e907db5b65913c233c45))
* correct snjs import ([935ced9](https://github.com/standardnotes/app/commit/935ced9be63479abe8d8ad5384da5a82f361a7d4))
* correct tags ordering ([ded5b51](https://github.com/standardnotes/app/commit/ded5b510237a818f69541f5dfe2a24395aca9625))
* correctly check for pushState function ([52f8acf](https://github.com/standardnotes/app/commit/52f8acfb0e9992bb5ec311a074ddb2bf08d91e07)), closes [#523](https://github.com/standardnotes/app/issues/523)
* correctly check if cloud backups are available for the user ([#845](https://github.com/standardnotes/app/issues/845)) ([8388265](https://github.com/standardnotes/app/commit/8388265493b4b6bb59af3aca0eb5bb912ada8e46))
* correctly create decrypted and desktop backups ([923d14b](https://github.com/standardnotes/app/commit/923d14b7876a17199c45e78399682fea0c0b6922))
* correctly implement AlertService.confirm API ([a9aba87](https://github.com/standardnotes/app/commit/a9aba87033a3f1852d7904dc5b181364491a1dde))
* correctly select displayable note ([5bd35a5](https://github.com/standardnotes/app/commit/5bd35a5797cb4b5431fdf399b50a1913d7fb83ab))
* correctly set note values when they change ([91b53d3](https://github.com/standardnotes/app/commit/91b53d34bf8d0728eb90a564765a205b3172c1be))
* correctly set/change passcode ([a63bfd8](https://github.com/standardnotes/app/commit/a63bfd8c0afa1553390966b4e2f65b4d3dc17636))
* correctly start and stop autolock timer ([c705b5b](https://github.com/standardnotes/app/commit/c705b5b4dbbae84231058cb2e52a0449df0cf5ce))
* correctly start and stop autolock timer ([9036beb](https://github.com/standardnotes/app/commit/9036beb3f370a95c2d190754bd1009658c01cdeb))
* correctly switch between editors ([7521847](https://github.com/standardnotes/app/commit/75218474449b7f9bb57003eddcdc68fc425d67fa))
* correctly switch between editors ([ee837ea](https://github.com/standardnotes/app/commit/ee837ea077a9d079ca346a26c3891229ae082fdd))
* correctly update `Merge local data` checkbox' state ([9de1b30](https://github.com/standardnotes/app/commit/9de1b302912acb40ab74ca5d55222f74da374f3f))
* crash issue when searching with undefined tag title ([1f0f361](https://github.com/standardnotes/app/commit/1f0f361d8b4e68c90eb70b810759812a1aa5016b))
* creating placeholder note redirects focus ([#601](https://github.com/standardnotes/app/issues/601)) ([08ab1d0](https://github.com/standardnotes/app/commit/08ab1d009d2ec99d763a27111eb38fd35412a249))
* deactivate themes on deinit ([8377133](https://github.com/standardnotes/app/commit/83771339a5cf2df2ad04bfa9c1b908df6876f5b0))
* deactivate themes on signout ([2ce981a](https://github.com/standardnotes/app/commit/2ce981a1ea6ba5b185c903ad672487bcf2a2745a))
* deactivate themes when switching accounts ([d920bf6](https://github.com/standardnotes/app/commit/d920bf663f0322932582613352c1810c7e3f6119))
* debounce editor reloading to handle fast fire ([06fae3a](https://github.com/standardnotes/app/commit/06fae3acda0909ec1ad03771be978773fa9ba178))
* debounce note status updates properly ([1dc2883](https://github.com/standardnotes/app/commit/1dc28832ccd47f06ef2c14b7525a03f82f6c5a2d))
* decorated input text color ([#968](https://github.com/standardnotes/app/issues/968)) ([369ece1](https://github.com/standardnotes/app/commit/369ece1a505e1f81022efb9b504a18ad532a4cc4))
* decrypted backup import file name ([af3de36](https://github.com/standardnotes/app/commit/af3de363616b842c9dcccb5ba2c790c4bad597b7))
* default to feature status entitled to avoid temporarily flashing error ([6f3a749](https://github.com/standardnotes/app/commit/6f3a749e52a91dd9966fc52ac0247c5cd6575d6c))
* delete auth/keyParams from decrypted backup ([f29682c](https://github.com/standardnotes/app/commit/f29682c4a9f2b8dd1d40bdd91423f8da89f4cc5c))
* delete autolock pref on passcode remove ([6f9b669](https://github.com/standardnotes/app/commit/6f9b669523d06996b8011361fb96614be8274a06))
* delete unused removeAltKeyObserver from editor view ([7849de7](https://github.com/standardnotes/app/commit/7849de7e8f3d44bfb85facb678cf585fe7c1ab13))
* deregister stream observers on editor deinit ([f9733f8](https://github.com/standardnotes/app/commit/f9733f8dac997737d0d0ab8b2addacb1e9ec48dc))
* deregister tags component when needed ([2055c6d](https://github.com/standardnotes/app/commit/2055c6d55dcd1231a71eb370b7721162edf4ffbd))
* desktop ([#1080](https://github.com/standardnotes/app/issues/1080)) ([6801c3d](https://github.com/standardnotes/app/commit/6801c3dd3b931d9bfa3987c7867282da63c65266))
* desktop interop ([35fe78e](https://github.com/standardnotes/app/commit/35fe78e49e83e6eb346dba7e092b984ad9327009))
* **desktop:** move search text highlight logic after update of notes to display ([d7cee97](https://github.com/standardnotes/app/commit/d7cee977dd7b6b57d802a17d37051b315b88bc8e)), closes [standardnotes/web#263](https://github.com/standardnotes/web/issues/263)
* **desktop:** search highlight on pagination ([c2ffe01](https://github.com/standardnotes/app/commit/c2ffe0102aab095acbd247cc3b261c149499e2e0)), closes [standardnotes/bounties#20](https://github.com/standardnotes/bounties/issues/20)
* destroy editor component on show protected overlay ([0729aa6](https://github.com/standardnotes/app/commit/0729aa692635fd30f7e8b8ab11c851064c204075))
* deterministically sort footer badges ([67e2d11](https://github.com/standardnotes/app/commit/67e2d11d3fe11b51fbd7a239e81dd52806e7631d))
* dev account server ([c232a5e](https://github.com/standardnotes/app/commit/c232a5e3c6a2acd99ebee85bad130ca9a072edf5))
* dev helpers ([b6dace0](https://github.com/standardnotes/app/commit/b6dace049c9a6826f7a659ac8e00fa0f02f990bf))
* dimmed banner colors ([#1043](https://github.com/standardnotes/app/issues/1043)) ([4e621ca](https://github.com/standardnotes/app/commit/4e621cadde07f6e1cefa82a6030beb7fc3d570cf))
* dimmed tags issue on safari + increase tag density ([072af12](https://github.com/standardnotes/app/commit/072af12ffec2050f29ee7c49b3786730ef1a81a3))
* disable account switcher ([bd7f572](https://github.com/standardnotes/app/commit/bd7f57205a9143fec39d9fa3e159658f9dce92fe))
* disable autocomplete on editor textarea ([6489628](https://github.com/standardnotes/app/commit/648962873105782c7a3342f349c8b18582137c20))
* disable change email feature ([5b91e41](https://github.com/standardnotes/app/commit/5b91e41e32fb4774f83b7b2c6c5fcc16e2d7ca73))
* disable delete note shortcut for inputs ([1be87cb](https://github.com/standardnotes/app/commit/1be87cbef8819f2a946a7599a2c39ee478982f9b))
* disable deprecations warnings ([7de7f52](https://github.com/standardnotes/app/commit/7de7f52394c4f99d7343dcbec91cd778b8bc6f62))
* disable editor rendering in history previews ([c472891](https://github.com/standardnotes/app/commit/c472891d7807b1e0dcb39f0298d64ed5a80779ee))
* disable features for public beta ([62df25d](https://github.com/standardnotes/app/commit/62df25d7d83e5ad4eec9458dd0783cacac6f2968))
* disable unimplemented prefs sections ([7434a87](https://github.com/standardnotes/app/commit/7434a870bdffa0001e0bf8a7d4c702359c4d16f4))
* disable v4 feature checks ([4b21083](https://github.com/standardnotes/app/commit/4b210832295044d78a502385ad06a3d12e431631))
* disallow creating empty tag ([c4db37f](https://github.com/standardnotes/app/commit/c4db37ff94f69ce782bb3ee42f851a0e05eef9f2))
* disallow robots from accessing the app ([a6aa66e](https://github.com/standardnotes/app/commit/a6aa66eeddabddd74529815e9ff8cb0e677b671d))
* display correct app version for desktop ([dfde84c](https://github.com/standardnotes/app/commit/dfde84c2f6d256e49d6c4e749ff2d7ff5f79cc6f))
* display correct app version for desktop ([954f399](https://github.com/standardnotes/app/commit/954f39992db1692a73ff4c7adfd3e877318fef5e))
* display error message if backup file is from an unsupported version ([#463](https://github.com/standardnotes/app/issues/463)) ([148f7d7](https://github.com/standardnotes/app/commit/148f7d76039941f3a5be2d7b18cb27232c36c762))
* display full tag path in add tags menu ([453488f](https://github.com/standardnotes/app/commit/453488f752c10d5d3462dd2083e93ca237cc2dad))
* display note history action items without throwing ([368eb4c](https://github.com/standardnotes/app/commit/368eb4c637044e68a40892f38a7a7f25ddc5e2e1))
* display offline hosted only for third party features ([4c8d593](https://github.com/standardnotes/app/commit/4c8d59336bb577978f9533fb0a50f2f30cc7b3a2))
* display session & remote history entries ([622963d](https://github.com/standardnotes/app/commit/622963d04e16fe7927d5c448d5e0d7f2c87bb28a))
* disregard modifiers for note selection if user hasn't triggered the action ([3823836](https://github.com/standardnotes/app/commit/3823836863781f930fce29d67059fb23242a85fa))
* do not attempt to load bugsnag if no api key is set ([a812346](https://github.com/standardnotes/app/commit/a81234635fc1727c3664a74aed64fe15eedc69c1))
* do not close editor when editing an archived note ([46ab8b9](https://github.com/standardnotes/app/commit/46ab8b9e9555c43624ddfbb7d2659c9da1242438))
* do not cover more screen than necessary (title bar) with challenge modal ([04131f8](https://github.com/standardnotes/app/commit/04131f8e623d9f5c1425f55a4ca2867e66bac6e6))
* do not deactivate all themes on theme service deinit; themes should remain activated on application lock ([f9c47a1](https://github.com/standardnotes/app/commit/f9c47a10cae64cbf7b8d71d171a16d3489859f9d))
* do not display single note tags when viewing said tag ([5cd7aa9](https://github.com/standardnotes/app/commit/5cd7aa908b47340be076b58edac9bd38383c70ab))
* do not emit type declarations ([0f84a6c](https://github.com/standardnotes/app/commit/0f84a6cbad9784892571255589c4fcc4f64a6d0d))
* do not focus title if element is not mounted ([0023447](https://github.com/standardnotes/app/commit/0023447d547ce454abd442b4151868cd733be66e))
* do not process tab key in editor when document is hidden ([929c11a](https://github.com/standardnotes/app/commit/929c11addc1abce9cfa7fb5b38a2e4f1351f8669))
* do not prompt for password with encrypted backup ([2cbff59](https://github.com/standardnotes/app/commit/2cbff5982a2867ea27a27b9400836c76177cf7f0))
* do not recreate template note unnecessarily ([4e86a2e](https://github.com/standardnotes/app/commit/4e86a2e1cb2153ade570f5c29441b81ddd5aa07f))
* do not run ruby-dependent command on install ([7f03922](https://github.com/standardnotes/app/commit/7f03922b6768cf9dc4b5f05d5a46b94732df8054))
* do not show placeholder notes in smart tags ([2609cb0](https://github.com/standardnotes/app/commit/2609cb07b7841a63e5f64a8f23cd274f4379bc53))
* do not switch notes while in the trash view ([90d1814](https://github.com/standardnotes/app/commit/90d1814d68d87116f29cc268e349141fd8dd656f))
* do not throw on invalid themes ([27affa4](https://github.com/standardnotes/app/commit/27affa4cee74565a724904be5f936c9a11a8c17d))
* docker entrypoint command interpret ([d6ac37a](https://github.com/standardnotes/app/commit/d6ac37a04ad948e238995a54935761aee4877448))
* dom nesting error ([#1066](https://github.com/standardnotes/app/issues/1066)) ([59dcca1](https://github.com/standardnotes/app/commit/59dcca18d63f4bf346fca27e87b84ef1cc0a29cb))
* don't apply system color scheme anytime any preference changes ([4923577](https://github.com/standardnotes/app/commit/492357777c23aea2538804fe2785352c2933f463))
* don't clear search query when navigating back to input ([353d46e](https://github.com/standardnotes/app/commit/353d46eb633bda2c08c84acae961cf5b5548486c))
* don't close popover when previewing file ([#1017](https://github.com/standardnotes/app/issues/1017)) ([f35a454](https://github.com/standardnotes/app/commit/f35a454614cd4e5f4bb970e57850e3d28be96405))
* don't create placeholder note when there is an active search without results ([b663faa](https://github.com/standardnotes/app/commit/b663faa49701d0dff605a9431ef2b5028139f03d))
* don't deselect active note if in user created view ([#1081](https://github.com/standardnotes/app/issues/1081)) ([2ecfcde](https://github.com/standardnotes/app/commit/2ecfcdecb4a0af20003e4b5c4e0544448f680633))
* don't get backups settings if there is no logged-in user ([#842](https://github.com/standardnotes/app/issues/842)) ([616b77a](https://github.com/standardnotes/app/commit/616b77a5f748b7d19eadc8e1660afa9a7de4fd17))
* don't include full desktop path in deeplink redirect ([8c3271b](https://github.com/standardnotes/app/commit/8c3271bcb37c832da590b25e831d4586cc512077))
* don't show context menu if note is protected ([b89cdde](https://github.com/standardnotes/app/commit/b89cdde1fcb50a39270749e44f409e392aac3f79))
* don't show dropdown if there are no results ([ff0270f](https://github.com/standardnotes/app/commit/ff0270f1acb2dfa3c58308195442a7d89e7f7abe))
* don't show empty notes view when the database is loading ([80ce580](https://github.com/standardnotes/app/commit/80ce5800a8ad06d0f4b99b8fd656ba4bebc2ff37))
* don't show entitlement modal if dragging file backup ([d47d295](https://github.com/standardnotes/app/commit/d47d2952984f898664ff78e9c6a85b73c41a5dcc))
* don't show hint if a tag already exists with that title ([6d865bc](https://github.com/standardnotes/app/commit/6d865bc04f7fa861f9b1478a49a582ecdd1f6837))
* don't show saving status if template note inserted to be interactable with advanced editor ([dbc4de9](https://github.com/standardnotes/app/commit/dbc4de9a0e75327b7f1192bf9b11b43f0faa8fdf))
* don't use lodash pull ([3b3c2d6](https://github.com/standardnotes/app/commit/3b3c2d6fe44f5026bac4a4deead3047c1d0dc7f4))
* don't validate email inputs which could be something else ([157d1a2](https://github.com/standardnotes/app/commit/157d1a2061428012df55071fdbdcf8608115255c))
* don't wait until regaining focus to lock app ([98c6078](https://github.com/standardnotes/app/commit/98c6078a0db741d35569eb695884e05c73645e75))
* download backup later in the change password process ([9541886](https://github.com/standardnotes/app/commit/9541886a2c1ea5f9e668677bcbd0cfa538c3d546))
* download success toast showing up even if download errors ([#1018](https://github.com/standardnotes/app/issues/1018)) ([9e370df](https://github.com/standardnotes/app/commit/9e370df2e83a9ac095eaed0b4e03662bf1b98fde))
* dropdown and files button ui ([#1076](https://github.com/standardnotes/app/issues/1076)) ([12f052a](https://github.com/standardnotes/app/commit/12f052a0b202df10ea55351ea4bf6232c2ecb56f))
* duplicate element id ([b1022cd](https://github.com/standardnotes/app/commit/b1022cd3c34fc35b07f5d6dfc03efff1e860ed79))
* duplicate files quota calls in preferences ([#1006](https://github.com/standardnotes/app/issues/1006)) ([e7fb9b6](https://github.com/standardnotes/app/commit/e7fb9b67f87f94e08e279db11f920d5ae51a2030))
* early return file dnd if not dragging files ([#1000](https://github.com/standardnotes/app/issues/1000)) ([63fcd3d](https://github.com/standardnotes/app/commit/63fcd3d217bf2e09a44fed424cc2f8f3b1acfdf5))
* editor not opening for single selected note after unselecting a note from batch ([a2b6c37](https://github.com/standardnotes/app/commit/a2b6c3785a3809b2d76d895745694451616c9b6e))
* editor status after changing note ([dee164f](https://github.com/standardnotes/app/commit/dee164f4a28e518342970fa6a6f8571c66acfd62))
* empty panel above 'Install Custom Extension' panel ([#709](https://github.com/standardnotes/app/issues/709)) ([403fc3f](https://github.com/standardnotes/app/commit/403fc3f29558cf26c512acf9cbc3692aafdfb0d0))
* enable_unfinished_features in ruby template ([#595](https://github.com/standardnotes/app/issues/595)) ([80d7753](https://github.com/standardnotes/app/commit/80d77537507e3af8f3df61347ad5af6e2ade1c4a))
* enable, disable, sync editor stack per note ([e280309](https://github.com/standardnotes/app/commit/e280309be6187f85620e85d70b86a12bd7925058))
* encryption section styles ([#976](https://github.com/standardnotes/app/issues/976)) ([ec8b307](https://github.com/standardnotes/app/commit/ec8b3072353008f13b51deb77e3346a5b685578c))
* encryption status title ([#643](https://github.com/standardnotes/app/issues/643)) ([52ddb49](https://github.com/standardnotes/app/commit/52ddb49bd7746eac12141e3132b403f42430e326))
* error on aborting file selection ([#951](https://github.com/standardnotes/app/issues/951)) ([9c74364](https://github.com/standardnotes/app/commit/9c74364757a6abe7712cfc36fb04af38cc2a038a))
* eslint config ([5a3b810](https://github.com/standardnotes/app/commit/5a3b810896e98741dff27c766a2dc4573b4d57ee))
* exception when locking app ([f7e9b0e](https://github.com/standardnotes/app/commit/f7e9b0ec0cb60bfad35af1b80dd68f482d1ac49d))
* exception when selected note is deleted permanently ([#1010](https://github.com/standardnotes/app/issues/1010)) ([bb4fd24](https://github.com/standardnotes/app/commit/bb4fd2449af61f161683afa0af5d0c3ae178f0a1))
* excessive autorun calls ([e12b9ec](https://github.com/standardnotes/app/commit/e12b9ecac8617c0dfa6fac31b1dc123750709372))
* experimental features not reloading after toggling ([#917](https://github.com/standardnotes/app/issues/917)) ([87631dc](https://github.com/standardnotes/app/commit/87631dcb0dea716540649c05103a29049e98c719))
* export decrypted backup for desktop in some cases ([3111dc4](https://github.com/standardnotes/app/commit/3111dc4c0be78b1f2b1c5c4140051737cab39c1e))
* export location of ElectronDesktopCallbacks ([fc3d575](https://github.com/standardnotes/app/commit/fc3d575fe0777d2f86bcdf6195784045a98a9748))
* extend editor area to full height ([bf6cfa3](https://github.com/standardnotes/app/commit/bf6cfa398e7cd67a62e9d71c76974e86be56f868))
* extension hiding + deprecation notice ([9451447](https://github.com/standardnotes/app/commit/945144734cbab6caf728071bb3a2f91432a38381))
* extension url validation ([dee60e0](https://github.com/standardnotes/app/commit/dee60e0fae4237414ef36cb1d168d90325316b6c))
* failing deploy by removing vendor step ([#930](https://github.com/standardnotes/app/issues/930)) ([bd6a883](https://github.com/standardnotes/app/commit/bd6a8836798648a330636809890e73fd2b4f3816))
* fall back to treating unknown platforms as linux-web ([e270f5d](https://github.com/standardnotes/app/commit/e270f5d98db593c8f42d8e505bfe2aa5e1f5a228)), closes [#494](https://github.com/standardnotes/app/issues/494)
* fallback to default sync server as the next version server - fixes [#577](https://github.com/standardnotes/app/issues/577) ([fbdec02](https://github.com/standardnotes/app/commit/fbdec0251f5a661467d4f96f8a92a793070a5dae))
* favicon for PWA ([b7daaef](https://github.com/standardnotes/app/commit/b7daaef2f5e3edc58c537b8e9a0778338418f6d8))
* feature id reference ([af69a02](https://github.com/standardnotes/app/commit/af69a02555f4c2f0f8102a3a255e45a07e01d884))
* file backups drag ([ed5f649](https://github.com/standardnotes/app/commit/ed5f6495aaa841744cbfb70a2f644c77c545e93e))
* file drag-n-drop issue ([#923](https://github.com/standardnotes/app/issues/923)) ([7e67061](https://github.com/standardnotes/app/commit/7e6706109723d3524eb6a8f9b42553776b44fac6))
* file list item icon alignment ([#1039](https://github.com/standardnotes/app/issues/1039)) ([51248f2](https://github.com/standardnotes/app/commit/51248f2588ca311ffcba1a91dc90bbbd531dc73a))
* file mimeType related issues ([#922](https://github.com/standardnotes/app/issues/922)) ([a1c7ad7](https://github.com/standardnotes/app/commit/a1c7ad7d7e16a8cb35f72411e598400cf8f4b616))
* file popover not closing when click inside editor ([#924](https://github.com/standardnotes/app/issues/924)) ([89c4b9a](https://github.com/standardnotes/app/commit/89c4b9a9f8d119ef4b9d033a0ca681e2edee068e))
* files popover illustration size ([#928](https://github.com/standardnotes/app/issues/928)) ([8caf343](https://github.com/standardnotes/app/commit/8caf3431761790106897e062e0a4d6dc7e185ecb))
* filesafe index path ([f55247c](https://github.com/standardnotes/app/commit/f55247ccced3a383c5728f7bb1a073ecf01386bb))
* first history entry being fetched twice ([#903](https://github.com/standardnotes/app/issues/903)) ([c184ef2](https://github.com/standardnotes/app/commit/c184ef2449044982ff27f162807f916fd16cce4a))
* fix challenge modal submission debounce ([c55946c](https://github.com/standardnotes/app/commit/c55946cb54d87459b6d91c47fd93f987e5bc4a53))
* fix ctrl+click not selecting notes ([9aa9841](https://github.com/standardnotes/app/commit/9aa9841d881bc75b08209aa7480640d13e586b01))
* Fix dropdown item colors ([db888c4](https://github.com/standardnotes/app/commit/db888c4e0246346e55c794e0fbff1babfda3b604))
* Fix dropdown list colors ([b165be2](https://github.com/standardnotes/app/commit/b165be2928f87640066fba67f7f8104440f89c14))
* fix enable editing on editor bar ([68a0e1e](https://github.com/standardnotes/app/commit/68a0e1e5bc4b3bdba9a0b798a7d01b31a24f0d44))
* fix focus on previous tag after tag deletion ([54fbb60](https://github.com/standardnotes/app/commit/54fbb606eb2f3f8de5a4b66b324cda02c79daee4))
* Fix icon colors to be more themeable ([#724](https://github.com/standardnotes/app/issues/724)) ([88cc50e](https://github.com/standardnotes/app/commit/88cc50e8b6a1f88a679857ad456a341ad344f185))
* fix mobx actions ([ca04ff4](https://github.com/standardnotes/app/commit/ca04ff43def4ea2ff48dc9ed2001778e56877d02))
* fix package.json StyleKit version ([83a813e](https://github.com/standardnotes/app/commit/83a813ed94bd2af598a0e2eed98cf3460c989613))
* fix panels that can't be expanded after collapse ([ebe38ea](https://github.com/standardnotes/app/commit/ebe38eae570bdf0c4e20e69bd36d6a1523a18306))
* fix setting demo custom host ([8ca9a3f](https://github.com/standardnotes/app/commit/8ca9a3f8f3fa072125d8e5eb1b92dd2c943d9b6f))
* fix snjs version on package.json ([b587986](https://github.com/standardnotes/app/commit/b587986a918e2ec01ee20d3305e6545eaacbc8bf))
* Fix spacing in "Help & feedback" button in general account menu ([#693](https://github.com/standardnotes/app/issues/693)) ([29138ea](https://github.com/standardnotes/app/commit/29138ea597841dc321294b308d602cecd61170ab))
* fix state and add loading state ([4125797](https://github.com/standardnotes/app/commit/41257977a7bcc52e8e80af5268782a25c888887d))
* fix tags container max width ([9be9ba2](https://github.com/standardnotes/app/commit/9be9ba2afcfc712b35410310ae94a63be93224e1))
* fix tags container width ([b54de00](https://github.com/standardnotes/app/commit/b54de00b40102eb4b9de35f96c947b15c073cecb))
* fix tags dropdown width and tags container height ([31fbf2c](https://github.com/standardnotes/app/commit/31fbf2ce35f860050fb95f595d290e491ecf1263))
* fix tags keyboard navigation ([3e76ef6](https://github.com/standardnotes/app/commit/3e76ef6b6f3fa0bc0174dc83d3a1e8baed69bbd8))
* fix tags tab navigation ([2295f5d](https://github.com/standardnotes/app/commit/2295f5d59364d8aaea4f9e818762807b2046beac))
* fix type ([bba9ce9](https://github.com/standardnotes/app/commit/bba9ce90eeaa1c877b9231448f3a468247db0835))
* fix typescript problem ([ca5811a](https://github.com/standardnotes/app/commit/ca5811a0f2bab157a8d6bdabdfb7ce529563d8da))
* fix typo and remove log ([8bcd8c3](https://github.com/standardnotes/app/commit/8bcd8c31c90c8971eb8e54461f3920677bf8a95a))
* focus autocomplete input after adding tag from hint ([dcbc8f5](https://github.com/standardnotes/app/commit/dcbc8f59f9eb7948ca97de814bc6a2252e2f1bc2))
* focus input after option click ([4d67c48](https://github.com/standardnotes/app/commit/4d67c484f9a0ac774a79cb948ad18872d9d24649))
* focus new note on create ([#791](https://github.com/standardnotes/app/issues/791)) ([c9e448c](https://github.com/standardnotes/app/commit/c9e448c7b640d80b5a7c9277e11500bf9fef5284))
* focus trap error ([#974](https://github.com/standardnotes/app/issues/974)) ([c2edeb4](https://github.com/standardnotes/app/commit/c2edeb47e14d970fff9087d852fb1c19dc076d59))
* folders migration issue ([d17edfc](https://github.com/standardnotes/app/commit/d17edfc5cff79deadc0aef8e4b64d5e6d79db0e6))
* func param order ([92699d2](https://github.com/standardnotes/app/commit/92699d23f4d7e241836ac0ad52e5bdaee0b6155e))
* function binding ([cf1720b](https://github.com/standardnotes/app/commit/cf1720ba202fb6609241666bba2de4453464dbe8))
* handle case in preferences where component name can be undefined, causing exception that makes preferences UI unresponsive ([9256193](https://github.com/standardnotes/app/commit/9256193c66fa8f650f79a6d8905d85aa47648913))
* handle component tag selection ([a9f8e1c](https://github.com/standardnotes/app/commit/a9f8e1cba6d3da1b2d8e68b684bf5b4f17968a49))
* handle components keydown and keyup actions ([0a262de](https://github.com/standardnotes/app/commit/0a262de3db40bab5eebef5bf3cf91293d960232e))
* handle demo signin less generically ([#497](https://github.com/standardnotes/app/issues/497)) ([50a5cc4](https://github.com/standardnotes/app/commit/50a5cc48513aa615943db56fec961546fe2a1e18))
* handle folders activation from callback ([350815f](https://github.com/standardnotes/app/commit/350815fc588ae9b8f0d4f7cc7501f7890ef4cd87))
* handle keyParams and auth_params in import ([3b525ae](https://github.com/standardnotes/app/commit/3b525ae40ac11a74864c2ed5584f13d09b0ce9c7))
* handle legacy "client_updated_at" ([57901b6](https://github.com/standardnotes/app/commit/57901b6844a7dcbfdd687804c87af0036ab25005))
* handle new function signature ([8899c60](https://github.com/standardnotes/app/commit/8899c6075ac58dd7b6722a446df015e38060bcba))
* handle retrieving deleted components ([c6a25d6](https://github.com/standardnotes/app/commit/c6a25d6ae444794cdb70b91f6226065bfa016ea6))
* handle undefined desktop service when running in web environment ([e8ed38b](https://github.com/standardnotes/app/commit/e8ed38bcb2d4d76d5f94e97af7cc5fbddaccab00))
* handle undefined env value ([ef8fc83](https://github.com/standardnotes/app/commit/ef8fc83e3691cf73f8c5a79d489863e381bd24bb))
* header button border ([#887](https://github.com/standardnotes/app/issues/887)) ([96bfd6e](https://github.com/standardnotes/app/commit/96bfd6efc2119b15195e130162c8dc783a5f9582))
* hide account warning after login + improve key storage wording ([fab9ca2](https://github.com/standardnotes/app/commit/fab9ca2ad212d39cf5aa38a0e568595077c236f3))
* hide add tag options if no tags available ([4308f4e](https://github.com/standardnotes/app/commit/4308f4e656d51e517a389aea5c6d6a6f6275c4cc))
* hide data upgrade when not applicable ([491c9c0](https://github.com/standardnotes/app/commit/491c9c01e2b835d7a46d2eff8d2ccb6cab1f5fa8))
* hide encryption upgrade ([2e70ea7](https://github.com/standardnotes/app/commit/2e70ea7cd67adfd4e2fa3d619b5a78a222d2fc6e))
* hide horizontal separator if "offline subscriptions" section is hidden ([#740](https://github.com/standardnotes/app/issues/740)) ([f830834](https://github.com/standardnotes/app/commit/f8308348ede9e1ecf22c1477049964cf1e58a926))
* hide note count and tag icon for errored or waiting for keys tags ([7621904](https://github.com/standardnotes/app/commit/762190439f8a5bf2adfe589a2002948a31cbe1bf))
* hide protections paragraph when no account or passcode exist ([aa34bfc](https://github.com/standardnotes/app/commit/aa34bfc0c6a7f9dfdb05e11068f038bae9001095))
* hide refresh status when offline ([d80c74b](https://github.com/standardnotes/app/commit/d80c74b746a763d0650ee2998c1f42016b2c0955))
* hide sessions management ([1f0af1b](https://github.com/standardnotes/app/commit/1f0af1bc11ee881affbf33b27c5eef46e5da762a))
* hide some account preferences sections ([99b84e3](https://github.com/standardnotes/app/commit/99b84e3cda388db7bd67864d5e74181b80bceda8))
* icon component check ([7b4f784](https://github.com/standardnotes/app/commit/7b4f784538e40962aaa94994a7891d42a1811160))
* icons package ([4df06c1](https://github.com/standardnotes/app/commit/4df06c1d1a59f95ce735f87c106066ea28e5816c))
* if multiples notes selected, always select note when clicking on it ([c2ed6f1](https://github.com/standardnotes/app/commit/c2ed6f19131565faf2479ce01de1ba3ac585c1f4))
* if tag already exists it shouldn't be added to the list ([ead8d5d](https://github.com/standardnotes/app/commit/ead8d5dcf68fccd870691af20f6cc9d787e8fcd6))
* ignore `index.html` and provide a sample file instead ([5eff005](https://github.com/standardnotes/app/commit/5eff00545e89037cf0657be23f92903f894a2247))
* ignore node engine in Dockerfile ([f3a01aa](https://github.com/standardnotes/app/commit/f3a01aa60d4f31e00b70230a122728a67b9a75cd))
* image zoom over 100% ([#998](https://github.com/standardnotes/app/issues/998)) ([d0d97a8](https://github.com/standardnotes/app/commit/d0d97a8dbcdcff443786bb90bd77becb55155c39))
* image zoom scroll ([#1038](https://github.com/standardnotes/app/issues/1038)) ([509bd50](https://github.com/standardnotes/app/commit/509bd506b5756f5a1bae6acb60bae6e4e2b33fac))
* import ([e1da2be](https://github.com/standardnotes/app/commit/e1da2be83571fe92ef4fc91beed3df661ca1c171))
* import correct sncrypto dep ([bc28b56](https://github.com/standardnotes/app/commit/bc28b56523cc3fc2f9b7c53beb4a6c3f354ac8b3))
* import correct sncrypto dep ([5e17c3b](https://github.com/standardnotes/app/commit/5e17c3b53d090b15593b8b05444787fd8eb016dc))
* improper line-height clipping ([69bbf1f](https://github.com/standardnotes/app/commit/69bbf1f28beb8b8378ae82b5859ed844e1114c93))
* improve app version contrast ([f2e380f](https://github.com/standardnotes/app/commit/f2e380f036e9295a0244d027b75dec17e5c4eb10))
* improve deinit logic and flow ([e43c8a6](https://github.com/standardnotes/app/commit/e43c8a6f07b778491b6ab9707be126914504c109))
* improve empty notes list style ([f43087b](https://github.com/standardnotes/app/commit/f43087bff4e19ed6eeace72a9c70ea919c97c431))
* improve search options top margin ([99e26c8](https://github.com/standardnotes/app/commit/99e26c82700383a2e51c4300d361bc8687f98819))
* improve storage API ([f34d64c](https://github.com/standardnotes/app/commit/f34d64c1deecf39fc9e10c68e07657fbb3b8c91d))
* improve syncing exception user message ([fbdc010](https://github.com/standardnotes/app/commit/fbdc0100a4c021538084615ca449f935032fb025))
* incorrect modal height on chromium ([7a7aecf](https://github.com/standardnotes/app/commit/7a7aecfb3b9ba4bb7d4cd7affa214981b9b552bc))
* incorrect search clear button positioning ([e5b3a5a](https://github.com/standardnotes/app/commit/e5b3a5a4f98598a1f16b26faa603d6416caa0606))
* increase tag menu item margin ([cc28306](https://github.com/standardnotes/app/commit/cc283061c940c0576e09baa05a634ce01f4dbf3f))
* incremental loading for actions ([#449](https://github.com/standardnotes/app/issues/449)) ([c4506a5](https://github.com/standardnotes/app/commit/c4506a5407c87e4b4ab3e022d3fff627cbf55f35))
* initialize controller state softly ([b2d6ea0](https://github.com/standardnotes/app/commit/b2d6ea00c8ac5438de29e0bcdc384a0f8526a2bd))
* initialize userPreferences in preferencesManager ([afe4512](https://github.com/standardnotes/app/commit/afe4512a0a4c4f24fd444d5be38d8e605f56a11f))
* initializing git submodules ([61a1e03](https://github.com/standardnotes/app/commit/61a1e037b92166705c4d3358cc8fdbe1eaecc8db))
* insert template note before opening editor menu ([#838](https://github.com/standardnotes/app/issues/838)) ([ebd8848](https://github.com/standardnotes/app/commit/ebd8848b5ab4da77d77ce6aa9728de374365dac8))
* insert template note when selecting editor ([06ef538](https://github.com/standardnotes/app/commit/06ef5385467eda4366ff7e15246745936e0b7d40))
* ionicons ([4bbbef3](https://github.com/standardnotes/app/commit/4bbbef32fb92347021575fff476ac513da917a8b))
* ionicons not found on webpack dev server ([28708c4](https://github.com/standardnotes/app/commit/28708c4d0b1706b70af5f087dd2d34d21e61780d))
* issue when creating new note in new tag doesnt re-render immediately ([a2b2d3f](https://github.com/standardnotes/app/commit/a2b2d3f0bba50a4515ea0f8237048edad572fc40))
* issue with deactivate all themes on signout ([#804](https://github.com/standardnotes/app/issues/804)) ([713be82](https://github.com/standardnotes/app/commit/713be826e90112872394552aaddea86d77f56a7a))
* issue with some smart views not working ([89de4d6](https://github.com/standardnotes/app/commit/89de4d64888abdcc76fdc56bd0e4f0b200cb489d))
* JSON gem deprecation warnings ([b381364](https://github.com/standardnotes/app/commit/b381364987a6906588a8a47ffb7f6fd86437503d))
* keep application reference when on pure view controller destruction ([6e485e0](https://github.com/standardnotes/app/commit/6e485e0e8a195b9365b24b729dca04872aace73d))
* keep search options visible while authorizing ([24c5dba](https://github.com/standardnotes/app/commit/24c5dba4e9b57bf408c67acef72489c230857ee1))
* keep state consistent when clicking placeholder note ([0cd7d4b](https://github.com/standardnotes/app/commit/0cd7d4b3d131e4e99df9081f19b8c5aa90f984d3))
* keep tag title in dropdown in its original case ([447c010](https://github.com/standardnotes/app/commit/447c0109f0aefdc1b578cbf96e96b7752af467de))
* Last sync date padding ([#768](https://github.com/standardnotes/app/issues/768)) ([b29dc8e](https://github.com/standardnotes/app/commit/b29dc8ecc6cc97e208db40b91403c3f4e5f7253b))
* launch state error ([afb12f1](https://github.com/standardnotes/app/commit/afb12f1420fd57ab6477308c729786252131647d))
* legacy history ([#879](https://github.com/standardnotes/app/issues/879)) ([fbabbbb](https://github.com/standardnotes/app/commit/fbabbbb7d37b6bf0472d529bb598db543b46257f))
* link buttons border color ([973abba](https://github.com/standardnotes/app/commit/973abbac2b994decdc93f6a31f119e2f386d1dfc))
* lint errors ([a090939](https://github.com/standardnotes/app/commit/a0909399f8a1a97024372a2caaa9f8b8d76a152d))
* lint errors ([4d3bb22](https://github.com/standardnotes/app/commit/4d3bb22a8bbf0842c8943545f0cc15ec0f77f8d8))
* lint warning ([7e39d7c](https://github.com/standardnotes/app/commit/7e39d7c2831b70e252c0039cc316619e8e963d6b))
* list tags key warning ([#1056](https://github.com/standardnotes/app/issues/1056)) ([ef7166c](https://github.com/standardnotes/app/commit/ef7166c3d2cfca99f1e6fe5168d494a9bd177030))
* load/unload tags component on change ([d774ecb](https://github.com/standardnotes/app/commit/d774ecb3e13a1f4ae1bbc3f3b685ed40955721b0))
* local docker-compose setup ([#460](https://github.com/standardnotes/app/issues/460)) ([6a1c10d](https://github.com/standardnotes/app/commit/6a1c10d3f703379c9ef69d07ea0e83e6b5440a74))
* lock on snjs version ([#553](https://github.com/standardnotes/app/issues/553)) ([78c8438](https://github.com/standardnotes/app/commit/78c8438b0502dc7ca76b219d4cc80ece6a023187))
* locking message ([#1029](https://github.com/standardnotes/app/issues/1029)) ([27f864a](https://github.com/standardnotes/app/commit/27f864aa1d2877e4a4d5f8974085a8277a880d3b))
* log formatting on production ([c96a6c9](https://github.com/standardnotes/app/commit/c96a6c9e46ef6a1fcd0549b27e5c2d2b41bd1c1f))
* logs formatter to include severity for Datadog processing ([9c09492](https://github.com/standardnotes/app/commit/9c09492197a7f823b63635f036e561a8897c7fb2))
* main app container overflow ([a2d7752](https://github.com/standardnotes/app/commit/a2d775235eb64753d535217eb70014e20bc67720))
* make account settings pane first ([0d5e348](https://github.com/standardnotes/app/commit/0d5e3485238695af5f184cdb148d0490268bed76))
* make beta warning less alarming ([cebcbab](https://github.com/standardnotes/app/commit/cebcbab10ebd8cc65b7b9069a6add77bd72f3808))
* make context menu scrollable when there's not enough space ([f9f2959](https://github.com/standardnotes/app/commit/f9f2959ad57d6c46c121f2b830d30a085c5f30aa))
* make display options copy type-agnostic ([#1054](https://github.com/standardnotes/app/issues/1054)) ([cab2765](https://github.com/standardnotes/app/commit/cab27656ba9dadfb0322dc48f45d9d2d5863dda6))
* make dropdown height adjust to screen ([e258520](https://github.com/standardnotes/app/commit/e2585200ac992a28a891c2e913f259f7810bebfb))
* make dropdown items full width ([b0682e9](https://github.com/standardnotes/app/commit/b0682e913b44dc9eea831315a98e1cc62cbd0e54))
* make file renaming consistent with tag & note renaming ([#920](https://github.com/standardnotes/app/issues/920)) ([fc2a350](https://github.com/standardnotes/app/commit/fc2a350cca8f17c24b6504305164b59ba0574e77))
* make hint visible and focus input after creating new tag ([2c86958](https://github.com/standardnotes/app/commit/2c86958bf295bef1d4653ccf89ce0c7eea53d5df))
* make menus scrollable when there's not enough space ([6a9d54c](https://github.com/standardnotes/app/commit/6a9d54c2ae829ce05ec22a52ed53aac8e98fe7a1))
* make search case-insensitive ([#925](https://github.com/standardnotes/app/issues/925)) ([6f41577](https://github.com/standardnotes/app/commit/6f41577ec91281ab0475c04d661735a605806ec8))
* make search options open on top of tags container ([28aab95](https://github.com/standardnotes/app/commit/28aab95bc0397eaafdefee694f708831e996eccd))
* make sessions modal scrollable ([0e59a6c](https://github.com/standardnotes/app/commit/0e59a6c4319518f134b8e17a37c34abebe62bd0a))
* Make setServer function an action ([#704](https://github.com/standardnotes/app/issues/704)) ([d5a81c6](https://github.com/standardnotes/app/commit/d5a81c66489a3a48c81d1daf69b4432de83240c7))
* make sure input is visible when no tags are overflowed ([3db8709](https://github.com/standardnotes/app/commit/3db87099e00491d0635771dfb9442bc9f9e02026))
* make tag selected on second click ([7581380](https://github.com/standardnotes/app/commit/75813803c308cdf5f1136c7d647a3961440bf2a6))
* mantain multiple note selection when streaming items ([290c2b3](https://github.com/standardnotes/app/commit/290c2b305d48219ab669c3711b624cce5421bb08))
* markdown visual 1.0.2 ([f2e2ca6](https://github.com/standardnotes/app/commit/f2e2ca6451e43312663b9b21977c9b248b0712b0))
* menu should remain open when showing trash alert ([9906cd2](https://github.com/standardnotes/app/commit/9906cd2a2054ded189b05fae3b9a3becd857b9da))
* meta tags ([4200baa](https://github.com/standardnotes/app/commit/4200baadba22f64282dcc8823305e84a188aeb62))
* minor files related fixes ([#1016](https://github.com/standardnotes/app/issues/1016)) ([8ca9e37](https://github.com/standardnotes/app/commit/8ca9e37ae1bc70f002c63d3f2a00bdcaa99ba5cb))
* missing next version server initialization ([067f135](https://github.com/standardnotes/app/commit/067f135e528e0b5b0094566b2c5c602775809fb5))
* modifier-only key observers not working ([#1009](https://github.com/standardnotes/app/issues/1009)) ([c7e849a](https://github.com/standardnotes/app/commit/c7e849ac9089442ca2ec3e1189d02331c7325e3a))
* more accurate saving status + dont allow editor change while note is locked ([b93a35f](https://github.com/standardnotes/app/commit/b93a35f9653b6d4b0d5bf37c1b207402b0b8aca2))
* move dev account in useEffect ([5b99e5f](https://github.com/standardnotes/app/commit/5b99e5f90db68ce1939194083c63a7e63bcfcc5c))
* move fonts back to app folder ([32aa0a6](https://github.com/standardnotes/app/commit/32aa0a61837001ebed4ef84edb05b00b074ffea9))
* move Labs behind unfinished features flag ([7e0e620](https://github.com/standardnotes/app/commit/7e0e620ab87568cde3ae3316bbc62625a7e355f6))
* move onSignOut bridge hook call later in the deinit lifecycle ([7c9b684](https://github.com/standardnotes/app/commit/7c9b684c834c56f1ab61680792212d1c7b61434a))
* new note button not working when multiple notes selected ([6a7e09c](https://github.com/standardnotes/app/commit/6a7e09cd26ea3152a8491cf71ab4d68ec2b44bbb))
* not necessary to check for undefined ([39f3fb9](https://github.com/standardnotes/app/commit/39f3fb930e4ce4e9c29a9960eeaaeb7c76e7886c))
* note comparison in template ([9023f76](https://github.com/standardnotes/app/commit/9023f76417080cfcae5a0f8f0a1c29c51b5a2f03))
* note flickering and multiple selection staying enabled after browser shortcut ([c6e4c2f](https://github.com/standardnotes/app/commit/c6e4c2fcf5307a04a106a401460108b3fa7b3bec))
* note icons getting pushed by extra-long words ([#835](https://github.com/standardnotes/app/issues/835)) ([0e00901](https://github.com/standardnotes/app/commit/0e00901f1596454d94c4a3e9d3e2383a1b845d23))
* note list item border ([#862](https://github.com/standardnotes/app/issues/862)) ([03ba4af](https://github.com/standardnotes/app/commit/03ba4afd2e4eee0d70ed66593fcb34742d308a32))
* note stats ([#743](https://github.com/standardnotes/app/issues/743)) ([306441e](https://github.com/standardnotes/app/commit/306441ed3a92f3c0199997b95e41570faeb320a0))
* note tags component not reloading on note change ([48a9038](https://github.com/standardnotes/app/commit/48a903816722debb3f1453f0b185f1f6570a61a1))
* note tags list styling ([#1052](https://github.com/standardnotes/app/issues/1052)) ([7edd65c](https://github.com/standardnotes/app/commit/7edd65cfe83b9896d77283cabd9f149f147771b3))
* notes list item layout when title is empty ([#850](https://github.com/standardnotes/app/issues/850)) ([9932c2a](https://github.com/standardnotes/app/commit/9932c2a1776dc0209fc40cc3b500411178402fb5))
* Notes list options menu getting hidden ([#827](https://github.com/standardnotes/app/issues/827)) ([36584b0](https://github.com/standardnotes/app/commit/36584b07bd19886dc1e913a77c39d57e5c4246be))
* notes list options menu not toggling correctly ([#840](https://github.com/standardnotes/app/issues/840)) ([1f5d235](https://github.com/standardnotes/app/commit/1f5d235cd47deb85bd8a0912f316398de41ae68b))
* notes list options menu size regression ([#910](https://github.com/standardnotes/app/issues/910)) ([a17b7e7](https://github.com/standardnotes/app/commit/a17b7e7f461f1c080e2634459edfe2dfdc41ccba))
* notes options closing when selecting note id ([#888](https://github.com/standardnotes/app/issues/888)) ([a5da191](https://github.com/standardnotes/app/commit/a5da1910346abcca78bd6940f9290ca1af2bd68b))
* notes view not selected on launch issue ([57ec497](https://github.com/standardnotes/app/commit/57ec49733d265946637838155fe40b4b0f94fb2f))
* notify beta period end ([b2c7afb](https://github.com/standardnotes/app/commit/b2c7afb4826eeb84f15b37e5e87255d6677b4656))
* object url not being revoked on modal close ([#1044](https://github.com/standardnotes/app/issues/1044)) ([acdf442](https://github.com/standardnotes/app/commit/acdf442e61b56924e93ddbba868c5495f6641234))
* observe `KeyStatusChanged` event and correctly update `hasProtections` info ([1751584](https://github.com/standardnotes/app/commit/17515848b434da5944f0be62e7b98c4dd01c6c32))
* offline repo handling ([873aa15](https://github.com/standardnotes/app/commit/873aa1558ec6380b9a522ce920cd6a5e80c91546))
* only call auth form method once ([9deb5d1](https://github.com/standardnotes/app/commit/9deb5d13d5819d4f58d6ed8a8efd301e2da4653e))
* only create new placeholder if no editor is open ([3140b17](https://github.com/standardnotes/app/commit/3140b17c20a3af01e9277336d8f942305c7e1646))
* only match protected note title ([944d5db](https://github.com/standardnotes/app/commit/944d5db9b749a955d3f762936635c05515ab5d51))
* only navigate to last tag on backspace if input is empty ([eb3227c](https://github.com/standardnotes/app/commit/eb3227cffdf9517baea6ac31ff1548e1e3ac0ab2))
* only require one click to toggle stack components ([ceb2b3a](https://github.com/standardnotes/app/commit/ceb2b3a1ba84824ad28538374aa486824423176a))
* only show color scheme toast if change is required ([#973](https://github.com/standardnotes/app/issues/973)) ([4405f3b](https://github.com/standardnotes/app/commit/4405f3bbf21ae2c83115ad821f9c49edbc570886))
* only trigger search options animation once ([14d2109](https://github.com/standardnotes/app/commit/14d2109978f76f9f9b5daf8c1a2363bf76ff96e6))
* onWidthEvent error ([4faebe4](https://github.com/standardnotes/app/commit/4faebe4ffd16850d1e5b9a61d56e383741f72b7d))
* opaque history menu items ([13b877d](https://github.com/standardnotes/app/commit/13b877d27765a8ed888f4f84a7a7559a07cb96d6))
* open menu to the top when at the bottom of the screen ([24eb348](https://github.com/standardnotes/app/commit/24eb348b086f2d274fc055f727f08a9a98decd88))
* options button text color ([#841](https://github.com/standardnotes/app/issues/841)) ([84cef22](https://github.com/standardnotes/app/commit/84cef22fbf5fb6af2c0f0140c84b822cdcc05eba))
* order of commands in ci ([51dfbe5](https://github.com/standardnotes/app/commit/51dfbe5ca21c051a6b2f92cb92c765526b67cb37))
* outline style ([7f99148](https://github.com/standardnotes/app/commit/7f99148fc49ca152669b11b2fa3a7d8d66a16821))
* panel resizer callback ([7a615bc](https://github.com/standardnotes/app/commit/7a615bc1374bd60ae88f0c7fb952d74ddcf7fe1c))
* Panel resizing when using non-Plain editor ([#790](https://github.com/standardnotes/app/issues/790)) ([8db81d5](https://github.com/standardnotes/app/commit/8db81d5c5ce3ad2e390feb1bab0018d5b7bde203))
* panel_resizer mobx action warnings ([#820](https://github.com/standardnotes/app/issues/820)) ([701b703](https://github.com/standardnotes/app/commit/701b703466fc32ce4d362276286d2cb1f5e7a292))
* pass application to options component in overflow menu ([e82e27d](https://github.com/standardnotes/app/commit/e82e27ddb678a07b0966af9170817a3b25ae1396))
* pass note uuid ([b356a20](https://github.com/standardnotes/app/commit/b356a20d33604d46de61acd77a81ec083e60a66a))
* Password toggle triggering on Enter when checkbox is focused ([#767](https://github.com/standardnotes/app/issues/767)) ([024d44f](https://github.com/standardnotes/app/commit/024d44f1ff2c845d4cb5527d1a34d248b7e27ad7))
* pin note singular when only one note is selected ([b496cb1](https://github.com/standardnotes/app/commit/b496cb1cba03540761e3081767804b2a36454440))
* pinch zoom on preview modal ([#1012](https://github.com/standardnotes/app/issues/1012)) ([a3d5f57](https://github.com/standardnotes/app/commit/a3d5f57657ba85b0f1d5a54ed1c67dbcb5fe1efa))
* plain editor font changing ([#880](https://github.com/standardnotes/app/issues/880)) ([cd814bf](https://github.com/standardnotes/app/commit/cd814bf473f6536d23fb55ed06e9f7ff54fcb81a))
* plain editor revision rendering ([#889](https://github.com/standardnotes/app/issues/889)) ([538e41d](https://github.com/standardnotes/app/commit/538e41d1cb611f9e44f734ac07081d0c823a67d7))
* plain editor revision rendering and revision list sorting ([#878](https://github.com/standardnotes/app/issues/878)) ([1887d5d](https://github.com/standardnotes/app/commit/1887d5d01e8a96688a63ecc8d2cabd9c8c417579))
* point to correct JS/CSS files in webpack-dev-server ([7b070b7](https://github.com/standardnotes/app/commit/7b070b789effbb80e4440361e2f9dfb03ca3acd9))
* popover closing on delete dialog ([#1022](https://github.com/standardnotes/app/issues/1022)) ([ada8d5a](https://github.com/standardnotes/app/commit/ada8d5ab80ca79f81e503f2cf3da98d3b319bcc5))
* popover closing when renaming file ([#950](https://github.com/standardnotes/app/issues/950)) ([1bdda36](https://github.com/standardnotes/app/commit/1bdda366d04bee25a8e428e2845a318975477a87))
* precompiling font assets ([43e1620](https://github.com/standardnotes/app/commit/43e16203ddf604bd6f177e6de428727cc8b0eefe))
* preferences pane buttons border color ([618c2c6](https://github.com/standardnotes/app/commit/618c2c6dae8082914f81b68c673bfe7ae7253f6f))
* preferences pane order ([f6c9a9f](https://github.com/standardnotes/app/commit/f6c9a9f9adaea0e8c7680e9fdb4bea93bbea7176))
* pressing enter on authentication modal not submitting form ([87305c8](https://github.com/standardnotes/app/commit/87305c80712f209b0fc83aae95dbc1c0dd349245))
* prevent archiving locked notes ([94f94c0](https://github.com/standardnotes/app/commit/94f94c0570bc2547e8bde48af0eb06b25452a686))
* prevent closing rooms when spreadsheet editor takes focus ([d1e0101](https://github.com/standardnotes/app/commit/d1e0101675cb09a8a963b9e07a222e1ac89b2b49))
* prevent component viewer double reload ([a477281](https://github.com/standardnotes/app/commit/a47728188f4554f4ee722c44c243c1885b0554a9))
* prevent cutting off lines on windows ([cd7b5cc](https://github.com/standardnotes/app/commit/cd7b5cc455942d1a74be38211524d3ca064f7a7a))
* prevent default action when activating "Import Backup" by keyboard ([33082fc](https://github.com/standardnotes/app/commit/33082fcd7a77b7262c74fb289404eb1c6789ccfd))
* prevent dock icons twitching upon theme activation ([ddbf50e](https://github.com/standardnotes/app/commit/ddbf50ee820dd8cfceb297cf4e3ed2877abd29db))
* prevent editor column overflow ([ebf6e69](https://github.com/standardnotes/app/commit/ebf6e69ef7de5c3a77a41324cbbd60316e39a452))
* prevent errors when destroying local data on launch challenge ([5b814ea](https://github.com/standardnotes/app/commit/5b814ea9befc228bd46fcacddbc86da26466e6f9))
* prevent errors when focus gets lost on new tag ([d458915](https://github.com/standardnotes/app/commit/d45891569f2d87ff70a0b828a03658d1335187b7))
* prevent exception when inserting note ([65108fb](https://github.com/standardnotes/app/commit/65108fbb2ea89d5f8c335deb0612e8d161b5410a))
* prevent form submission on dropdown option click ([fa08b7e](https://github.com/standardnotes/app/commit/fa08b7eaf3c19b889459df9c58022c8e25eabe8f))
* prevent importing backup files with version > 003 ([a0d6884](https://github.com/standardnotes/app/commit/a0d6884fd7bb7fbf140ca72d65f977cb101b912e))
* prevent infinite loop while switching between notes with editors ([65468a1](https://github.com/standardnotes/app/commit/65468a1a72bff696d9b7bf6f8364a733d36c1070))
* prevent restoring version if note is locked ([86fd93a](https://github.com/standardnotes/app/commit/86fd93ab0e0f3fa36b3305185c85f0933b13e3e2))
* prevent save status overflow from changing width of editor pane ([d12eebe](https://github.com/standardnotes/app/commit/d12eebe8837c3f130fa16f770fd4485bc9a51ca5))
* prevent session expired alerts from piling up ([096b9c8](https://github.com/standardnotes/app/commit/096b9c8c87c1cc18462fad2ab7e04bb1d4fbaf50))
* prevent undefined access ([2ba43a0](https://github.com/standardnotes/app/commit/2ba43a01ed3a4f13f6c81591e409c006eb1f2258))
* progress bar color on firefox ([#958](https://github.com/standardnotes/app/issues/958)) ([df54c37](https://github.com/standardnotes/app/commit/df54c3701c05e7e87da96ef76b65146a1d0c7240))
* promote actions visibility to global state ([c55a7e4](https://github.com/standardnotes/app/commit/c55a7e45a4f126a88202f271c82be7d7a6650075))
* proper names for actions and history menus ([#450](https://github.com/standardnotes/app/issues/450)) ([d96b058](https://github.com/standardnotes/app/commit/d96b058133326d3e0595bd33e810ba798cb45e29))
* proper reload of ext data ([8679bf5](https://github.com/standardnotes/app/commit/8679bf5b308841f7e47d804773af1c4de559e38e))
* properly color svg button ([1b34331](https://github.com/standardnotes/app/commit/1b34331e9345471b0eca5782e4e7801a00c206b0))
* properly remove Quick Tags extension before notifying SNJS ([f446d36](https://github.com/standardnotes/app/commit/f446d363a94a1459a128b239272cbf85d2237a9f))
* provide websocket url to ApplicationGroup ([#602](https://github.com/standardnotes/app/issues/602)) ([f5ae75e](https://github.com/standardnotes/app/commit/f5ae75ef26853a632bb12502d06bfce82d5a821c))
* race condition when editor values read could belong to newly selected note as opposed to note for which save was triggered ([64945ab](https://github.com/standardnotes/app/commit/64945abbcc527161a6eff8a47922d690677d4c08))
* race condition where previous note actions may be displayed for current note ([#613](https://github.com/standardnotes/app/issues/613)) ([41e1dd9](https://github.com/standardnotes/app/commit/41e1dd973117c3accf6ee8669424c80b2f9ac6c4))
* re-add clearing tags ref on every render ([570a7ed](https://github.com/standardnotes/app/commit/570a7ed587843fb69b8a41b8ced051344011454f))
* react-related fixes ([#1050](https://github.com/standardnotes/app/issues/1050)) ([834459d](https://github.com/standardnotes/app/commit/834459d3a84dce6b64094bb4e4115bd882ea0932))
* read preferences value from state ([b944f3d](https://github.com/standardnotes/app/commit/b944f3dec8099e1086071feaa3ab7da2d7ea85e6))
* redact file paths error reports ([71bb153](https://github.com/standardnotes/app/commit/71bb153d66a46c639dcd3aa8d1aa61b3627f92dc))
* reduce amount of information sent to bugsnag ([7e2cadc](https://github.com/standardnotes/app/commit/7e2cadcc9b280ef1097cf168813bfca686a7326b))
* reduce panel resizer width ([1c07253](https://github.com/standardnotes/app/commit/1c07253efbc845fc87d725940daebddd49a2c16e))
* reflect tag deletion from synced note ([d97cfc4](https://github.com/standardnotes/app/commit/d97cfc476876b7f5c4a74c1bf8ccd0f56411ec3f))
* refresh ext-manager when deleting extension with no account ([b74c856](https://github.com/standardnotes/app/commit/b74c85638da5c6da5b4d6322dd7485733360ec4f))
* reload document once if tab is hidden in firefox ([3fa8cc1](https://github.com/standardnotes/app/commit/3fa8cc103b78f9ebd49d115fb9f446fc99100c29))
* reload layout when double clicking on panel resizer ([595b44d](https://github.com/standardnotes/app/commit/595b44dfee66390ae0cdb561d34d9d5d0aa21f6e))
* reload note counts ([#797](https://github.com/standardnotes/app/issues/797)) ([285fe31](https://github.com/standardnotes/app/commit/285fe31dd8368cbda84c2a620d4a4ee88ca71288))
* reload search results when changing protected text search option ([757f439](https://github.com/standardnotes/app/commit/757f43971c35e8976a0ab6c5400efb5ada950864))
* reload subscription state after event ([#727](https://github.com/standardnotes/app/issues/727)) ([73b91e5](https://github.com/standardnotes/app/commit/73b91e59643872593af403db2a5967804d3aa4cc))
* reload tabIndex after tags expansion ([f9c2b19](https://github.com/standardnotes/app/commit/f9c2b19eacf84e5461b269ec81b58163bd703c37))
* reload tag results after adding tag ([f039870](https://github.com/standardnotes/app/commit/f03987016f0f2b5fd0cd55d2c25aab617ac1d730))
* reload tag results after adding tag ([b6aaa49](https://github.com/standardnotes/app/commit/b6aaa49e505885c83de31796271a6ab77f38a6cf))
* reload tags after adding or removing them from context menu ([5c5523f](https://github.com/standardnotes/app/commit/5c5523fd0a1f675f9cc04c08f228c812ed8e8b93))
* Reload textarea on spellcheck pref change ([#690](https://github.com/standardnotes/app/issues/690)) ([4ce9264](https://github.com/standardnotes/app/commit/4ce9264572e00f85c3739a525fa9cfc0604a79f8))
* reload user preferences after signing in ([3330b20](https://github.com/standardnotes/app/commit/3330b201ddca66fd56ff294e4d8fc2a0d376db5b))
* reload user preferences singleton at the right time ([4ad3049](https://github.com/standardnotes/app/commit/4ad304920d6b2adcfb0398c4abdccb1e7464759e))
* reload when firefox pinned tab becomes visible ([#535](https://github.com/standardnotes/app/issues/535)) ([cf76e1b](https://github.com/standardnotes/app/commit/cf76e1b42aacb5e83a7e988c146c931b7a3ca254))
* remove app observer on controller deinit ([db914ee](https://github.com/standardnotes/app/commit/db914ee4bff9fb9c627754dc2430a54b0295def1))
* remove assets and health check logs ([7ccb3fc](https://github.com/standardnotes/app/commit/7ccb3fc99f24f9d41b49ff374d76ee41d31418b5))
* remove async from reloadActiveNoteTags ([2b73441](https://github.com/standardnotes/app/commit/2b734415e4eaa6c6e380178bf973bcdeb4ac9f3d))
* remove background color from scrollable class ([6e1e5ab](https://github.com/standardnotes/app/commit/6e1e5abaea644a3c193754725258a31123e2fee3))
* remove check for null or undefined data on revoke session ([0c80e79](https://github.com/standardnotes/app/commit/0c80e795e47c2c023db9df266eb498375d663d51))
* remove code already handled by snjs ([#633](https://github.com/standardnotes/app/issues/633)) ([e6e01d0](https://github.com/standardnotes/app/commit/e6e01d0f2c937a8f1f81b291edafcddc86531b06))
* remove confirmation dialog when restoring trashed note ([1943b34](https://github.com/standardnotes/app/commit/1943b34fdfbbe3801ae370b05cfc8e933dfc2016))
* remove console statement ([4f2d442](https://github.com/standardnotes/app/commit/4f2d442ac1a8c1461617f7c54ec42c605ffcaa69))
* remove dogstatsd-ruby ([96f223a](https://github.com/standardnotes/app/commit/96f223ae13a23fd872fc887fef359544ab5e5549))
* remove erroneous merge artifact ([6a63ccc](https://github.com/standardnotes/app/commit/6a63cccec29133f570df2f2871b12f3c89be693b))
* remove extensions-manager vendor dir ([fcc22ff](https://github.com/standardnotes/app/commit/fcc22ffb78a75f09344a01dc16820c7c2b678064))
* remove firefox pinned tab function and return if doc hidden ([9fc7de7](https://github.com/standardnotes/app/commit/9fc7de74d464ee3389904c17af03561a5f41cbd9))
* remove focus outline artifacts ([369b748](https://github.com/standardnotes/app/commit/369b748b972e23dc6d7711e3de2500bb3dfd2284))
* remove forced ssl on production ([85220aa](https://github.com/standardnotes/app/commit/85220aae6ad6ea9b5d590840b6437af7c79c0c56))
* Remove from repository files generated during build process ([da0d715](https://github.com/standardnotes/app/commit/da0d715910b99b84fbcb34f5661690aefb79abc1))
* remove generated dist files from repo ([ef44c08](https://github.com/standardnotes/app/commit/ef44c0818e0e0b9872a8f0b5004feb109de585ed))
* remove github actions for beta environment ([937311d](https://github.com/standardnotes/app/commit/937311d92e2073c2d44eda25d7e4d9ec7bb172bc))
* Remove HTML tags before counting words for a note ([#739](https://github.com/standardnotes/app/issues/739)) ([e16e817](https://github.com/standardnotes/app/commit/e16e817747a5c79f2322e66513f97c9c21c0bc14))
* remove inconsistencies between protected note label and date ([6a3e070](https://github.com/standardnotes/app/commit/6a3e070ea67ac339bbcaa685a18991a81ceda496))
* remove keyboard shortcut for permanently deleting a note ([c26d6a7](https://github.com/standardnotes/app/commit/c26d6a71390dbea2d1c483d82f1823660cadbad1))
* remove locking closeOnBlur ([461f3cc](https://github.com/standardnotes/app/commit/461f3ccfa4ffa9c0335f4fbe0557b6bf8f7f14b2))
* remove log ([5e83493](https://github.com/standardnotes/app/commit/5e83493633e30350159874d8c5b4aab25349dc67))
* remove log ([bfef98f](https://github.com/standardnotes/app/commit/bfef98f6b8ae0b7a46cd942e46b86e2350a81c70))
* remove log ([e7fc206](https://github.com/standardnotes/app/commit/e7fc2066c2721880141cc4a98f7b54f8d1183dd1))
* remove max height on note options menu ([d3ef05d](https://github.com/standardnotes/app/commit/d3ef05d2d6187534c9541ca135860d290e0f3afb))
* remove memory leak in click-outside ([fc0a7d4](https://github.com/standardnotes/app/commit/fc0a7d4c662f45ee1a15882bb4fe676feae1d5f8))
* remove mention of 'local passcode' ([24d35c8](https://github.com/standardnotes/app/commit/24d35c86a71ed97a13a3ff8b3527795a8ceb424e))
* remove multiEditorEnabled ([f7f3b06](https://github.com/standardnotes/app/commit/f7f3b062fbf59baad164ac99cc2536cc5566e252))
* remove non-standard 'wasm-eval' script CSP source ([861e9c1](https://github.com/standardnotes/app/commit/861e9c180d797c8bcd4c103c711ae6225e3812fd))
* remove outline on tags input ([fa15339](https://github.com/standardnotes/app/commit/fa15339efc8a3ba50bb30dec48eeb1061aca8354))
* remove public beta flags ([d088d74](https://github.com/standardnotes/app/commit/d088d74069cf282083901fc99fa51c9594a395b0))
* remove recursive tag deletion ([124f777](https://github.com/standardnotes/app/commit/124f7779c38862e140ac3207bbbf33ea0c913367))
* remove redundant check in template ([1a138ef](https://github.com/standardnotes/app/commit/1a138ef83d51dc7f2b7f94d8b8c9813384fb967a))
* remove scrollbars on paragraphs ([5bd0db3](https://github.com/standardnotes/app/commit/5bd0db302c6dc95c45467deff1ab338bcae260c6))
* remove unnecessary async modifiers ([80d6248](https://github.com/standardnotes/app/commit/80d62489ebfc57c3a7c9dc713edc82cd6135d6a6))
* remove unnecessary property ([ff20b9d](https://github.com/standardnotes/app/commit/ff20b9d6e624bca11611ee79ebff114b028a08a5))
* remove unused code ([463f0eb](https://github.com/standardnotes/app/commit/463f0eb2868cb06b40c653c466f669e26193f686))
* remove unused files ([cc5dc6f](https://github.com/standardnotes/app/commit/cc5dc6fdcd6d1bcea9b598af8fc17b3c446064f4))
* remove unused imports ([06740c4](https://github.com/standardnotes/app/commit/06740c4a88e894bf9987bb21cc16c3551df2ef6d))
* remove unused method ([a6d0319](https://github.com/standardnotes/app/commit/a6d0319fb7b3799647349c914b2f6239a9637d6c))
* remove unused properties ([9019dda](https://github.com/standardnotes/app/commit/9019dda003dfd6c6d92ccc2a41987ebffb4bf156))
* remove unused values ([cef1934](https://github.com/standardnotes/app/commit/cef1934a817af4d2512f4c411855f390cdce264f))
* remove unused vars in account menu ([#659](https://github.com/standardnotes/app/issues/659)) ([d89f6bf](https://github.com/standardnotes/app/commit/d89f6bfac189c5c53fd9564b4041306e79e4e966))
* remove white corner dots in dark theme lock screens ([a22a95e](https://github.com/standardnotes/app/commit/a22a95e9285ec379e551e65a23e73a4f96a73c45))
* rename allStackComponent to stackComponent in pug file ([d935537](https://github.com/standardnotes/app/commit/d9355377b1533a9803c9ca81fdd8048dd8343e85))
* rename master branch to main ([29b7203](https://github.com/standardnotes/app/commit/29b720398f665db505412bb0ec62d13a4c01750e))
* rename master branch to main ([#521](https://github.com/standardnotes/app/issues/521)) ([38707cc](https://github.com/standardnotes/app/commit/38707cc97719496928c6680c60132178e258fac2))
* rename session related functions ([07bbd0e](https://github.com/standardnotes/app/commit/07bbd0e6b22c4d9bf34a374bf1588c73ced0cb75))
* render change editor menu only if it is open ([#894](https://github.com/standardnotes/app/issues/894)) ([0e2ea3a](https://github.com/standardnotes/app/commit/0e2ea3af749150f1997b52617996b7f6bf8170b4))
* render change editor menu only if it is open ([#894](https://github.com/standardnotes/app/issues/894)) ([5df3e59](https://github.com/standardnotes/app/commit/5df3e596045deeaeda51e996a74ef5a33d06ba54))
* render component view in revision preview ([65498ca](https://github.com/standardnotes/app/commit/65498cad5c24168abb0eb7c376f8f06111a3941f))
* render root element on dom load ([46ee84c](https://github.com/standardnotes/app/commit/46ee84ce24a4f407c8390dd7d26255b819dd0f13))
* reorganize action to prevent deploying when tsc fails ([7f4bcde](https://github.com/standardnotes/app/commit/7f4bcdeec5435c71667354e33a48ea9b470637f4))
* replace border-gray-300 with a themable colour ([#664](https://github.com/standardnotes/app/issues/664)) ([32ced95](https://github.com/standardnotes/app/commit/32ced95f728872cb83df951c0e9b4c05a5affdb0))
* replace datadog with newrelic ([281eb1c](https://github.com/standardnotes/app/commit/281eb1cfd355ef1dd3a2bf3e82da08f6cbd1e20f))
* replace setContent with unsafe_setCustomContent ([72edbfa](https://github.com/standardnotes/app/commit/72edbfafcaf5512aa5f30a0b69e69df90622ffae))
* reposition dropdowns when resizing window ([afc84b5](https://github.com/standardnotes/app/commit/afc84b5702a9fcc24f9233fd9f19851da4d3ca35))
* reset isTemplateNote when setting a new note ([#439](https://github.com/standardnotes/app/issues/439)) ([11ac388](https://github.com/standardnotes/app/commit/11ac38856f06dea0cf6222b973d7542e2d8c55a7))
* resize invisible/gigantic No Distractions theme icon ([a3353e4](https://github.com/standardnotes/app/commit/a3353e4ef797b31af789ec4802ca36c2df08bfc4))
* restore correct modal layout ([4e136f1](https://github.com/standardnotes/app/commit/4e136f150a36b06dc35aa7f67fd85ca6eb71eb7a))
* restore correct spacing issue on action button for Listed ([e232502](https://github.com/standardnotes/app/commit/e23250200a675079634d521f2aab8c8a863eb056))
* restore note display options ([9343b92](https://github.com/standardnotes/app/commit/9343b928de5d1bc83892947d338a9e9741516cb9))
* restore permissions modal ([5cd3a7c](https://github.com/standardnotes/app/commit/5cd3a7cb093e5332d1515c1e0d570aea06eb5567))
* restore showing tags in the notes view ([54ed0bd](https://github.com/standardnotes/app/commit/54ed0bdabbfec97d82e2b13c6e16cd366c244f46))
* restore zip naming conventions from 3.3.x ([f760143](https://github.com/standardnotes/app/commit/f7601433b8da605a8498a208928e16f8a6a431b6))
* restrict max reach dialog width ([cbe53ed](https://github.com/standardnotes/app/commit/cbe53edb823fbca803f7e1e1582df153a0d63db4))
* revert changes to closeOnBlur and add closeOnClickOutside ([45357c1](https://github.com/standardnotes/app/commit/45357c19768dc9c955c02a5145a0d21f0ed8b78d))
* revert closeOnBlur changes ([dd5873b](https://github.com/standardnotes/app/commit/dd5873b513fba384a046020d8ddf29cfba052305))
* revert to using fixed margin when setting container width ([6d1f6c6](https://github.com/standardnotes/app/commit/6d1f6c6f24375df531886f6ebbdf017c475ce95d))
* revert to using label for import backup option ([61321b8](https://github.com/standardnotes/app/commit/61321b8d8e72901ea49d638797bb53722b740c1b))
* revert using portal for ellipsis menu ([0b2665a](https://github.com/standardnotes/app/commit/0b2665a01bb44aa62ad669f9f83cd27141364f9a))
* revision content screen copy ([#876](https://github.com/standardnotes/app/issues/876)) ([723a70d](https://github.com/standardnotes/app/commit/723a70dd28f661fd54e6a0ef06aaca5fcd14db49))
* revision textarea background color ([#966](https://github.com/standardnotes/app/issues/966)) ([290c3ba](https://github.com/standardnotes/app/commit/290c3badd09872b7e8871b7504f3093a2853eeec))
* right-click should select note ([8a9dc14](https://github.com/standardnotes/app/commit/8a9dc14d816d1cac58246be00b423e42493fe7c4))
* run docker with root to fix crashing on Linux (undoes 62da387d3a) ([#525](https://github.com/standardnotes/app/issues/525)) ([3fa8642](https://github.com/standardnotes/app/commit/3fa86428ba6ace9c91a924127fab077d1c982dc1))
* run Docker without root ([62da387](https://github.com/standardnotes/app/commit/62da387d3ae52b706b2338275cae101270a11c83))
* running tests and adding tests to CI & CD ([#1047](https://github.com/standardnotes/app/issues/1047)) ([2d3221c](https://github.com/standardnotes/app/commit/2d3221c944ca20543179257b4c77631c75ef0be7))
* sanitize alert string ([333d4c4](https://github.com/standardnotes/app/commit/333d4c4808081ebc7c0de350593a7f4e05904def))
* sanitize backup file names for windows ([9d017b5](https://github.com/standardnotes/app/commit/9d017b574503d39c46e18964c478047689bcdf43))
* sanitize html string ([#784](https://github.com/standardnotes/app/issues/784)) ([7f011d7](https://github.com/standardnotes/app/commit/7f011d7288935bafc7d685cd632052b1a765e857))
* sass syntax error ([1619660](https://github.com/standardnotes/app/commit/1619660530811327ca7c7bb76641dd437a37069f))
* saving status while fully offline ([7abad65](https://github.com/standardnotes/app/commit/7abad65a510f76a33587ba93067c712954ed55ae))
* scroll notes list when navigating with arrow keys ([2473a78](https://github.com/standardnotes/app/commit/2473a780d1fdcc3120544312030f33eba3c8ff8b))
* scroll position changing when entering new line on editor ([6170bca](https://github.com/standardnotes/app/commit/6170bca0d824d2d7c5b2be22efcfdcad58351e7b))
* search box autofilling with username ([c771f89](https://github.com/standardnotes/app/commit/c771f899826f92469d8e579a59f671c42d6381bd))
* select active note ([f317d6c](https://github.com/standardnotes/app/commit/f317d6cb7c7ecc7748bad9c89164f7f6deeb5b3f))
* select first note on sign in ([35434f8](https://github.com/standardnotes/app/commit/35434f8af3c102dd4d737240261ad52ae95acf90))
* select home navigation view when creating note inside smart view ([#1059](https://github.com/standardnotes/app/issues/1059)) ([78f39ec](https://github.com/standardnotes/app/commit/78f39ec85db3d3c38e29e5f8a6d744398d285d6b))
* select on focus, wait for value ([6be8fa9](https://github.com/standardnotes/app/commit/6be8fa93f886909aa93c04f13bb07211f7f0a8ec))
* Selected item bg color ([b1d9580](https://github.com/standardnotes/app/commit/b1d95808d13dc3f903ed2ce0fb55651b7731451b))
* selected smart view and note list issue ([#1042](https://github.com/standardnotes/app/issues/1042)) ([599e2b8](https://github.com/standardnotes/app/commit/599e2b886e22a283529b17fc081e819390c3fd1d))
* serve public/assets with webpack-dev-server ([9045898](https://github.com/standardnotes/app/commit/90458982ce82eb69317ddebcb9737b971ef12634))
* set desktop installed payload source ([dce9707](https://github.com/standardnotes/app/commit/dce97077b4b54cf1f1f1ac76fb99d4dce4c4a6e9))
* set explicit line endings for tsc ([9a02dd6](https://github.com/standardnotes/app/commit/9a02dd623b90da2e2819acbdd381edf2312dc523))
* set max width for search options ([a61f43c](https://github.com/standardnotes/app/commit/a61f43c557940ca61e0591e26788d110a21992d6))
* set max width to note tag text ([4f729c7](https://github.com/standardnotes/app/commit/4f729c7287e7296c70dfa929c5d278293c59968a))
* set minimum passcode length ([1bb2750](https://github.com/standardnotes/app/commit/1bb27503fa58cd196fd391f5be8fddb1b9d2633d))
* set minimum passcode length ([1d4eae5](https://github.com/standardnotes/app/commit/1d4eae5d0073cdda5f379011e6e76ffe25f155a5))
* set mobx store as local state ([99ef854](https://github.com/standardnotes/app/commit/99ef854ae8b36a993583b7e29ffa6ca66a57d3c6))
* set next version host on host input change ([1af72ab](https://github.com/standardnotes/app/commit/1af72abe236874b2e6af6e941e87f89989cc5c18))
* set tabIndex on dropdown buttons ([bea4e00](https://github.com/standardnotes/app/commit/bea4e00b9de0638b558820f34365d08c7d964bea))
* set tags menu max height when at the bottom of the screen ([350fc20](https://github.com/standardnotes/app/commit/350fc208310d379d7c87dbac342f397a36ec2b92))
* show "Last refreshed…" in footer when logged in ([623bbae](https://github.com/standardnotes/app/commit/623bbae3bfc02ef0765c1409e989c5cba70f35ed))
* show alert when importing a zip file as a backup ([#720](https://github.com/standardnotes/app/issues/720)) ([261bb65](https://github.com/standardnotes/app/commit/261bb65a85769c93ff95d613683c447549500dc2))
* show autocomplete tag results only if query isn't empty ([91fc475](https://github.com/standardnotes/app/commit/91fc475aac25b1a3019f9da889f623e7b1e56111))
* show challenge prompt title in placeholder field ([a07c9c3](https://github.com/standardnotes/app/commit/a07c9c3a6c9852b50f4079a34bc0409734dade3a))
* show correct "Last modified date" for note ([#742](https://github.com/standardnotes/app/issues/742)) ([0193eea](https://github.com/standardnotes/app/commit/0193eea1f50f6d8e95ca2cef68edc64fa6072aa4))
* show correct sync status ([19a9f57](https://github.com/standardnotes/app/commit/19a9f57bedc25543d6efd018b079c26989c5135e))
* show history entry count ([9599f30](https://github.com/standardnotes/app/commit/9599f30ad46a3447b6f48833d7e4bca8af951fc6))
* show import error sooner ([a1727b1](https://github.com/standardnotes/app/commit/a1727b1b1e92d96596f80934d20d3cb1daab1035))
* show offline repo section if repo present ([d5e58cf](https://github.com/standardnotes/app/commit/d5e58cf816a90c51b55e303108a20b4b70f93a8b))
* show placeholder note in notes list ([257d713](https://github.com/standardnotes/app/commit/257d713d39f7e0cd6615dd6898a7e9d1ddeadeb2))
* show saving status when editing note for the first time ([e71c47f](https://github.com/standardnotes/app/commit/e71c47ff54a11bf30143b6e9a1364a0f7873b5d9))
* Show SmartTag status in sidebar ([ee8b8fe](https://github.com/standardnotes/app/commit/ee8b8fec4dde495b084c75dbe49970516e4a7a07))
* show subscription info for logged in user and avoid making api call if no account ([7bed9a5](https://github.com/standardnotes/app/commit/7bed9a52f7f4e7234de48857ce0418409809a4ef))
* show syncing message consistently ([8434f59](https://github.com/standardnotes/app/commit/8434f598ca80259a32c28d10e399b271ff6bb7f5))
* show the beta warning on web ([b0ccecb](https://github.com/standardnotes/app/commit/b0ccecbd9608d985fcd52e900db25c344e8728a1))
* show trashed notes that are also archived ([40df75d](https://github.com/standardnotes/app/commit/40df75dff9e8232d8e470e5e7d9f3c6c9353bd29))
* showing saving status on first load ([07678bb](https://github.com/standardnotes/app/commit/07678bbd3245c6768fa749ed47d725e0dfdd11a0))
* sign out dialog disappearing when account menu is unfocused ([#863](https://github.com/standardnotes/app/issues/863)) ([0e1b94b](https://github.com/standardnotes/app/commit/0e1b94b5cdf67eb64a5841dcd4d1d83150b767a6))
* silence deprecations on production ([ad192dc](https://github.com/standardnotes/app/commit/ad192dc92cff7730444f77f071e6549e4ae2ba34))
* simplify component logic ([e177dca](https://github.com/standardnotes/app/commit/e177dcac478f42adf1ef75b27767b79914404c44))
* site urls ([f029e32](https://github.com/standardnotes/app/commit/f029e32dff0c59ed711006f629bb76ac3450426c))
* slightly increase tag display density ([dcf07f7](https://github.com/standardnotes/app/commit/dcf07f70fd824e7d3962908e0f1ce8a725bc73a1))
* smart tag selection issue ([af1a369](https://github.com/standardnotes/app/commit/af1a369e632111e906c057e929f7b8d98408d154))
* smart tags ([9a9d2c4](https://github.com/standardnotes/app/commit/9a9d2c408597a8371f8a9a18f73937159ef80383))
* snjs types ([aca5f41](https://github.com/standardnotes/app/commit/aca5f41e55741c4b030ffc5d919e29ac158c64fe))
* snjs version to latest release ([0c766d0](https://github.com/standardnotes/app/commit/0c766d0554d149ce791fb5444f8666da5243b2d1))
* spacing between title and tags ([524bcd0](https://github.com/standardnotes/app/commit/524bcd09cbaec10d286b3cda48bcd5e78c391351))
* spellcheck control for 3rd-party editors ([#839](https://github.com/standardnotes/app/issues/839)) ([528bafd](https://github.com/standardnotes/app/commit/528bafde96b5bff6c50be8f8b56c764149b1c079))
* spellcheck toggle note about plain editor only ([660f74c](https://github.com/standardnotes/app/commit/660f74c8ba65fe8df6038a51be8771bd1414b7b1))
* spinner loading infinitely on unsupported file types ([#1002](https://github.com/standardnotes/app/issues/1002)) ([93fbfff](https://github.com/standardnotes/app/commit/93fbfffbd24c7943b8beec53d91c89d69f333073))
* start command in docker entrypoint ([7073c2f](https://github.com/standardnotes/app/commit/7073c2f136b915f25d3b7ba3816c27bc98814c24))
* stop relying on window.isElectron ([22db551](https://github.com/standardnotes/app/commit/22db551f1b4ea11a332ae307b7b279c2ab84c823))
* stop tracking dist fonts ([e06311c](https://github.com/standardnotes/app/commit/e06311c56b283891e06e65ecde17e610750e0cb3))
* store zipped items inside "Items" subfolder ([9f522c8](https://github.com/standardnotes/app/commit/9f522c8eb6a6066f86d47a3d311b970cd01cc04e))
* stream SmartTags ([3679fc0](https://github.com/standardnotes/app/commit/3679fc0ecacfd69cf2d86e4e77e7749b6fe8844a))
* stretch editor to full width in revision preview ([8238387](https://github.com/standardnotes/app/commit/823838776165a1d4cd435e23bac8442d89eed740))
* success url should ignore params ([f28564e](https://github.com/standardnotes/app/commit/f28564e70823a9840e9ccbb991fd4b204d45b172))
* support refactored SNJS history ([4242021](https://github.com/standardnotes/app/commit/4242021dcaea40858d02ca8785ac38916ef5a8d8))
* svg icons not showing on footer section ([#710](https://github.com/standardnotes/app/issues/710)) ([c754920](https://github.com/standardnotes/app/commit/c75492018f4f591810d1f25d4f187038ab49d25e))
* swap 'Merge Local Data' confirm prompt actions ([637b1ae](https://github.com/standardnotes/app/commit/637b1aeb2d1361b93a7c581518f2c1a753d9de5d))
* switching between previewable & non-previewable files ([#1021](https://github.com/standardnotes/app/issues/1021)) ([ae1097f](https://github.com/standardnotes/app/commit/ae1097f20771506f8539fc754009e49aa1e8661c))
* sync after changing notes ([8f7a085](https://github.com/standardnotes/app/commit/8f7a0858ba5ea80c260060729c782e6a856531b8))
* sync request before downloading/previewing file ([#1003](https://github.com/standardnotes/app/issues/1003)) ([9a99cc8](https://github.com/standardnotes/app/commit/9a99cc8df2d187ec7451b24c0ddd746008ea6952))
* sync with master branch ([4de62de](https://github.com/standardnotes/app/commit/4de62deaf033e18f89afba2ddd7417c0c4550728))
* syncing-server-demo url ([f5c6eaf](https://github.com/standardnotes/app/commit/f5c6eafbc01a5bdcba7d94568cfb2e17f0c5fe9d))
* system smart tags on empty account ([#796](https://github.com/standardnotes/app/issues/796)) ([f543bbe](https://github.com/standardnotes/app/commit/f543bbe507f00032561f7a78cf96d3976f8634e9))
* tag context menu ([#893](https://github.com/standardnotes/app/issues/893)) ([68daa21](https://github.com/standardnotes/app/commit/68daa216aabc383932fe942fa64d7156e423afd6))
* tag context menu ([#893](https://github.com/standardnotes/app/issues/893)) ([5265a0d](https://github.com/standardnotes/app/commit/5265a0d01076c0661520cc11815fb8490ef6f9c8))
* tag drag-n-drop intercepted by files drag-n-drop ([#997](https://github.com/standardnotes/app/issues/997)) ([46582b2](https://github.com/standardnotes/app/commit/46582b2577b439e1d0d404fa9d2f865eb2ddaf6c))
* tag placeholder align ([#819](https://github.com/standardnotes/app/issues/819)) ([86b38e1](https://github.com/standardnotes/app/commit/86b38e104166d88fb7f584ca19ab11b05fdc4aad))
* tag rename to empty string should preserve its original title ([717d52d](https://github.com/standardnotes/app/commit/717d52dd8afab41076ea15488ded6d50d19a659c))
* tag search causing regex exception ([#938](https://github.com/standardnotes/app/issues/938)) ([8265d94](https://github.com/standardnotes/app/commit/8265d94c86160dd0dfa6ffa29c9b20f5059016c5))
* tags container margins ([434ea32](https://github.com/standardnotes/app/commit/434ea3258e26d3fbcc50d641e41a2dd25238e380))
* tags do not count orphan refs ([80bd684](https://github.com/standardnotes/app/commit/80bd684e642441ca388a41cf4deca9709cf56c0b))
* tags menu not opening ([d826af7](https://github.com/standardnotes/app/commit/d826af7b5547b19838fc1c51558da06379bb960c))
* tags state mobx warning ([#821](https://github.com/standardnotes/app/issues/821)) ([829a240](https://github.com/standardnotes/app/commit/829a240f63b4ee78d837f2d7c94e20e7e1d5559b))
* take footer height into account when checking need for tag menu max height ([82730fe](https://github.com/standardnotes/app/commit/82730fe22d4ef099abe3bb3573fa40e33f7ce86f))
* template notes and editors ([0630957](https://github.com/standardnotes/app/commit/0630957ef092ef2c4a3411b456e722ffa9d8fad9))
* the following is done: ([e9406b6](https://github.com/standardnotes/app/commit/e9406b682ef3780bc6255b795b8e33d9e6dd81f2))
* theme entitlement logic ([0369d03](https://github.com/standardnotes/app/commit/0369d0354275915de5f97134d6e2ef046eded422))
* theme sorting in quick settings menu ([#882](https://github.com/standardnotes/app/issues/882)) ([a47556b](https://github.com/standardnotes/app/commit/a47556b8406d2956c839cc4882b0a44d69d3e66c))
* themeManager - access potentially undefined function safely ([c47063e](https://github.com/standardnotes/app/commit/c47063e92a65b10736086fa1d430e39da0bae9bb))
* timed color scheme toast ([#978](https://github.com/standardnotes/app/issues/978)) ([a9bab09](https://github.com/standardnotes/app/commit/a9bab0938b4054accc6dff30ab49757c517c482e))
* timing of editor component view unloading ([fa831f7](https://github.com/standardnotes/app/commit/fa831f775b2dacd4ac80d5f54065eaaae04968f4))
* title sorting ([65f2266](https://github.com/standardnotes/app/commit/65f22669f6e208cc9361d194f42e891c312a6342))
* TLD from .ORG to .COM ([f80dc08](https://github.com/standardnotes/app/commit/f80dc08058d5ee6cc1c0fee7b5def7aa185a27b3))
* toolbar change editor menu not updating ([#909](https://github.com/standardnotes/app/issues/909)) ([263640d](https://github.com/standardnotes/app/commit/263640d47628320c1ad1a3c5f27bba20ab31f135))
* Two-factor activation modal ([#736](https://github.com/standardnotes/app/issues/736)) ([08cd020](https://github.com/standardnotes/app/commit/08cd02040272ea0e950fc3b621e9855e0b372426))
* type error ([786f668](https://github.com/standardnotes/app/commit/786f668669ae61d67d4eaafc77effcbe008e9ff4))
* type error ([ac5c36a](https://github.com/standardnotes/app/commit/ac5c36ab6633b8ed59d47a7a1aad09f831648ab7))
* types ([0d38734](https://github.com/standardnotes/app/commit/0d387349d7fe3f54087952e3c894f14882b6674e))
* typescript errors ([2fb6adb](https://github.com/standardnotes/app/commit/2fb6adb6ea59d25d5be6da12cc3b37e1ff734054))
* TypeScript errors after upgrading SNJS ([e1f590f](https://github.com/standardnotes/app/commit/e1f590f2f04119dba3a1d12a8c981c0c25d4a14c))
* typo ([0e67f78](https://github.com/standardnotes/app/commit/0e67f782596e8b125e165569ba78e625dbf52bf0))
* typo ([1727c03](https://github.com/standardnotes/app/commit/1727c03826625290e604127d9ccd446039bc6ab2))
* typo in function name ([0928e39](https://github.com/standardnotes/app/commit/0928e3944cffda354ca96255f3e7a46aee15f051))
* typo in reload-ext-data ([0ff9d3d](https://github.com/standardnotes/app/commit/0ff9d3d4e1d65a343c1b7a527ddd37d337e0403d))
* typo on parent check ([#811](https://github.com/standardnotes/app/issues/811)) ([b0544dc](https://github.com/standardnotes/app/commit/b0544dc2ef295ea881eaf3ce4c8f2f4e35bd3af1))
* UI shiting when opening dropdown with a lot of items ([#764](https://github.com/standardnotes/app/issues/764)) ([e6087de](https://github.com/standardnotes/app/commit/e6087de709183cc53880ad073ac20b89818b866b))
* unmount application view when ephemeral identifier changes ([b549cc3](https://github.com/standardnotes/app/commit/b549cc38bfb1da2927309e44161c08b7558eb48f))
* unmount component on destroy ([ba4fbd1](https://github.com/standardnotes/app/commit/ba4fbd1c0a922fa0c612174e1bac6b898f182156))
* unsubscribe streamItems on deinit ([#453](https://github.com/standardnotes/app/issues/453)) ([b1cde83](https://github.com/standardnotes/app/commit/b1cde8308f15f8103b0e9cfb498d6c8ba9a7bcb1))
* update assets paths ([864cc41](https://github.com/standardnotes/app/commit/864cc414ea9b6449334b8420e70640e75a3993c7))
* update babel to support node v14 ([#429](https://github.com/standardnotes/app/issues/429)) ([adea315](https://github.com/standardnotes/app/commit/adea31502090ba9cddf30aef887505920a68d42e))
* update comment for textareaUnloading ([159f8f3](https://github.com/standardnotes/app/commit/159f8f381cb4e5bbe5ef57e26d784694ec6e9807))
* update CSP to allow action bar to download notes ([964c6f1](https://github.com/standardnotes/app/commit/964c6f135794ff6b65c0a9dea6ab7e788cece96b))
* update encryption status after a passcode operation completes ([3ac8630](https://github.com/standardnotes/app/commit/3ac863098f5f54eee2e9895e8f2b8578ebc6f9ef))
* update filepicker to latest version ([c6ed953](https://github.com/standardnotes/app/commit/c6ed9534fb6be8ddc879d53138dc75b5f50e728e))
* update mobx, preferences can be open multiple times ([#604](https://github.com/standardnotes/app/issues/604)) ([d4bc026](https://github.com/standardnotes/app/commit/d4bc026b04754b9b512057c5d5c65418934ea3e3))
* update monospaceFont in editor template ([a75f1b8](https://github.com/standardnotes/app/commit/a75f1b8d526e9d1ace87c6a212ae846a3c36d470))
* update poll interval ([c09a2f0](https://github.com/standardnotes/app/commit/c09a2f02c2ac7842131955931252b3cad4bd4fc4))
* update selected notes count when deleting multiple notes permanently ([#808](https://github.com/standardnotes/app/issues/808)) ([f2d013b](https://github.com/standardnotes/app/commit/f2d013b5e1ce9a5f6163320c45845e661fcae1d4))
* update snjs ([8936151](https://github.com/standardnotes/app/commit/893615157bb0c934e92832b867d98ae5e7e6e114))
* update snjs to 2.14.14 ([#684](https://github.com/standardnotes/app/issues/684)) ([29b72c7](https://github.com/standardnotes/app/commit/29b72c71cf9c21c00ce71da7a9a2889fdcc573a0))
* updated "editing disabled" banner ([#1037](https://github.com/standardnotes/app/issues/1037)) ([079140e](https://github.com/standardnotes/app/commit/079140eb924aef83f1c8ec7dd7468009fa7ccad3))
* updated @standardnotes/components to latest version ([53f7aa4](https://github.com/standardnotes/app/commit/53f7aa4f4c9874ee44d6ff9a76ffe2d0d57ddd2f))
* updated ddtrace bundle ([92a737e](https://github.com/standardnotes/app/commit/92a737eee799454bd3db9e7cdb9d429e7b63f65b))
* upgrade deps to introduce PKCE sign in ([9f11b02](https://github.com/standardnotes/app/commit/9f11b02e4aeeb20e91540a2ef26158ac7319e6ba))
* upgrade sncrypto-web for base64 url encode without padding ([e9aafbb](https://github.com/standardnotes/app/commit/e9aafbbe000dfc3e8f79f4a5d36ec805fa789b24))
* upgrade snjs to allow demo to access dev extensions server ([36588c1](https://github.com/standardnotes/app/commit/36588c102fc992615366de793ad4d414ff4c44ba))
* upon extension error, loading spinner should be removed ([#461](https://github.com/standardnotes/app/issues/461)) ([6717907](https://github.com/standardnotes/app/commit/6717907dd36f59dff623524b6b99bed5ee8c0df8))
* use absolute component paths ([f405333](https://github.com/standardnotes/app/commit/f4053338981528c3c5bf15eb72285f981485e0a0))
* use break-word for note list item title; closes [#873](https://github.com/standardnotes/app/issues/873) ([#875](https://github.com/standardnotes/app/issues/875)) ([3373a47](https://github.com/standardnotes/app/commit/3373a47da41b9dd9c499277dbf206ebfeedebc4f))
* use component displayName property ([e52e2da](https://github.com/standardnotes/app/commit/e52e2daf39761c64c32658d7d4554436025febbf))
* use confirmDialog ([ee49d80](https://github.com/standardnotes/app/commit/ee49d80cebe89ccdebf8a121963fff10c20a4239))
* use correct close icon size ([523feff](https://github.com/standardnotes/app/commit/523feff6c80d102d6503d7b8ad07b8518e3a07c4))
* use correct variable for password confirmation value ([7fab733](https://github.com/standardnotes/app/commit/7fab73395d86c346a2cf45014722912dbf20f3ff))
* use ellipsis for tags text in dropdown ([af3bed8](https://github.com/standardnotes/app/commit/af3bed850e0545bfac0488fcbbc8c4d34eb90a79))
* use enable unfinished features env var to set enableV4 ([1190ebb](https://github.com/standardnotes/app/commit/1190ebbe41e69e05424e5ef736d463b61a91d9fc))
* use full path when searching autocomplete tags ([78ec092](https://github.com/standardnotes/app/commit/78ec092bf0fb8bef4139a5dce3ab1b64b8488ca1))
* use more widely compatible css for sign in/register button margins ([b1cf0bd](https://github.com/standardnotes/app/commit/b1cf0bd515c812e00f23c13f115e307645aace75))
* use neutral instead of subtle for text ([e1a5dde](https://github.com/standardnotes/app/commit/e1a5dde9687f8649e029c2cad03d8f709b3e2ac3))
* use npm ci ([8aaaf31](https://github.com/standardnotes/app/commit/8aaaf31bd485c9ecf3f9c6d13c71f1ba09016d1d))
* use portal to make sure ellipsis menu opens on top of note list ([e4d7023](https://github.com/standardnotes/app/commit/e4d70239f63d8cc112376aacb9361b1ed9641c2f))
* use register/deregister for editors instead of activate/deactivate ([696f34b](https://github.com/standardnotes/app/commit/696f34b788f308b70ad084284e411f712d729d8e))
* use removeFromArray ([7d313d2](https://github.com/standardnotes/app/commit/7d313d210495b86e160ea9ee09cc787ca09f6a76))
* use SNApplication.toggleComponent ([57643ee](https://github.com/standardnotes/app/commit/57643eededa8c086decfe753d3db09e8f8d78c1f))
* use SNJS duplicateItem for restoring as copy ([fff0ae1](https://github.com/standardnotes/app/commit/fff0ae131390d1528fdd30e1a193fbabfbe07cb3))
* use snjs proper types location ([78e4ae0](https://github.com/standardnotes/app/commit/78e4ae0a1655271c552aeef79409159e5a021fc9))
* use theme-modifiable colors ([#658](https://github.com/standardnotes/app/issues/658)) ([0918425](https://github.com/standardnotes/app/commit/091842555f78764e48ba033d38401d382935ee7d))
* user preferences ([1924308](https://github.com/standardnotes/app/commit/19243082e27e2d604142629897bc9fe9d65af840))
* video preview csp error ([#992](https://github.com/standardnotes/app/issues/992)) ([9b47f2e](https://github.com/standardnotes/app/commit/9b47f2e2352484adddbbd0bb68e4771cc91149d8))
* view note on protected notes warning not dismissing warning ([083d8f5](https://github.com/standardnotes/app/commit/083d8f592ef94d853c677ce399e7eb0f636ee995))
* wait for angular document ready ([a6991b1](https://github.com/standardnotes/app/commit/a6991b140f13d50bf351af9ef1d599754425b6f2))
* wait for CompletedFullSync before showing "No Notes." ([5c98633](https://github.com/standardnotes/app/commit/5c986338a873c0ac042fb3d76a2baeeec2110d69))
* when importing should prompt for password if keyParams is present ([8787e12](https://github.com/standardnotes/app/commit/8787e1264d9ae08d99087eddeaff80b78a554779))
* Width transition on manually resizing sections ([#759](https://github.com/standardnotes/app/issues/759)) ([d7c36da](https://github.com/standardnotes/app/commit/d7c36da2b2e79c5f1138c9bd47ec2554a5b376aa))
* window property ([7f12f93](https://github.com/standardnotes/app/commit/7f12f9349a3cedbf7702875112179c2ad64d4deb))
* wording ([117d414](https://github.com/standardnotes/app/commit/117d414d6b9c0ecb7f93879230418a7fd168c625))
* wording ([31fcae4](https://github.com/standardnotes/app/commit/31fcae4ed2eec8e6d66cd640c86cb4e0966e931c))
* wording ([4c060c0](https://github.com/standardnotes/app/commit/4c060c0ae1524d11368dd41d64f13e2aefe4105c))
* workspace signout all ([abe9b70](https://github.com/standardnotes/app/commit/abe9b70525825b9fc5df22ed2522b118c7e54b08))
* zip decrypted backup items together as one file ([79d48b7](https://github.com/standardnotes/app/commit/79d48b7e077394dcf577438bcc54720ceddb8a87))
