@file:OptIn(ExperimentalCoroutinesApi::class)

package com.sosauce.cutemusic.domain.repository

import android.content.Context
import android.provider.MediaStore
import com.sosauce.cutemusic.data.AbstractTracksScanner
import com.sosauce.cutemusic.data.models.Album
import kotlinx.coroutines.ExperimentalCoroutinesApi
import kotlin.random.Random

class AlbumsRepository(
    private val context: Context,
    private val abstractTracksScanner: AbstractTracksScanner
) {


    fun fetchLatestAlbumTracks(albumName: String) = abstractTracksScanner.fetchLatestTracks(
        extraSelection = "${MediaStore.Audio.Media.ALBUM} = ?",
        extraSelectionArgs = arrayOf(albumName)
    )

    fun fetchAlbums(): List<Album> {
        val albums = mutableListOf<Album>()

        val projection = arrayOf(
            MediaStore.Audio.Albums._ID,
            MediaStore.Audio.Albums.ALBUM,
            MediaStore.Audio.Albums.ARTIST
        )
        context.contentResolver.query(
            MediaStore.Audio.Albums.EXTERNAL_CONTENT_URI,
            projection,
            null,
            null,
            "${MediaStore.Audio.Albums.ALBUM} ASC",
        )?.use { cursor ->
            val idColumn = cursor.getColumnIndexOrThrow(MediaStore.Audio.Albums._ID)
            val albumColumn = cursor.getColumnIndexOrThrow(MediaStore.Audio.Albums.ALBUM)
            val artistColumn = cursor.getColumnIndexOrThrow(MediaStore.Audio.Albums.ARTIST)

            while (cursor.moveToNext()) {
                val id = cursor.getLong(idColumn)
                val album = cursor.getString(albumColumn)
                val artist = cursor.getString(artistColumn)
                val albumInfo = Album(id, album, artist)
                albums.add(albumInfo)
            }
        }

        return albums.distinctBy { it.name }
    }

    fun fetchAlbumDetails(albumName: String): Album {
        context.contentResolver.query(
            MediaStore.Audio.Albums.EXTERNAL_CONTENT_URI,
            arrayOf(
                MediaStore.Audio.Albums._ID,
                MediaStore.Audio.Albums.ALBUM,
                MediaStore.Audio.Albums.ARTIST
            ),
            "${MediaStore.Audio.Albums.ALBUM} = ?",
            arrayOf(albumName),
            null
        )?.use { cursor ->
            val idColumn = cursor.getColumnIndexOrThrow(MediaStore.Audio.Albums._ID)
            val nameColumn = cursor.getColumnIndexOrThrow(MediaStore.Audio.Albums.ALBUM)
            val artistColumn = cursor.getColumnIndexOrThrow(MediaStore.Audio.Albums.ARTIST)

            while (cursor.moveToFirst()) {
                val id = cursor.getLong(idColumn)
                val name = cursor.getString(nameColumn)
                val artist = cursor.getString(artistColumn)

                return Album(
                    id = id,
                    name = name,
                    artist = artist
                )
            }
        }

        return Album(Random.nextLong())
    }

}