package com.sleeptimer;

import android.app.admin.DevicePolicyManager;
import android.content.ComponentName;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.widget.Button;
import android.widget.CompoundButton;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.SwitchCompat;
import androidx.appcompat.widget.Toolbar;

public class settings extends AppCompatActivity {
    private DevicePolicyManager devicePolicyManager;
    private ComponentName compName;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        final SharedPreferences settings = getSharedPreferences("preferences", 0);
        boolean designLight = false;
        if (settings.contains("designlight")) designLight = settings.getBoolean("designlight", false);
        if (designLight) setTheme(R.style.ThemeOverlay_AppCompat_Light);
        else setTheme(R.style.ThemeOverlay_AppCompat_Dark);
        setContentView(R.layout.activity_settings);

        Toolbar toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        devicePolicyManager = (DevicePolicyManager) getSystemService(DEVICE_POLICY_SERVICE);
        compName = new ComponentName(this, MyAdmin.class);
        SwitchCompat adminRights = findViewById(R.id.switch1);
        adminRights.setOnCheckedChangeListener(change);
        boolean active = devicePolicyManager.isAdminActive(compName);
        adminRights.setChecked(active);
        SwitchCompat theme = findViewById(R.id.theme);
        theme.setChecked(designLight);
        theme.setOnCheckedChangeListener(designChange);

        final Button ok = findViewById(R.id.okb);
        ok.setOnClickListener(v -> finish());
    }



    private final SwitchCompat.OnCheckedChangeListener change = new CompoundButton.OnCheckedChangeListener() {
        @Override
        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (isChecked) {
                Intent intent = new Intent(DevicePolicyManager.ACTION_ADD_DEVICE_ADMIN);
                intent.putExtra(DevicePolicyManager.EXTRA_DEVICE_ADMIN, compName);
                intent.putExtra(DevicePolicyManager.EXTRA_ADD_EXPLANATION, R.string.rechte2);
                startActivity(intent);
            } else {
                devicePolicyManager.removeActiveAdmin(compName);
            }
        }
    };

    private final CompoundButton.OnCheckedChangeListener designChange = (compoundButton, isChecked) -> {
        SharedPreferences settings = getSharedPreferences("preferences", 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putBoolean("designlight", isChecked);
        editor.apply();
        Intent intent = getIntent();
        finish();
        startActivity(intent);
    };


}
