package com.sleeptimer;

import android.app.PendingIntent;
import android.content.Intent;
import android.graphics.drawable.Icon;
import android.os.Build;
import android.service.quicksettings.Tile;
import android.service.quicksettings.TileService;


public class quickPreferences extends TileService {

    public void onClick(){
        Tile tile = getQsTile();
        tile.setIcon(Icon.createWithResource(getApplicationContext(),R.mipmap.ic_notification));
        if (MainActivity.hours == 0 && MainActivity.minutes == 0 && MainActivity.seconds == 0) {
            Intent intent = new Intent(this, MainActivity.class);
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            PendingIntent aPendingIntent = PendingIntent.getActivity(this, 0, intent, PendingIntent.FLAG_IMMUTABLE);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.UPSIDE_DOWN_CAKE) {
                startActivityAndCollapse(aPendingIntent);
            }
            else startActivityAndCollapse(intent);
        } else if (!MainActivity.counteractive){
            MainActivity.counter.start();
            MainActivity.counteractive = true;
            tile.setState(Tile.STATE_ACTIVE);
            tile.updateTile();
        } else {
            MainActivity.counter.cancel();
            MainActivity.counteractive = false;
            tile.setState(Tile.STATE_INACTIVE);
            tile.updateTile();
        }

    }

    public  void onStartListening(){
        Tile tile = getQsTile();
        if (MainActivity.counteractive)  {
            tile.setState(Tile.STATE_ACTIVE);
        }
        else  {
            tile.setState(Tile.STATE_INACTIVE);
        }
        tile.updateTile();
    }


}
