package com.sleeptimer;

import static android.Manifest.permission.POST_NOTIFICATIONS;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.admin.DevicePolicyManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.media.AudioManager;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.app.ActivityCompat;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;

public class MainActivity extends AppCompatActivity {
    public static int seconds, minutes, hours;
    public boolean doStartStop = false;
    public static CountDownTimer counter;
    public static boolean designLight = false;
    public int originalVolume = -1;



    private final View.OnClickListener resetAction = new View.OnClickListener() {
        @Override
        public void onClick(View view) {
            final EditText secondsInput = findViewById(R.id.seconds);
            final EditText minutesInput = findViewById(R.id.minutes);
            final EditText hoursInput = findViewById(R.id.hours);
            Button resetButton = findViewById(R.id.resetbutton);
            Button startButton = findViewById(R.id.starttimerbutton);
            resetButton.setEnabled(false);
            startButton.setText(R.string.start_text);
            secondsInput.setText("0");
            minutesInput.setText("0");
            hoursInput.setText("0");
            secondsInput.setEnabled(true);
            minutesInput.setEnabled(true);
            hoursInput.setEnabled(true);
            counter.cancel();
            counter = null;
            counteractive = false;
            hours   = 0;
            minutes = 0;
            seconds = 0;
            final NotificationManagerCompat notificationManager = NotificationManagerCompat.from(getApplicationContext());
            notificationManager.cancel(1212);
            if (originalVolume != -1) {
                AudioManager am = (AudioManager) getSystemService(Context.AUDIO_SERVICE);
                am.setStreamVolume(AudioManager.STREAM_MUSIC, originalVolume, AudioManager.FLAG_SHOW_UI);
            }

        }
    };

    public static boolean counteractive = false;
    private DevicePolicyManager devicePolicyManager;
    private ComponentName compName;

    private final View.OnClickListener startSleepTimer = new View.OnClickListener() {
        @Override
        public void onClick(View view) {
            boolean active = devicePolicyManager.isAdminActive(compName);
            if (!active) {
                Toast.makeText(getApplicationContext(),R.string.rechte3,Toast.LENGTH_LONG).show();
                return;
            }
            final Button timerStart = findViewById(R.id.starttimerbutton);
            Button resetTimer = findViewById(R.id.resetbutton);
            if (timerStart.getText().toString().equals(getResources().getString(R.string.pause_text))) {
                counter.cancel();
                counteractive = false;
                timerStart.setText(R.string.resume_text);
                resetTimer.setEnabled(true);
            } else if (timerStart.getText().toString().equals(getResources().getString(R.string.resume_text))) {
                counter.start();
                counteractive = true;
                timerStart.setText(R.string.pause_text);
                resetTimer.setEnabled(false);
            } else {
                resetTimer.setEnabled(false);
                final EditText secondsInput = findViewById(R.id.seconds);
                final EditText minutesInput = findViewById(R.id.minutes);
                final EditText hoursInput = findViewById(R.id.hours);
                seconds = Integer.parseInt(secondsInput.getText().toString());
                minutes = Integer.parseInt(minutesInput.getText().toString());
                hours = Integer.parseInt(hoursInput.getText().toString());
                minutesInput.clearFocus();
                secondsInput.clearFocus();
                secondsInput.clearFocus();
                secondsInput.setEnabled(false);
                minutesInput.setEnabled(false);
                hoursInput.setEnabled(false);
                timerStart.setText(R.string.pause_text);

                final NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(getApplicationContext(),"1212");
                mBuilder.setSmallIcon(R.mipmap.ic_notification);
                mBuilder.setColor(Color.blue(Color.MAGENTA));
                mBuilder.setBadgeIconType(NotificationCompat.BADGE_ICON_SMALL);
                mBuilder.setContentTitle(getString(R.string.notifikation));
                mBuilder.setContentText(hoursInput.getText()+":"+minutesInput.getText()+":"+secondsInput.getText());
                mBuilder.setOnlyAlertOnce(true);
                Intent intent = getIntent();
                PendingIntent notifyPendingIntent = PendingIntent.getActivity(MainActivity.this, 0, intent, PendingIntent.FLAG_IMMUTABLE);
                mBuilder.setContentIntent(notifyPendingIntent);
                final NotificationManagerCompat notificationManager = NotificationManagerCompat.from(getApplicationContext());
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
                    if (ActivityCompat.checkSelfPermission(MainActivity.this, POST_NOTIFICATIONS) != PackageManager.PERMISSION_GRANTED) {
                        String[] permission = new String[]{POST_NOTIFICATIONS};
                        ActivityCompat.requestPermissions(MainActivity.this, permission, 321);
                    }
                }
                notificationManager.notify(1212, mBuilder.build());
                hoursInput.clearFocus();
                timerStart.requestFocus();


                int sleepTime = seconds; // sleepTime=seconds+minutes+hours     unit: seconds
                if (hours > 0) minutes += 60 * hours;
                if (minutes > 0) sleepTime += 60 * minutes;
                if (hours > 0) minutes -= 60 * hours;
                counteractive=true;
                counter = new CountDownTimer(sleepTime * 1000L, 1000) {
                    public void onTick(long millisUntilFinished) {

                        if (seconds == 0 & minutes > 0) {
                            seconds = 60;
                            minutes--;
                            minutesInput.setText(String.valueOf(minutes));
                        } else if (seconds > 0) seconds--;

                        if (minutes == 0 & hours > 0) {
                            minutes = 60;
                            hours--;
                            hoursInput.setText(String.valueOf(hours));
                            minutesInput.setText(String.valueOf(minutes));
                        }

                        secondsInput.setText(String.valueOf(seconds));
                        secondsInput.clearFocus();
                        mBuilder.setContentText(hours +":"+ minutes +":"+ seconds);
                        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
                            if (ActivityCompat.checkSelfPermission(MainActivity.this, POST_NOTIFICATIONS) != PackageManager.PERMISSION_GRANTED) {
                                String[] permission = new String[]{POST_NOTIFICATIONS};
                                ActivityCompat.requestPermissions(MainActivity.this, permission, 321);
                            }
                        }
                        notificationManager.notify(1212, mBuilder.build());

                        if (hours == 0 && minutes == 0 && seconds <= 10) {
                            AudioManager am = (AudioManager) getSystemService(Context.AUDIO_SERVICE);
                            if (originalVolume == -1) originalVolume = am.getStreamVolume(AudioManager.STREAM_MUSIC);
                            am.adjustVolume(AudioManager.ADJUST_LOWER,AudioManager.FLAG_SHOW_UI);
                        }
                    }

                    public void onFinish() {
                        if (!doStartStop){
                            secondsInput.setText("0");
                        boolean active = devicePolicyManager.isAdminActive(compName);
                        counteractive=false;
                        timerStart.setEnabled(true);
                        secondsInput.setEnabled(true);
                        minutesInput.setEnabled(true);
                        hoursInput.setEnabled(true);
                        timerStart.setText(R.string.start_text);
                        AudioManager.OnAudioFocusChangeListener focusChangeListener =
                                focusChange -> {
                                    AudioManager am = (AudioManager) getSystemService(Context.AUDIO_SERVICE);
                                };
                        AudioManager am = (AudioManager) getSystemService(Context.AUDIO_SERVICE);
                        // Request audio focus (for standby)
                        am.requestAudioFocus(focusChangeListener, AudioManager.STREAM_MUSIC, AudioManager.AUDIOFOCUS_GAIN);
                        if (active) {
                            devicePolicyManager.lockNow();
                        } else {
                            Toast.makeText(getApplicationContext(), R.string.rechte3, Toast.LENGTH_LONG).show();
                        }
                        am.setStreamVolume(AudioManager.STREAM_MUSIC,originalVolume,AudioManager.FLAG_SHOW_UI);
                    }
                        notificationManager.cancel(1212);
                    }


                }.start();


            }
        }
    };


    private void createNotificationChannel() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            CharSequence name = "NAmedeschannels";
            String description = "blabla";
            int importance = NotificationManager.IMPORTANCE_DEFAULT;
            NotificationChannel channel = new NotificationChannel("1212", name, importance);
            channel.setDescription(description);
            NotificationManager notificationManager = getSystemService(NotificationManager.class);
            notificationManager.createNotificationChannel(channel);
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        final SharedPreferences settings = getSharedPreferences("preferences", 0);
        if (settings.contains("designlight")) designLight = settings.getBoolean("designlight", false);
        if (designLight) setTheme(R.style.ThemeOverlay_AppCompat_Light);
        else setTheme(R.style.ThemeOverlay_AppCompat_Dark);
        setContentView(R.layout.activity_main);
        Toolbar toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        devicePolicyManager = (DevicePolicyManager) getSystemService(DEVICE_POLICY_SERVICE);
        compName = new ComponentName(this, MyAdmin.class);

        createNotificationChannel();

        Button starttimerbutton, resetbutton;
        starttimerbutton = findViewById(R.id.starttimerbutton);
        resetbutton = findViewById(R.id.resetbutton);
        starttimerbutton.setOnClickListener(startSleepTimer);
        resetbutton.setOnClickListener(resetAction);
        boolean active = devicePolicyManager.isAdminActive(compName);
        if (!active) {
            Intent intent = new Intent(DevicePolicyManager.ACTION_ADD_DEVICE_ADMIN);
            intent.putExtra(DevicePolicyManager.EXTRA_DEVICE_ADMIN, compName);
            intent.putExtra(DevicePolicyManager.EXTRA_ADD_EXPLANATION, R.string.rechte2);
            startActivity(intent);
        }


    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();
        if (id == R.id.action_settings) {
                Intent intent = new Intent(MainActivity.this, settings.class);
                startActivity(intent);
            return true;
        }
        if (id == R.id.action_about) {
            Intent intent = new Intent(MainActivity.this, about.class);
            startActivity(intent);
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

   @Override
    public void onBackPressed() {
        // don't call super to resume on notification click
        moveTaskToBack(true);
    }


    @Override
    public void onResume() {
        super.onResume();
        SharedPreferences settings = getSharedPreferences("preferences", 0);
        Button pauseButton = findViewById(R.id.starttimerbutton);
        if (!counteractive && pauseButton.getText().toString().equals(getResources().getString(R.string.pause_text)))
            pauseButton.setText(R.string.resume_text);
        else if (counteractive && pauseButton.getText().toString().equals(getResources().getString(R.string.resume_text)))
            pauseButton.setText(R.string.pause_text);
        if (settings.contains("designlight")) {
            if (!(settings.getBoolean("designlight", true) == designLight)) {
                Intent intent = getIntent();
                finish();
                startActivity(intent);
            }
        }
    }

}
