package com.simpol.permissionssummary

import android.content.Context
import androidx.datastore.preferences.core.edit
import androidx.datastore.preferences.core.stringSetPreferencesKey
import androidx.datastore.preferences.preferencesDataStore
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.map

val Context.dataStore by preferencesDataStore("trusted_apps")

class TrustedAppsDataStore(private val context: Context) {
    private val TRUSTED_APPS_KEY = stringSetPreferencesKey("trusted_apps")

    val trustedApps: Flow<Set<String>> = context.dataStore.data.map { prefs ->
        prefs[TRUSTED_APPS_KEY] ?: emptySet()
    }

    suspend fun saveTrustedApps(apps: Set<String>) {
        context.dataStore.edit { prefs ->
            prefs[TRUSTED_APPS_KEY] = apps
        }
    }
}
