package com.simpol.permissionssummary

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.CalendarToday
import androidx.compose.material.icons.filled.Call
import androidx.compose.material.icons.filled.CameraAlt
import androidx.compose.material.icons.filled.Folder
import androidx.compose.material.icons.filled.LocationOn
import androidx.compose.material.icons.filled.Message
import androidx.compose.material.icons.filled.Mic
import androidx.compose.material.icons.filled.MusicNote
import androidx.compose.material.icons.filled.Person
import androidx.compose.material.icons.filled.Phone
import androidx.compose.material.icons.filled.Photo
import androidx.compose.material.icons.filled.Sensors
import androidx.compose.ui.graphics.vector.ImageVector

object Constants {

    // manual permissions grouping
    val permissionMapping: Map<String, String> =
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.TIRAMISU) {
            mapOf(
                // Camera
                android.Manifest.permission.CAMERA to "Camera",

                // Microphone
                android.Manifest.permission.RECORD_AUDIO to "Microphone",

                // Location
                android.Manifest.permission.ACCESS_FINE_LOCATION to "Location",
                android.Manifest.permission.ACCESS_COARSE_LOCATION to "Location",

                // Media (Android 13+)
                android.Manifest.permission.READ_MEDIA_IMAGES to "Storage (Photos and Videos)",
                android.Manifest.permission.READ_MEDIA_VIDEO to "Storage (Photos and Videos)",
                android.Manifest.permission.READ_MEDIA_AUDIO to "Storage (Music and Sound)",

                // Contacts
                android.Manifest.permission.READ_CONTACTS to "Contacts",
                android.Manifest.permission.WRITE_CONTACTS to "Contacts",
                android.Manifest.permission.GET_ACCOUNTS to "Contacts",

                // Calendar
                android.Manifest.permission.READ_CALENDAR to "Calendar",
                android.Manifest.permission.WRITE_CALENDAR to "Calendar",

                // Call Log
                android.Manifest.permission.READ_CALL_LOG to "Call Log",
                android.Manifest.permission.WRITE_CALL_LOG to "Call Log",
                android.Manifest.permission.PROCESS_OUTGOING_CALLS to "Call Log",

                // Phone
                android.Manifest.permission.READ_PHONE_STATE to "Phone",
                android.Manifest.permission.READ_PHONE_NUMBERS to "Phone",
                android.Manifest.permission.CALL_PHONE to "Phone",
                android.Manifest.permission.ANSWER_PHONE_CALLS to "Phone",
                android.Manifest.permission.ADD_VOICEMAIL to "Phone",
                android.Manifest.permission.USE_SIP to "Phone",
                android.Manifest.permission.ACCEPT_HANDOVER to "Phone",

                // SMS
                android.Manifest.permission.SEND_SMS to "SMS",
                android.Manifest.permission.RECEIVE_SMS to "SMS",
                android.Manifest.permission.READ_SMS to "SMS",
                android.Manifest.permission.RECEIVE_WAP_PUSH to "SMS",
                android.Manifest.permission.RECEIVE_MMS to "SMS",

                // Sensors
                android.Manifest.permission.BODY_SENSORS to "Sensors"
            )
        } else {
            mapOf(
                // Camera
                android.Manifest.permission.CAMERA to "Camera",

                // Microphone
                android.Manifest.permission.RECORD_AUDIO to "Microphone",

                // Location
                android.Manifest.permission.ACCESS_FINE_LOCATION to "Location",
                android.Manifest.permission.ACCESS_COARSE_LOCATION to "Location",

                // Legacy storage
                android.Manifest.permission.READ_EXTERNAL_STORAGE to "Storage",
                android.Manifest.permission.WRITE_EXTERNAL_STORAGE to "Storage",

                // Contacts
                android.Manifest.permission.READ_CONTACTS to "Contacts",
                android.Manifest.permission.WRITE_CONTACTS to "Contacts",
                android.Manifest.permission.GET_ACCOUNTS to "Contacts",

                // Calendar
                android.Manifest.permission.READ_CALENDAR to "Calendar",
                android.Manifest.permission.WRITE_CALENDAR to "Calendar",

                // Call Log
                android.Manifest.permission.READ_CALL_LOG to "Call Log",
                android.Manifest.permission.WRITE_CALL_LOG to "Call Log",
                android.Manifest.permission.PROCESS_OUTGOING_CALLS to "Call Log",

                // Phone
                android.Manifest.permission.READ_PHONE_STATE to "Phone",
                android.Manifest.permission.READ_PHONE_NUMBERS to "Phone",
                android.Manifest.permission.CALL_PHONE to "Phone",
                android.Manifest.permission.ANSWER_PHONE_CALLS to "Phone",
                android.Manifest.permission.ADD_VOICEMAIL to "Phone",
                android.Manifest.permission.USE_SIP to "Phone",
                android.Manifest.permission.ACCEPT_HANDOVER to "Phone",

                // SMS
                android.Manifest.permission.SEND_SMS to "SMS",
                android.Manifest.permission.RECEIVE_SMS to "SMS",
                android.Manifest.permission.READ_SMS to "SMS",
                android.Manifest.permission.RECEIVE_WAP_PUSH to "SMS",
                android.Manifest.permission.RECEIVE_MMS to "SMS",

                // Sensors
                android.Manifest.permission.BODY_SENSORS to "Sensors"
            )
        }


    // custom icons
    val groupIcons: Map<String, ImageVector> = mapOf(
        "Camera" to Icons.Default.CameraAlt,
        "Microphone" to Icons.Default.Mic,
        "Storage (Photos and Videos)" to Icons.Default.Photo,
        "Storage (Music and Sound)" to Icons.Default.MusicNote,
        "Storage" to Icons.Default.Folder,
        "Location" to Icons.Default.LocationOn,
        "Contacts" to Icons.Default.Person,
        "Calendar" to Icons.Default.CalendarToday,
        "Call Log" to Icons.Default.Call,
        "Phone" to Icons.Default.Phone,
        "SMS" to Icons.Default.Message,
        "Sensors" to Icons.Default.Sensors
    )
}